/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.dbgp.tests;

import junit.framework.TestCase;
import org.eclipse.dltk.dbgp.internal.DbgpRequest;

public class DbgpRequestTests
extends TestCase {
    private DbgpRequest request;

    protected void setUp() throws Exception {
        super.setUp();
        this.request = new DbgpRequest("test_command");
    }

    public void testOptions() {
        this.request.addOption("-t", 324);
        DbgpRequestTests.assertTrue((boolean)this.request.hasOption("-t"));
        DbgpRequestTests.assertEquals((String)Integer.toString(324), (String)this.request.getOption("-t"));
        DbgpRequestTests.assertEquals((String)"test_command", (String)this.request.getCommand());
    }

    public void testData() {
        this.request.setData("my_data");
        DbgpRequestTests.assertEquals((String)"my_data", (String)this.request.getData());
    }

    public void testStringRepresentation() {
        this.request.addOption("-i", 324);
        this.request.setData("my_data");
        DbgpRequestTests.assertEquals((String)"test_command -i 324 -- bXlfZGF0YQ==", (String)this.request.toString());
    }

    public void testEquals() {
        DbgpRequest r1 = new DbgpRequest("step_command_xxx");
        r1.addOption("-a", 32);
        r1.addOption("-b", 12);
        r1.setData("my_data");
        DbgpRequest r2 = new DbgpRequest("step_command_xxx");
        r2.setData("my_data");
        r2.addOption("-b", 12);
        r2.addOption("-a", 32);
        DbgpRequestTests.assertEquals((Object)r1, (Object)r2);
        DbgpRequestTests.assertEquals((Object)r2, (Object)r1);
    }
}

