/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.dbgp.tests;

import junit.framework.TestCase;
import org.eclipse.dltk.dbgp.internal.utils.Base64Helper;

public class DbgpBase64Tests
extends TestCase {
    public void testNullAndEmpty() {
        DbgpBase64Tests.assertEquals((String)"", (String)Base64Helper.encodeString(null));
        DbgpBase64Tests.assertEquals((String)"", (String)Base64Helper.encodeString((String)""));
        DbgpBase64Tests.assertEquals((String)"", (String)Base64Helper.decodeString(null));
        DbgpBase64Tests.assertEquals((String)"", (String)Base64Helper.decodeString((String)""));
        DbgpBase64Tests.assertEquals((String)"", (String)Base64Helper.decodeString((String)"\r\n"));
    }

    public void testEndode() {
        DbgpBase64Tests.assertEquals((String)"MTIz", (String)Base64Helper.encodeString((String)"123"));
        DbgpBase64Tests.assertEquals((String)"MTIzNDU2Nzg5", (String)Base64Helper.encodeString((String)"123456789"));
    }

    public void testDecode() {
        DbgpBase64Tests.assertEquals((String)"123", (String)Base64Helper.decodeString((String)"MTIz"));
        DbgpBase64Tests.assertEquals((String)"123456789", (String)Base64Helper.decodeString((String)"MTIzNDU2Nzg5"));
    }

    public void testDecodeChunked() {
        DbgpBase64Tests.assertEquals((String)"123", (String)Base64Helper.decodeString((String)"MTIz"));
        DbgpBase64Tests.assertEquals((String)"123456789", (String)Base64Helper.decodeString((String)"MTIz\nNDU2\nNzg5"));
    }

    public void testLongString() {
        char[] c = new char[256];
        int i = 0;
        while (i < c.length) {
            c[i] = (char)i;
            ++i;
        }
        String input = new String(c);
        String encoded = Base64Helper.encodeString((String)input);
        int chunkCount = (encoded.length() + 64 - 1) / 64;
        StringBuffer chunked = new StringBuffer();
        int i2 = 0;
        while (i2 < chunkCount) {
            int beginIndex = i2 * 64;
            int endIndex = Math.min(encoded.length(), beginIndex + 64);
            chunked.append(encoded.substring(beginIndex, endIndex));
            chunked.append("\r\n");
            ++i2;
        }
        String output = Base64Helper.decodeString((String)chunked.toString());
        DbgpBase64Tests.assertEquals((String)input, (String)output);
    }
}

