/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Method;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaMethod
extends BaseFunction {
    static final long serialVersionUID = -3440381785576412928L;
    private static final int PREFERENCE_EQUAL = 0;
    private static final int PREFERENCE_FIRST_ARG = 1;
    private static final int PREFERENCE_SECOND_ARG = 2;
    private static final int PREFERENCE_AMBIGUOUS = 3;
    private static final boolean debug = false;
    MemberBox[] methods;
    private String functionName;

    NativeJavaMethod(MemberBox[] methods) {
        this.functionName = methods[0].getName();
        this.methods = methods;
    }

    NativeJavaMethod(MemberBox method, String name) {
        this.functionName = name;
        this.methods = new MemberBox[]{method};
    }

    public NativeJavaMethod(Method method, String name) {
        this(new MemberBox(method), name);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    static String scriptSignature(Object[] values) {
        StringBuffer sig = new StringBuffer();
        int i = 0;
        while (i != values.length) {
            String s;
            Object value = values[i];
            if (value == null) {
                s = "null";
            } else if (value instanceof Boolean) {
                s = "boolean";
            } else if (value instanceof String) {
                s = "string";
            } else if (value instanceof Number) {
                s = "number";
            } else if (value instanceof Scriptable) {
                if (value instanceof Undefined) {
                    s = "undefined";
                } else if (value instanceof Wrapper) {
                    Object wrapped = ((Wrapper)value).unwrap();
                    s = wrapped.getClass().getName();
                } else {
                    s = value instanceof Function ? "function" : "object";
                }
            } else {
                s = JavaMembers.javaSignature(value.getClass());
            }
            if (i != 0) {
                sig.append(',');
            }
            sig.append(s);
            ++i;
        }
        return sig.toString();
    }

    String decompile(int indent, int flags) {
        boolean justbody;
        StringBuffer sb = new StringBuffer();
        boolean bl = justbody = (flags & 1) != 0;
        if (!justbody) {
            sb.append("function ");
            sb.append(this.getFunctionName());
            sb.append("() {");
        }
        sb.append("/*\n");
        sb.append(this.toString());
        sb.append(justbody ? "*/\n" : "*/}\n");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int N = this.methods.length;
        while (i != N) {
            Method method = this.methods[i].method();
            sb.append(JavaMembers.javaSignature(method.getReturnType()));
            sb.append(' ');
            sb.append(method.getName());
            sb.append(JavaMembers.liveConnectSignature(this.methods[i].argTypes));
            sb.append('\n');
            ++i;
        }
        return sb.toString();
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object javaObject;
        if (this.methods.length == 0) {
            throw new RuntimeException("No methods defined for call");
        }
        int index = NativeJavaMethod.findFunction(cx, this.methods, args);
        if (index < 0) {
            Class<?> c = this.methods[0].method().getDeclaringClass();
            String sig = String.valueOf(c.getName()) + '.' + this.getFunctionName() + '(' + NativeJavaMethod.scriptSignature(args) + ')';
            throw Context.reportRuntimeError1("msg.java.no_such_method", sig);
        }
        MemberBox meth = this.methods[index];
        Class[] argTypes = meth.argTypes;
        Object[] origArgs = args;
        int i = 0;
        while (i < args.length) {
            Object arg = args[i];
            Object coerced = Context.jsToJava(arg, argTypes[i]);
            if (coerced != arg) {
                if (origArgs == args) {
                    args = (Object[])args.clone();
                }
                args[i] = coerced;
            }
            ++i;
        }
        if (meth.isStatic()) {
            javaObject = null;
        } else {
            Scriptable o = thisObj;
            Class c = meth.getDeclaringClass();
            while (true) {
                if (o == null) {
                    throw Context.reportRuntimeError3("msg.nonjava.method", this.getFunctionName(), ScriptRuntime.toString(thisObj), c.getName());
                }
                if (o instanceof Wrapper && c.isInstance(javaObject = ((Wrapper)((Object)o)).unwrap())) break;
                o = o.getPrototype();
            }
        }
        Object retval = meth.invoke(javaObject, args);
        Class<?> staticType = meth.method().getReturnType();
        Object wrapped = cx.getWrapFactory().wrap(cx, scope, retval, staticType);
        if (wrapped == null && staticType == Void.TYPE) {
            wrapped = Undefined.instance;
        }
        return wrapped;
    }

    static int findFunction(Context cx, MemberBox[] methodsOrCtors, Object[] args) {
        if (methodsOrCtors.length == 0) {
            return -1;
        }
        if (methodsOrCtors.length == 1) {
            MemberBox member = methodsOrCtors[0];
            Class[] argTypes = member.argTypes;
            int alength = argTypes.length;
            if (alength != args.length) {
                return -1;
            }
            int j = 0;
            while (j != alength) {
                if (!NativeJavaObject.canConvert(args[j], argTypes[j])) {
                    return -1;
                }
                ++j;
            }
            return 0;
        }
        int firstBestFit = -1;
        int[] extraBestFits = null;
        int extraBestFitsCount = 0;
        int i = 0;
        while (i < methodsOrCtors.length) {
            block27: {
                MemberBox member = methodsOrCtors[i];
                Class[] argTypes = member.argTypes;
                if (argTypes.length == args.length) {
                    int j = 0;
                    while (j < argTypes.length) {
                        if (NativeJavaObject.canConvert(args[j], argTypes[j])) {
                            ++j;
                            continue;
                        }
                        break block27;
                    }
                    if (firstBestFit < 0) {
                        firstBestFit = i;
                    } else {
                        int betterCount = 0;
                        int worseCount = 0;
                        int j2 = -1;
                        while (j2 != extraBestFitsCount) {
                            int bestFitIndex = j2 == -1 ? firstBestFit : extraBestFits[j2];
                            MemberBox bestFit = methodsOrCtors[bestFitIndex];
                            int preference = NativeJavaMethod.preferSignature(args, argTypes, bestFit.argTypes);
                            if (preference == 3) break;
                            if (preference == 1) {
                                ++betterCount;
                            } else {
                                if (preference != 2) {
                                    if (preference != 0) {
                                        Kit.codeBug();
                                    }
                                    if (bestFit.isStatic() && bestFit.getDeclaringClass().isAssignableFrom(member.getDeclaringClass())) {
                                        if (j2 == -1) {
                                            firstBestFit = i;
                                        } else {
                                            extraBestFits[j2] = i;
                                        }
                                    }
                                    break block27;
                                }
                                ++worseCount;
                            }
                            ++j2;
                        }
                        if (betterCount == 1 + extraBestFitsCount) {
                            firstBestFit = i;
                            extraBestFitsCount = 0;
                        } else if (worseCount != 1 + extraBestFitsCount) {
                            if (extraBestFits == null) {
                                extraBestFits = new int[methodsOrCtors.length - 1];
                            }
                            extraBestFits[extraBestFitsCount] = i;
                            ++extraBestFitsCount;
                        }
                    }
                }
            }
            ++i;
        }
        if (firstBestFit < 0) {
            return -1;
        }
        if (extraBestFitsCount == 0) {
            return firstBestFit;
        }
        StringBuffer buf = new StringBuffer();
        int j = -1;
        while (j != extraBestFitsCount) {
            int bestFitIndex = j == -1 ? firstBestFit : extraBestFits[j];
            buf.append("\n    ");
            buf.append(methodsOrCtors[bestFitIndex].toJavaDeclaration());
            ++j;
        }
        MemberBox firstFitMember = methodsOrCtors[firstBestFit];
        String memberName = firstFitMember.getName();
        String memberClass = firstFitMember.getDeclaringClass().getName();
        if (methodsOrCtors[0].isMethod()) {
            throw Context.reportRuntimeError3("msg.constructor.ambiguous", memberName, NativeJavaMethod.scriptSignature(args), buf.toString());
        }
        throw Context.reportRuntimeError4("msg.method.ambiguous", memberClass, memberName, NativeJavaMethod.scriptSignature(args), buf.toString());
    }

    private static int preferSignature(Object[] args, Class[] sig1, Class[] sig2) {
        int totalPreference = 0;
        int j = 0;
        while (j < args.length) {
            Class type1 = sig1[j];
            Class type2 = sig2[j];
            if (type1 != type2) {
                int rank2;
                Object arg = args[j];
                int rank1 = NativeJavaObject.getConversionWeight(arg, type1);
                int preference = rank1 < (rank2 = NativeJavaObject.getConversionWeight(arg, type2)) ? 1 : (rank1 > rank2 ? 2 : (rank1 == 0 ? (type1.isAssignableFrom(type2) ? 2 : (type2.isAssignableFrom(type1) ? 1 : 3)) : 3));
                if ((totalPreference |= preference) == 3) break;
            }
            ++j;
        }
        return totalPreference;
    }

    private static void printDebug(String msg, MemberBox member, Object[] args) {
    }
}

