/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.hierarchy;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IRegion;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.Region;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.TypeVector;
import org.eclipse.dltk.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.dltk.internal.core.hierarchy.RegionBasedHierarchyBuilder;
import org.eclipse.dltk.internal.core.hierarchy.TypeHierarchy;

public class RegionBasedTypeHierarchy
extends TypeHierarchy {
    protected IRegion region;

    public RegionBasedTypeHierarchy(IRegion region, ISourceModule[] workingCopies, IType type, boolean computeSubtypes) {
        super(type, workingCopies, (IDLTKSearchScope)null, computeSubtypes);
        Region newRegion = new Region(){

            public void add(IModelElement element) {
                if (!this.contains(element)) {
                    this.removeAllChildren(element);
                    this.fRootElements.add(element);
                    if (element.getElementType() == 2) {
                        try {
                            IProjectFragment[] roots = ((IScriptProject)element).getProjectFragments();
                            int i = 0;
                            int length = roots.length;
                            while (i < length) {
                                if (roots[i].isArchive() && !this.fRootElements.contains(roots[i])) {
                                    this.fRootElements.add(roots[i]);
                                }
                                ++i;
                            }
                        }
                        catch (ModelException modelException) {}
                    }
                    this.fRootElements.trimToSize();
                }
            }
        };
        IModelElement[] elements = region.getElements();
        int i = 0;
        int length = elements.length;
        while (i < length) {
            newRegion.add(elements[i]);
            ++i;
        }
        this.region = newRegion;
        if (elements.length > 0) {
            this.project = elements[0].getScriptProject();
        }
    }

    protected void initializeRegions() {
        super.initializeRegions();
        IModelElement[] roots = this.region.getElements();
        int i = 0;
        while (i < roots.length) {
            IModelElement root = roots[i];
            if (root instanceof IOpenable) {
                this.files.put(root, new ArrayList());
            } else {
                Openable o = (Openable)((ModelElement)root).getOpenableParent();
                if (o != null) {
                    this.files.put(o, new ArrayList());
                }
            }
            this.checkCanceled();
            ++i;
        }
    }

    protected void compute() throws ModelException, CoreException {
        RegionBasedHierarchyBuilder builder = new RegionBasedHierarchyBuilder(this);
        ((HierarchyBuilder)builder).build(this.computeSubtypes);
    }

    protected boolean isAffectedByOpenable(IModelElementDelta delta, IModelElement element) {
        if (element instanceof SourceModule && ((SourceModule)element).isWorkingCopy()) {
            return super.isAffectedByOpenable(delta, element);
        }
        if (this.focusType == null) {
            return this.region.contains(element);
        }
        return super.isAffectedByOpenable(delta, element);
    }

    public IScriptProject javaProject() {
        return this.project;
    }

    public void pruneDeadBranches() {
        this.pruneDeadBranches(this.getRootClasses());
    }

    private boolean pruneDeadBranches(IType type) {
        TypeVector subtypes = (TypeVector)this.typeToSubtypes.get(type);
        if (subtypes == null) {
            return true;
        }
        this.pruneDeadBranches(subtypes.copy().elements());
        subtypes = (TypeVector)this.typeToSubtypes.get(type);
        return subtypes == null || subtypes.size == 0;
    }

    private void pruneDeadBranches(IType[] types) {
        int i = 0;
        int length = types.length;
        while (i < length) {
            IType type = types[i];
            if (this.pruneDeadBranches(type) && !this.region.contains(type)) {
                this.removeType(type);
            }
            ++i;
        }
    }

    protected void removeType(IType type) {
        IType[] superclasses;
        IType[] subtypes = this.getSubtypes(type);
        this.typeToSubtypes.remove(type);
        if (subtypes != null) {
            int i = 0;
            while (i < subtypes.length) {
                this.removeType(subtypes[i]);
                ++i;
            }
        }
        if ((superclasses = (IType[])this.classToSuperclass.remove(type)) != null) {
            int i = 0;
            int length = superclasses.length;
            while (i < length) {
                IType superinterface = superclasses[i];
                TypeVector types = (TypeVector)this.typeToSubtypes.get(superinterface);
                if (types != null) {
                    types.remove(type);
                }
                ++i;
            }
        }
    }
}

