/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ast.declarations;

import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.Modifiers;
import org.eclipse.dltk.ast.PositionInformation;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.dltk.utils.CorePrinter;

public abstract class Declaration
extends Statement
implements Modifiers {
    public static final int D_ARGUMENT = 3000;
    public static final int D_CLASS = 3001;
    public static final int D_METHOD = 3002;
    public static final int D_DECLARATOR = 3004;
    protected int nameStart;
    protected int nameEnd;
    protected String name;
    protected int modifiers;

    protected Declaration() {
        this.modifiers = 0;
        this.nameStart = 0;
        this.nameEnd = -1;
    }

    protected Declaration(int start, int end) {
        super(start, end);
        this.modifiers = 0;
    }

    protected Declaration(DLTKToken name, int start, int end) {
        super(start, end);
        if (name != null) {
            this.name = name.getText();
            this.nameStart = name.getColumn();
            this.nameEnd = this.nameStart + this.name.length();
        }
    }

    public final int getNameStart() {
        return this.nameStart;
    }

    public final int getNameEnd() {
        return this.nameEnd;
    }

    protected ISourceRange getNameSourceRange() {
        return new SourceRange(this.getNameStart(), this.getNameEnd() - this.getNameStart() + 1);
    }

    public final String getName() {
        return this.name;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final PositionInformation getPositionInformation() {
        return new PositionInformation(this.nameStart, this.nameEnd, this.sourceStart(), this.sourceEnd());
    }

    public final void setModifier(int mods) {
        this.modifiers |= mods;
    }

    public final void setModifiers(int mods) {
        this.modifiers = mods;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public void setNameEnd(int end) {
        this.nameEnd = end;
    }

    public void setNameStart(int start) {
        this.nameStart = start;
    }

    public boolean isStatic() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isPublic() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isPrivate() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isProtected() {
        return (this.modifiers & 0x20) != 0;
    }

    public boolean isFinal() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isAbstract() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isInterface() {
        return (this.modifiers & 8) != 0;
    }

    public String toString() {
        String buf = "";
        if (this.isStatic()) {
            buf = String.valueOf(buf) + "static ";
        }
        if (this.name != null) {
            buf = String.valueOf(buf) + " " + this.name;
        }
        return buf;
    }

    public int getKind() {
        return 0;
    }

    public void printNode(CorePrinter output) {
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit(this)) {
            pVisitor.endvisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Declaration)) {
            return false;
        }
        Declaration d = (Declaration)obj;
        return d.name.equals(this.name) && d.nameStart == this.nameStart && d.nameEnd == this.nameEnd && super.equals(obj);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String debugString() {
        return String.valueOf(super.debugString()) + this.getNameSourceRange().toString();
    }
}

