/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.dltk.dbgp.IDbgpRawListener;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.ScriptDebugLogView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class ScriptDebugLogManager
implements ILaunchListener,
IDebugEventSetListener,
IDbgpRawListener {
    private static ScriptDebugLogManager instance;
    private ScriptDebugLogView view;

    public static ScriptDebugLogManager getInstance() {
        if (instance == null) {
            instance = new ScriptDebugLogManager();
        }
        return instance;
    }

    private ScriptDebugLogManager() {
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
        Preferences prefs = DLTKDebugPlugin.getDefault().getPluginPreferences();
        boolean enableLogging = prefs.getBoolean("dbgp_enable_logging");
        if (!enableLogging) {
            return;
        }
        IDebugTarget target = launch.getDebugTarget();
        if (target instanceof IScriptDebugTarget) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page = DLTKDebugUIPlugin.getActivePage();
                    if (page != null) {
                        try {
                            ScriptDebugLogManager.this.view = (ScriptDebugLogView)page.showView("org.eclipse.dltk.debug.ui.dbgpLogView");
                            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)ScriptDebugLogManager.this);
                        }
                        catch (PartInitException e) {
                            DLTKDebugUIPlugin.log(e);
                        }
                    }
                }
            });
        }
    }

    public void launchRemoved(ILaunch launch) {
    }

    private static String getDebugEventKind(int kind) {
        String eventName = "UNKNOWN";
        switch (kind) {
            case 4: {
                eventName = "CREATE";
                break;
            }
            case 8: {
                eventName = "TERMINATE";
                break;
            }
            case 16: {
                eventName = "CHANGE";
                break;
            }
            case 2: {
                eventName = "SUSPEND";
                break;
            }
            case 1: {
                eventName = "RESUME";
                break;
            }
            case 32: {
                eventName = "MODEL_SPECIFIC";
            }
        }
        return eventName;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (this.view == null) {
            return;
        }
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            this.append("Event: " + ScriptDebugLogManager.getDebugEventKind(event.getKind()) + " from " + event.getSource().getClass().getName());
            if (event.getKind() == 4 && event.getSource() instanceof IScriptThread) {
                ((IScriptThread)event.getSource()).getDbgpSession().addRawListener((IDbgpRawListener)this);
            }
            ++i;
        }
    }

    protected synchronized void append(final String text) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ScriptDebugLogManager.this.view.append(String.valueOf(text) + "\n");
            }
        });
    }

    public void dbgpPacketReceived(String content) {
        this.append("<< " + content);
    }

    public void dbgpPacketSent(String content) {
        this.append(">> " + content);
    }
}

