/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.tcl.ITclKeywords;
import org.eclipse.dltk.tcl.TclKeywords;

public class TclKeywordsManager {
    private static final String PRIORITY = "priority";
    private static final String EXTENSION_POINT = "org.eclipse.dltk.tcl.core.tclkeywords";
    private static final String CLASS = "class";
    private static ITclKeywords sKeywords = null;
    private static int sPriority = -1;

    private TclKeywordsManager() {
    }

    private static void initialize() {
        if (sKeywords != null) {
            return;
        }
        IConfigurationElement[] cfg = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        int i = 0;
        while (i < cfg.length) {
            if (cfg[i].getName().equals("keywords")) {
                int priority = TclKeywordsManager.getPriority(cfg[i]);
                if (sPriority == -1 || sPriority < priority) {
                    try {
                        sKeywords = (ITclKeywords)cfg[i].createExecutableExtension(CLASS);
                        sPriority = priority;
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        if (sKeywords == null) {
            sKeywords = new TclKeywords();
        }
    }

    private static int getPriority(IConfigurationElement config) {
        String priority = config.getAttribute(PRIORITY);
        if (priority == null) {
            return 0;
        }
        try {
            int parseInt = Integer.parseInt(priority);
            return parseInt;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static String[] getKeywords() {
        TclKeywordsManager.initialize();
        return sKeywords.getKeywords();
    }

    public static String[] getKeywords(int type) {
        TclKeywordsManager.initialize();
        return sKeywords.getKeywords(type);
    }
}

