/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.character;

import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CandidateCharacter;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Container;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Topology;

public class CharacterSS
extends PageComponent {
    private int foregroundColor = -1;
    private int backgroundColor = -1;
    private Topology topology = null;

    public CharacterSS(CandidateCharacter candidateCharacter) throws ImageException {
        super((short)4, candidateCharacter.getPageImage());
        this.cc = candidateCharacter.cc;
        this.container = candidateCharacter.getContainer();
        this.foregroundColor = candidateCharacter.getForegroundColor();
        this.backgroundColor = this.container.getColor();
        this.topology = new Topology(this.cc.thinning());
    }

    public CharacterSS(IPageImage iPageImage, ConnectedComponent connectedComponent, Container container, int n) throws ImageException {
        super((short)4, iPageImage);
        this.cc = connectedComponent;
        this.container = container;
        this.foregroundColor = n;
        this.backgroundColor = this.container.getColor();
        this.topology = new Topology(this.cc.thinning());
    }

    public int getForegroundColor() {
        return this.foregroundColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public IInt2D makeMarginedImage(int n) {
        Int2D int2D = new Int2D(this.cc.getShape().getWidth() + 2 * n, this.cc.getShape().getHeight() + 2 * n);
        int2D.fill(this.backgroundColor);
        byte[][] byArray = this.cc.getShape().getData();
        int n2 = 0;
        while (n2 < this.cc.getShape().getHeight()) {
            int n3 = 0;
            while (n3 < this.cc.getShape().getWidth()) {
                if (byArray[n2][n3] != 0) {
                    int2D.getData()[n2 + n][n3 + n] = this.foregroundColor;
                }
                ++n3;
            }
            ++n2;
        }
        return int2D;
    }

    public Topology getTopology() {
        return this.topology;
    }
}

