/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.query.SiriusReferenceFinder;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class SiriusReferenceFinderImpl
implements SiriusReferenceFinder {
    protected final List<EReference> refs = Arrays.asList(ViewpointPackage.Literals.DSEMANTIC_DECORATOR__TARGET, ViewpointPackage.Literals.DREPRESENTATION_ELEMENT__SEMANTIC_ELEMENTS);
    protected DAnalysisSessionImpl dAnalysisSessionImpl;

    public SiriusReferenceFinderImpl(DAnalysisSessionImpl dAnalysisSessionImpl) {
        this.dAnalysisSessionImpl = dAnalysisSessionImpl;
    }

    @Override
    public Map<EObject, Collection<EObject>> getReferencingSiriusElements(Collection<EObject> semanticObjects, SiriusReferenceFinder.SearchScope searchScope) {
        if (SiriusReferenceFinder.SearchScope.ALL_REPRESENTATIONS_SCOPE.equals((Object)searchScope)) {
            this.loadAllRepresentations();
        }
        LinkedHashMap<EObject, Collection<EObject>> result = new LinkedHashMap<EObject, Collection<EObject>>();
        for (EObject semanticObject : semanticObjects) {
            Collection siriusElements = this.dAnalysisSessionImpl.getSemanticCrossReferencer().getNonNavigableInverseReferences(semanticObject).stream().filter(setting -> this.refs.contains(setting.getEStructuralFeature())).map(EStructuralFeature.Setting::getEObject).collect(Collectors.toSet());
            result.put(semanticObject, siriusElements);
        }
        return result;
    }

    @Override
    public Map<EObject, Collection<DRepresentationDescriptor>> getImpactedRepresentationDescriptors(Collection<EObject> semanticObjects, SiriusReferenceFinder.SearchScope searchScope) {
        LinkedHashMap<EObject, Collection<DRepresentationDescriptor>> impactedRepDesc = new LinkedHashMap<EObject, Collection<DRepresentationDescriptor>>();
        Map<EObject, Collection<EObject>> referencingSiriusElements = this.getReferencingSiriusElements(semanticObjects, searchScope);
        for (EObject semanticObject : semanticObjects) {
            LinkedHashSet repDescs = new LinkedHashSet();
            referencingSiriusElements.get(semanticObject).stream().forEach(obj -> {
                DRepresentationDescriptor representationDescriptor;
                Option<DRepresentation> representation = new EObjectQuery((EObject)obj).getRepresentation();
                if (representation.some() && (representationDescriptor = new DRepresentationQuery((DRepresentation)representation.get()).getRepresentationDescriptor()) != null) {
                    repDescs.add(representationDescriptor);
                }
            });
            if (repDescs.size() <= 0) continue;
            impactedRepDesc.put(semanticObject, repDescs);
        }
        return impactedRepDesc;
    }

    private void loadAllRepresentations() {
        DialectManager.INSTANCE.getAllRepresentationDescriptors(this.dAnalysisSessionImpl).stream().forEach(repDesc -> {
            DRepresentation dRepresentation = repDesc.getRepresentation();
        });
    }
}

