/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.elk;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.util.GraphIdentifierGenerator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.elk.Messages;

public class ElkDiagramLayoutTracer {
    public static final String TARGET_FOLDER_PATH_SYSTEM_PROPERTY_KEY = "org.eclipse.sirius.diagram.elk.targetFolderPath";
    private static String JAVA_TEMP_DIR_PROPERTY_NAME = "java.io.tmpdir";
    private static String XMI_EXTENSION = ".elkg";
    private static String TEXT_EXTENSION = ".elkt";
    private static ILog LOGGER = Platform.getLog(ElkDiagramLayoutTracer.class);
    public static String EXPORT_AS_XMI_PROPERTY = "org.eclipse.sirius.diagram.elk/debug/export_as_xmi";
    public static String EXPORT_AS_TEXT_PROPERTY = "org.eclipse.sirius.diagram.elk/debug/export_as_text";
    private final IWorkspaceRoot workspaceRoot;
    private final String targetFolderPath;
    private final boolean inDebug;
    private final boolean exportAsText;
    private final boolean exportAsXmi;

    public ElkDiagramLayoutTracer(boolean debug) {
        this.inDebug = debug;
        this.exportAsText = Boolean.parseBoolean(Platform.getDebugOption((String)EXPORT_AS_TEXT_PROPERTY));
        this.exportAsXmi = Boolean.parseBoolean(Platform.getDebugOption((String)EXPORT_AS_XMI_PROPERTY));
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String value = System.getProperty(TARGET_FOLDER_PATH_SYSTEM_PROPERTY_KEY);
        this.targetFolderPath = value == null || value.trim().isEmpty() ? System.getProperty(JAVA_TEMP_DIR_PROPERTY_NAME) : value.trim().replaceAll("%\\{", "\\$\\{");
    }

    private static String getFilename(String diagramName, String suffix, String extension) {
        if (StringUtil.isEmpty((String)suffix)) {
            return diagramName + extension;
        }
        return diagramName + "_" + suffix + extension;
    }

    void debug(ElkNode diagramNode, String suffix) {
        if (this.inDebug) {
            if (this.exportAsText) {
                this.saveAsText(diagramNode, diagramNode.getIdentifier(), suffix);
            } else if (this.exportAsXmi) {
                this.saveAsGraph(diagramNode, diagramNode.getIdentifier(), suffix);
            }
        }
    }

    private java.nio.file.Path getTargetFile(String diagramName, String suffix, String extension) {
        java.nio.file.Path parentPath;
        String abosluteExportFolderPath;
        Throwable exceptionThrown = null;
        try {
            abosluteExportFolderPath = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.targetFolderPath);
        }
        catch (CoreException e) {
            exceptionThrown = e;
            abosluteExportFolderPath = System.getProperty(JAVA_TEMP_DIR_PROPERTY_NAME);
        }
        try {
            parentPath = java.nio.file.Path.of(abosluteExportFolderPath, new String[0]);
        }
        catch (InvalidPathException e) {
            exceptionThrown = e;
            parentPath = java.nio.file.Path.of(System.getProperty(JAVA_TEMP_DIR_PROPERTY_NAME), new String[0]);
        }
        if (exceptionThrown != null) {
            LOGGER.warn(MessageFormat.format(Messages.ElkDiagramLayoutTracer_defaultJavaFolderWillBeUsedMsg, TARGET_FOLDER_PATH_SYSTEM_PROPERTY_KEY, JAVA_TEMP_DIR_PROPERTY_NAME), exceptionThrown);
        }
        return parentPath.resolve(ElkDiagramLayoutTracer.getFilename(diagramName, suffix, extension));
    }

    public Optional<IFile> getTargetFolderIfInWorkspace() {
        try {
            String abosluteTargetFolderPath = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.targetFolderPath);
            return Optional.ofNullable(this.workspaceRoot.getFileForLocation(Path.fromOSString((String)abosluteTargetFolderPath)));
        }
        catch (CoreException coreException) {
            return Optional.empty();
        }
    }

    public java.nio.file.Path saveAsText(ElkNode graph, String diagramName, String suffix) {
        java.nio.file.Path file = this.getTargetFile(diagramName, suffix, TEXT_EXTENSION);
        return ElkDiagramLayoutTracer.saveTo((EObject)this.cleanContentBeforeExport(graph, TEXT_EXTENSION), file);
    }

    public java.nio.file.Path saveAsGraph(ElkNode graph, String diagramName, String suffix) {
        java.nio.file.Path file = this.getTargetFile(diagramName, suffix, XMI_EXTENSION);
        return ElkDiagramLayoutTracer.saveTo((EObject)this.cleanContentBeforeExport(graph, XMI_EXTENSION), file);
    }

    private ElkNode cleanContentBeforeExport(ElkNode inputGraph, String extension) {
        ElkNode copy = (ElkNode)EcoreUtil.copy((EObject)inputGraph);
        copy.setProperty(CoreOptions.NO_LAYOUT, (Object)true);
        if (TEXT_EXTENSION.equals(extension)) {
            ElkDiagramLayoutTracer.removeProperty(copy, CoreOptions.RESOLVED_ALGORITHM);
            GraphIdentifierGenerator.forGraph((ElkNode)copy).assertValid().assertExists().assertUnique().execute();
        }
        return copy;
    }

    private static void removeProperty(ElkNode it, IProperty<?> key) {
        it.setProperty(key, null);
        it.getChildren().forEach(child -> ElkDiagramLayoutTracer.removeProperty(child, key));
    }

    private static java.nio.file.Path saveTo(EObject content, java.nio.file.Path target) {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(URI.createFileURI((String)target.toString()));
            resource.getContents().add((Object)content);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            resource.save(Collections.emptyMap());
            return target;
        }
        catch (IOException e) {
            LOGGER.error(MessageFormat.format(Messages.ElkDiagramLayoutTracer_saveNotPossible, target.toString()), (Throwable)e);
            return null;
        }
    }
}

