/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.testers;

import java.util.Iterator;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;

public class CanHideLabelTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = false;
        if ("canHideLabel".equals(property)) {
            if (receiver instanceof IStructuredSelection) {
                result = this.testStructuredSelection((IStructuredSelection)receiver);
            } else if (receiver instanceof IDiagramElementEditPart) {
                result = this.testDiagramElementEditPart((IDiagramElementEditPart)receiver);
            }
        }
        return result;
    }

    private boolean testDiagramElementEditPart(IDiagramElementEditPart selectedElement) {
        boolean result = false;
        DDiagramElement diagramElement = selectedElement.resolveDiagramElement();
        if (diagramElement != null) {
            DDiagramElementQuery query = new DDiagramElementQuery(diagramElement);
            result = selectedElement instanceof AbstractDEdgeNameEditPart ? query.canHideLabel() && !query.isLabelHidden(new EditPartQuery(selectedElement).getVisualID()) : query.canHideLabel() && !query.isLabelHidden();
        }
        return result;
    }

    private boolean testStructuredSelection(IStructuredSelection selectedElements) {
        boolean atLeastOneIsOK = false;
        Iterator iterator = selectedElements.iterator();
        while (!atLeastOneIsOK && iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof IDiagramElementEditPart)) continue;
            atLeastOneIsOK = this.testDiagramElementEditPart((IDiagramElementEditPart)next);
        }
        return atLeastOneIsOK;
    }
}

