/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.OutputStream;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.XRServiceModel;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.dbws.NamingConventionTransformer;
import org.eclipse.persistence.tools.dbws.Util;
import org.w3c.dom.Element;

public class WSDLGenerator {
    public static final String BINDING_SUFFIX = "_SOAP_HTTP";
    public static final String EMPTY_RESPONSE = "EmptyResponse";
    public static final String EXCEPTION_SUFFIX = "Exception";
    public static final String FAULT_SUFFIX = "Fault";
    public static final String NS_SCHEMA_PREFIX = "xsd";
    public static final String NS_TNS_PREFIX = "tns";
    public static final String SOAP_11_NAMESPACE_URI = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String SOAP_11_NAMESPACE_PREFIX = "soap";
    public static final String SOAP_12_NAMESPACE_URI = "http://schemas.xmlsoap.org/wsdl/soap12/";
    public static final String SOAP_12_NAMESPACE_PREFIX = "soap12";
    public static final String PORT_SUFFIX = "_Interface";
    public static final String REQUEST_SUFFIX = "Request";
    public static final String RESPONSE_SUFFIX = "Response";
    public static final String SOAP_STYLE = "document";
    public static final String SOAP_HTTP_TRANSPORT = "http://schemas.xmlsoap.org/soap/http";
    public static final String SOAP_USE = "literal";
    public static final String TAG_SCHEMA = "schema";
    public static final String TAG_SOAP_ADDRESS = "address";
    public static final String TAG_SOAP_BINDING = "binding";
    public static final String TAG_SOAP_BODY = "body";
    public static final String TAG_SOAP_FAULT = "fault";
    public static final String TAG_SOAP_OPERATION = "operation";
    public static final String TYPE_SUFFIX = "Type";
    protected XRServiceModel xrServiceModel;
    protected NamingConventionTransformer nct;
    protected String serviceName;
    protected String serviceNameSpace;
    protected String importedSchemaNameSpace;
    protected String wsdlLocationURI;
    protected boolean hasAttachments;
    protected OutputStream os;

    public WSDLGenerator(XRServiceModel xrServiceModel, NamingConventionTransformer nct, String wsdlLocationURI, boolean hasAttachments, String importedSchemaNameSpace, OutputStream os) {
        this.xrServiceModel = xrServiceModel;
        this.nct = nct;
        this.wsdlLocationURI = wsdlLocationURI;
        this.hasAttachments = hasAttachments;
        this.os = os;
        this.importedSchemaNameSpace = importedSchemaNameSpace;
        this.serviceName = xrServiceModel.getName() + "Service";
        this.serviceNameSpace = importedSchemaNameSpace + "Service";
    }

    public Definition generateWSDL() throws WSDLException {
        return this.generateWSDL(false);
    }

    public Definition generateWSDL(boolean useSOAP12) throws WSDLException {
        WSDLFactory factory = WSDLFactory.newInstance();
        ExtensionRegistry registry = factory.newPopulatedExtensionRegistry();
        Definition def = factory.newDefinition();
        if (useSOAP12) {
            def.addNamespace(SOAP_12_NAMESPACE_PREFIX, SOAP_12_NAMESPACE_URI);
        } else {
            def.addNamespace(SOAP_11_NAMESPACE_PREFIX, SOAP_11_NAMESPACE_URI);
        }
        def.setTargetNamespace(this.serviceNameSpace);
        def.setQName(new QName(this.serviceNameSpace, this.serviceName));
        def.addNamespace(NS_TNS_PREFIX, this.serviceNameSpace);
        def.addNamespace("ns1", this.importedSchemaNameSpace);
        def.addNamespace(NS_SCHEMA_PREFIX, "http://www.w3.org/2001/XMLSchema");
        Types types = def.createTypes();
        Schema schema = (Schema)registry.createExtension(Types.class, new QName("http://www.w3.org/2001/XMLSchema", TAG_SCHEMA));
        schema.setElement(this.createInlineSchema());
        types.addExtensibilityElement((ExtensibilityElement)schema);
        def.setTypes(types);
        PortType portType = def.createPortType();
        portType.setUndefined(false);
        portType.setQName(new QName(this.serviceNameSpace, this.serviceName + PORT_SUFFIX));
        def.addPortType(portType);
        ExtensibilityElement soap = null;
        if (useSOAP12) {
            soap = registry.createExtension(Binding.class, new QName(SOAP_12_NAMESPACE_URI, TAG_SOAP_BINDING));
            ((SOAP12Binding)soap).setStyle(SOAP_STYLE);
            ((SOAP12Binding)soap).setTransportURI(SOAP_HTTP_TRANSPORT);
        } else {
            soap = registry.createExtension(Binding.class, new QName(SOAP_11_NAMESPACE_URI, TAG_SOAP_BINDING));
            ((SOAPBinding)soap).setStyle(SOAP_STYLE);
            ((SOAPBinding)soap).setTransportURI(SOAP_HTTP_TRANSPORT);
        }
        Binding binding = def.createBinding();
        binding.setUndefined(false);
        binding.setQName(new QName(this.serviceNameSpace, this.serviceName + BINDING_SUFFIX));
        binding.setPortType(portType);
        binding.addExtensibilityElement(soap);
        def.addBinding(binding);
        ExtensibilityElement sa = null;
        if (useSOAP12) {
            sa = registry.createExtension(Port.class, new QName(SOAP_12_NAMESPACE_URI, TAG_SOAP_ADDRESS));
            ((SOAP12Address)sa).setLocationURI(this.wsdlLocationURI);
        } else {
            sa = registry.createExtension(Port.class, new QName(SOAP_11_NAMESPACE_URI, TAG_SOAP_ADDRESS));
            ((SOAPAddress)sa).setLocationURI(this.wsdlLocationURI);
        }
        Service ws = def.createService();
        ws.setQName(new QName(this.serviceNameSpace, this.serviceName));
        Port port = def.createPort();
        port.setName(this.serviceName + "Port");
        port.setBinding(binding);
        port.addExtensibilityElement(sa);
        ws.addPort(port);
        def.addService(ws);
        boolean requireEmptyResponseMessages = false;
        for (org.eclipse.persistence.internal.xr.Operation op : this.xrServiceModel.getOperationsList()) {
            if (op instanceof QueryOperation) continue;
            requireEmptyResponseMessages = true;
            break;
        }
        if (requireEmptyResponseMessages) {
            Message emptyResponseMessage = def.createMessage();
            emptyResponseMessage.setUndefined(false);
            emptyResponseMessage.setQName(new QName(this.serviceNameSpace, EMPTY_RESPONSE));
            Part responsePart = def.createPart();
            responsePart.setName("emptyResponse");
            responsePart.setElementName(new QName(this.serviceNameSpace, EMPTY_RESPONSE));
            emptyResponseMessage.addPart(responsePart);
            def.addMessage(emptyResponseMessage);
            Message faultMessage = def.createMessage();
            faultMessage.setUndefined(false);
            faultMessage.setQName(new QName(this.serviceNameSpace, "FaultType"));
            Part faultPart = def.createPart();
            faultPart.setName(TAG_SOAP_FAULT);
            faultPart.setElementName(new QName(this.serviceNameSpace, "FaultType"));
            faultMessage.addPart(faultPart);
            def.addMessage(faultMessage);
        }
        for (org.eclipse.persistence.internal.xr.Operation op : this.xrServiceModel.getOperationsList()) {
            this.createMethodDefinition(factory, registry, def, op, useSOAP12);
        }
        if (this.os != null) {
            WSDLWriter writer = factory.newWSDLWriter();
            writer.writeWSDL(def, this.os);
        }
        return def;
    }

    private void createMethodDefinition(WSDLFactory factory, ExtensionRegistry registry, Definition def, org.eclipse.persistence.internal.xr.Operation operation, boolean useSOAP12) throws WSDLException {
        ExtensibilityElement soapOutputBody;
        BindingOutput bo;
        Message requestMessage = def.createMessage();
        requestMessage.setUndefined(false);
        requestMessage.setQName(new QName(this.serviceNameSpace, operation.getName() + REQUEST_SUFFIX));
        Part requestPart = def.createPart();
        requestPart.setName(operation.getName() + REQUEST_SUFFIX);
        requestPart.setElementName(new QName(this.serviceNameSpace, operation.getName()));
        requestMessage.addPart(requestPart);
        def.addMessage(requestMessage);
        Message responseMessage = null;
        if (operation.hasResponse()) {
            responseMessage = def.createMessage();
            responseMessage.setUndefined(false);
            responseMessage.setQName(new QName(this.serviceNameSpace, operation.getName() + RESPONSE_SUFFIX));
            Part responsePart = def.createPart();
            responsePart.setName(operation.getName() + RESPONSE_SUFFIX);
            responsePart.setElementName(new QName(this.serviceNameSpace, operation.getName() + RESPONSE_SUFFIX));
            responseMessage.addPart(responsePart);
            def.addMessage(responseMessage);
        }
        PortType portType = def.getPortType(new QName(this.serviceNameSpace, this.serviceName + PORT_SUFFIX));
        Operation op = def.createOperation();
        op.setUndefined(false);
        op.setName(operation.getName());
        Input input = def.createInput();
        input.setMessage(requestMessage);
        op.setInput(input);
        if (operation.hasResponse()) {
            Output output = def.createOutput();
            output.setMessage(responseMessage);
            op.setOutput(output);
        }
        portType.addOperation(op);
        Binding binding = def.getBinding(new QName(this.serviceNameSpace, this.serviceName + BINDING_SUFFIX));
        BindingOperation bop = def.createBindingOperation();
        bop.setName(operation.getName());
        ExtensibilityElement so = null;
        if (useSOAP12) {
            so = registry.createExtension(BindingOperation.class, new QName(SOAP_12_NAMESPACE_URI, TAG_SOAP_OPERATION));
            ((SOAP12Operation)so).setSoapActionURI(this.serviceNameSpace + ":" + op.getName());
        } else {
            so = registry.createExtension(BindingOperation.class, new QName(SOAP_11_NAMESPACE_URI, TAG_SOAP_OPERATION));
            ((SOAPOperation)so).setSoapActionURI(this.serviceNameSpace + ":" + op.getName());
        }
        bop.addExtensibilityElement(so);
        BindingInput bi = def.createBindingInput();
        ExtensibilityElement soapInputBody = null;
        if (useSOAP12) {
            soapInputBody = registry.createExtension(BindingInput.class, new QName(SOAP_12_NAMESPACE_URI, TAG_SOAP_BODY));
            ((SOAP12Body)soapInputBody).setUse(SOAP_USE);
        } else {
            soapInputBody = registry.createExtension(BindingInput.class, new QName(SOAP_11_NAMESPACE_URI, TAG_SOAP_BODY));
            ((SOAPBody)soapInputBody).setUse(SOAP_USE);
        }
        bi.addExtensibilityElement(soapInputBody);
        bop.setBindingInput(bi);
        if (operation.hasResponse()) {
            bo = def.createBindingOutput();
            soapOutputBody = null;
            if (useSOAP12) {
                soapOutputBody = registry.createExtension(BindingOutput.class, new QName(SOAP_12_NAMESPACE_URI, TAG_SOAP_BODY));
                ((SOAP12Body)soapOutputBody).setUse(SOAP_USE);
            } else {
                soapOutputBody = registry.createExtension(BindingOutput.class, new QName(SOAP_11_NAMESPACE_URI, TAG_SOAP_BODY));
                ((SOAPBody)soapOutputBody).setUse(SOAP_USE);
            }
            bo.addExtensibilityElement(soapOutputBody);
            bop.setBindingOutput(bo);
        }
        if (!(operation instanceof QueryOperation)) {
            bo = def.createBindingOutput();
            soapOutputBody = null;
            if (useSOAP12) {
                soapOutputBody = registry.createExtension(BindingOutput.class, new QName(SOAP_12_NAMESPACE_URI, TAG_SOAP_BODY));
                ((SOAP12Body)soapOutputBody).setUse(SOAP_USE);
            } else {
                soapOutputBody = registry.createExtension(BindingOutput.class, new QName(SOAP_11_NAMESPACE_URI, TAG_SOAP_BODY));
                ((SOAPBody)soapOutputBody).setUse(SOAP_USE);
            }
            bo.addExtensibilityElement(soapOutputBody);
            bop.setBindingOutput(bo);
            BindingFault bindingFault = def.createBindingFault();
            String exceptionName = "FaultException";
            bindingFault.setName(exceptionName);
            ExtensibilityElement soapFaultBody = null;
            if (useSOAP12) {
                soapFaultBody = registry.createExtension(BindingFault.class, new QName(SOAP_12_NAMESPACE_URI, TAG_SOAP_FAULT));
                ((SOAP12Fault)soapFaultBody).setUse(SOAP_USE);
                ((SOAP12Fault)soapFaultBody).setName(exceptionName);
            } else {
                soapFaultBody = registry.createExtension(BindingFault.class, new QName(SOAP_11_NAMESPACE_URI, TAG_SOAP_FAULT));
                ((SOAPFault)soapFaultBody).setUse(SOAP_USE);
                ((SOAPFault)soapFaultBody).setName(exceptionName);
            }
            bindingFault.addExtensibilityElement(soapFaultBody);
            bop.addBindingFault(bindingFault);
            Message emptyResponseMessage = def.getMessage(new QName(this.serviceNameSpace, EMPTY_RESPONSE));
            Output output = def.createOutput();
            output.setName(operation.getName() + EMPTY_RESPONSE);
            output.setMessage(emptyResponseMessage);
            op.setOutput(output);
            Message faultMessage = def.getMessage(new QName(this.serviceNameSpace, "FaultType"));
            Fault fault = def.createFault();
            fault.setMessage(faultMessage);
            fault.setName(exceptionName);
            op.addFault(fault);
        }
        binding.addBindingOperation(bop);
    }

    private Element createInlineSchema() {
        SchemaModelProject project = new SchemaModelProject();
        XMLContext context = new XMLContext((Project)project);
        XMLMarshaller marshaller = context.createMarshaller();
        XMLDescriptor descriptor = (XMLDescriptor)project.getClassDescriptor(org.eclipse.persistence.internal.oxm.schema.model.Schema.class);
        if (descriptor.getNamespaceResolver() == null) {
            descriptor.setNamespaceResolver(new NamespaceResolver());
        }
        descriptor.getNamespaceResolver().put(NS_TNS_PREFIX, this.serviceNameSpace);
        descriptor.getNamespaceResolver().put(NS_SCHEMA_PREFIX, "http://www.w3.org/2001/XMLSchema");
        if (this.hasAttachments) {
            descriptor.getNamespaceResolver().put("ref", "http://ws-i.org/profiles/basic/1.1/xsd");
        }
        org.eclipse.persistence.internal.oxm.schema.model.Schema schema = new org.eclipse.persistence.internal.oxm.schema.model.Schema();
        schema.setTargetNamespace(this.serviceNameSpace);
        schema.setElementFormDefault(true);
        Import parent = new Import();
        parent.setNamespace(this.importedSchemaNameSpace);
        parent.setSchemaLocation("eclipselink-dbws-schema.xsd");
        schema.getImports().add(parent);
        if (this.hasAttachments) {
            Import ref = new Import();
            ref.setNamespace("http://ws-i.org/profiles/basic/1.1/xsd");
            ref.setSchemaLocation(Util.WSI_SWAREF_XSD_FILE);
            schema.getImports().add(ref);
        }
        boolean requireFaultTypeEmptyResponse = false;
        for (org.eclipse.persistence.internal.xr.Operation op : this.xrServiceModel.getOperationsList()) {
            String opName = op.getName();
            ComplexType requestType = new ComplexType();
            requestType.setName(opName + "RequestType");
            Sequence requestSequence = null;
            if (op.getParameters().size() > 0) {
                requestSequence = new Sequence();
                for (Parameter p : op.getParameters()) {
                    org.eclipse.persistence.internal.oxm.schema.model.Element arg = new org.eclipse.persistence.internal.oxm.schema.model.Element();
                    if (p.isOptional()) {
                        arg.setMinOccurs("0");
                    }
                    arg.setName(p.getName());
                    if ("theInstance".equals(p.getName())) {
                        ComplexType nestedComplexType = new ComplexType();
                        Sequence nestedSequence = new Sequence();
                        nestedComplexType.setSequence(nestedSequence);
                        org.eclipse.persistence.internal.oxm.schema.model.Element nestedElement = new org.eclipse.persistence.internal.oxm.schema.model.Element();
                        nestedElement.setRef("ns1:" + p.getType().getLocalPart());
                        nestedSequence.addElement(nestedElement);
                        arg.setComplexType(nestedComplexType);
                    } else {
                        arg.setName(p.getName());
                        if (p.getType().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                            arg.setType("xsd:" + p.getType().getLocalPart());
                        } else if (p.getType().getNamespaceURI().equals(this.importedSchemaNameSpace)) {
                            arg.setType("ns1:" + p.getType().getLocalPart());
                        } else {
                            arg.setType(p.getType().getLocalPart());
                        }
                    }
                    requestSequence.addElement(arg);
                }
                requestType.setSequence(requestSequence);
            }
            schema.addTopLevelComplexTypes(requestType);
            org.eclipse.persistence.internal.oxm.schema.model.Element requestElement = new org.eclipse.persistence.internal.oxm.schema.model.Element();
            requestElement.setName(op.getName());
            requestElement.setType("tns:" + requestType.getName());
            schema.addTopLevelElement(requestElement);
            if (op instanceof QueryOperation) {
                QueryOperation q = (QueryOperation)op;
                ComplexType responseType = new ComplexType();
                responseType.setName(op.getName() + "ResponseType");
                Sequence responseSequence = new Sequence();
                org.eclipse.persistence.internal.oxm.schema.model.Element result = new org.eclipse.persistence.internal.oxm.schema.model.Element();
                result.setName("result");
                if (q.isAttachment()) {
                    result.setType("ref:swaRef");
                } else if (q.isSimpleXMLFormat() || q.getResultType().equals(new QName("http://www.w3.org/2001/XMLSchema", "any"))) {
                    ComplexType anyType = new ComplexType();
                    Sequence anySequence = new Sequence();
                    anySequence.addAny(new Any());
                    anyType.setSequence(anySequence);
                    result.setComplexType(anyType);
                } else if (q.getResultType().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                    result.setType("xsd:" + q.getResultType().getLocalPart());
                } else {
                    ComplexType nestedComplexType = new ComplexType();
                    Sequence nestedSequence = new Sequence();
                    nestedComplexType.setSequence(nestedSequence);
                    org.eclipse.persistence.internal.oxm.schema.model.Element nestedElement = new org.eclipse.persistence.internal.oxm.schema.model.Element();
                    nestedElement.setRef("ns1:" + q.getResultType().getLocalPart());
                    nestedElement.setMinOccurs("0");
                    if (q.isCollection()) {
                        nestedElement.setMaxOccurs("unbounded");
                    }
                    nestedSequence.addElement(nestedElement);
                    result.setComplexType(nestedComplexType);
                }
                responseSequence.addElement(result);
                responseType.setSequence(responseSequence);
                schema.addTopLevelComplexTypes(responseType);
                org.eclipse.persistence.internal.oxm.schema.model.Element responseElement = new org.eclipse.persistence.internal.oxm.schema.model.Element();
                responseElement.setName(op.getName() + RESPONSE_SUFFIX);
                responseElement.setType("tns:" + responseType.getName());
                schema.addTopLevelElement(responseElement);
                continue;
            }
            requireFaultTypeEmptyResponse = true;
        }
        if (requireFaultTypeEmptyResponse) {
            org.eclipse.persistence.internal.oxm.schema.model.Element emptyResponseElement = new org.eclipse.persistence.internal.oxm.schema.model.Element();
            emptyResponseElement.setName(EMPTY_RESPONSE);
            ComplexType emptyResponseComplexType = new ComplexType();
            emptyResponseElement.setComplexType(emptyResponseComplexType);
            schema.addTopLevelElement(emptyResponseElement);
            org.eclipse.persistence.internal.oxm.schema.model.Element elementFaultType = new org.eclipse.persistence.internal.oxm.schema.model.Element();
            elementFaultType.setName("FaultType");
            ComplexType faultComplexType = new ComplexType();
            elementFaultType.setComplexType(faultComplexType);
            Sequence nestedSequence = new Sequence();
            faultComplexType.setSequence(nestedSequence);
            org.eclipse.persistence.internal.oxm.schema.model.Element faultCodeElement = new org.eclipse.persistence.internal.oxm.schema.model.Element();
            faultCodeElement.setName("faultCode");
            faultCodeElement.setMinOccurs("1");
            faultCodeElement.setType("xsd:string");
            nestedSequence.addElement(faultCodeElement);
            org.eclipse.persistence.internal.oxm.schema.model.Element faultStringElement = new org.eclipse.persistence.internal.oxm.schema.model.Element();
            faultStringElement.setMinOccurs("1");
            faultStringElement.setName("faultString");
            faultStringElement.setType("xsd:string");
            nestedSequence.addElement(faultStringElement);
            schema.addTopLevelElement(elementFaultType);
        }
        return marshaller.objectToXML((Object)schema).getDocumentElement();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceNameSpace() {
        return this.serviceNameSpace;
    }
}

