/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.hierarchy;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNode;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNodeReference;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.Wrapper;

public class DefaultHierarchyNode
implements IHierarchyNode {
    private IHierarchyNode parent;
    private boolean mayHaveChildren;
    private IEObjectDescription element;
    private final List<IHierarchyNodeReference> references = new ArrayList<IHierarchyNodeReference>();
    private Wrapper<Boolean> recursive;

    @Override
    public Object getNavigationElement() {
        if (!this.references.isEmpty()) {
            return this.references.get(0);
        }
        return this.element;
    }

    @Override
    public boolean isRecursive() {
        if (this.recursive == null) {
            this.recursive = Wrapper.wrap((Object)this.internalIsRecursive());
        }
        return (Boolean)this.recursive.get();
    }

    protected boolean internalIsRecursive() {
        IHierarchyNode node = this.parent;
        while (node != null) {
            URI elementUri;
            URI nodeElementUri = node.getElement().getEObjectURI();
            if (Objects.equals(nodeElementUri, elementUri = this.element.getEObjectURI())) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    @Override
    public boolean mayHaveChildren() {
        return this.mayHaveChildren;
    }

    @Override
    public IHierarchyNode getParent() {
        return this.parent;
    }

    public void setParent(IHierarchyNode parent) {
        this.parent = parent;
    }

    public void setMayHaveChildren(boolean mayHaveChildren) {
        this.mayHaveChildren = mayHaveChildren;
    }

    @Override
    public IEObjectDescription getElement() {
        return this.element;
    }

    public void setElement(IEObjectDescription element) {
        this.element = element;
    }

    public List<IHierarchyNodeReference> getReferences() {
        return this.references;
    }
}

