/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathDirectory;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathLibrary;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathMultiDirectory;

public abstract class ClasspathLocation {
    static ClasspathLocation forSourceFolder(IContainer sourceFolder, IContainer outputFolder, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        return new ClasspathMultiDirectory(sourceFolder, outputFolder, inclusionPatterns, exclusionPatterns);
    }

    public static ClasspathLocation forBinaryFolder(IContainer binaryFolder, boolean isOutputFolder, AccessRuleSet accessRuleSet) {
        return new ClasspathDirectory(binaryFolder, isOutputFolder, accessRuleSet);
    }

    public static ClasspathLocation forLibrary(String libraryPathname, long lastModified, AccessRuleSet accessRuleSet) {
        return new ClasspathLibrary(libraryPathname, lastModified, accessRuleSet);
    }

    public static ClasspathLocation forLibrary(String libraryPathname, AccessRuleSet accessRuleSet) {
        return ClasspathLocation.forLibrary(libraryPathname, 0L, accessRuleSet);
    }

    public abstract NameEnvironmentAnswer findClass(String var1, String var2, String var3);

    public abstract IPath getProjectRelativePath();

    public boolean isOutputFolder() {
        return false;
    }

    public abstract boolean isPackage(String var1);

    public void cleanup() {
    }

    public void reset() {
    }

    public abstract String debugPathString();
}

