/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.reflect;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.reflect.ClassMap;

public class ReflectionUtils {
    private static final Map<String, WeakHashMap<Class<?>, IsSuccessorResult>> m_isSuccessorOfCache = new HashMap();
    private static final ClassMap<Map<String, Method>> m_getMethodBySignature = ClassMap.create();
    private static ClassMap<List<PropertyDescriptor>> m_propertyDescriptorsCache = ClassMap.create();

    private ReflectionUtils() {
    }

    public static Method getWriteMethod(PropertyDescriptor propertyDescriptor) {
        try {
            return propertyDescriptor.getWriteMethod();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Method getReadMethod(PropertyDescriptor propertyDescriptor) {
        try {
            return propertyDescriptor.getReadMethod();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static Class<?> getClassByName(ClassLoader classLoader, String className) throws Exception {
        Assert.isNotNull(className);
        if ("boolean".equals(className)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(className)) {
            return Byte.TYPE;
        }
        if ("char".equals(className)) {
            return Character.TYPE;
        }
        if ("short".equals(className)) {
            return Short.TYPE;
        }
        if ("int".equals(className)) {
            return Integer.TYPE;
        }
        if ("long".equals(className)) {
            return Long.TYPE;
        }
        if ("float".equals(className)) {
            return Float.TYPE;
        }
        if ("double".equals(className)) {
            return Double.TYPE;
        }
        if (className.endsWith("[]")) {
            int dimensions = StringUtils.countMatches((CharSequence)className, (CharSequence)"[]");
            String componentClassName = StringUtils.substringBefore((String)className, (String)"[]");
            Class<?> componentClass = ReflectionUtils.getClassByName(classLoader, componentClassName);
            return Array.newInstance(componentClass, new int[dimensions]).getClass();
        }
        return classLoader.loadClass(className);
    }

    public static boolean hasClass(ClassLoader classLoader, String name) {
        try {
            classLoader.loadClass(name);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static Object getDefaultValue(String className) {
        if ("boolean".equals(className)) {
            return false;
        }
        if ("byte".equals(className)) {
            return (byte)0;
        }
        if ("char".equals(className)) {
            return Character.valueOf('\u0000');
        }
        if ("short".equals(className)) {
            return (short)0;
        }
        if ("int".equals(className)) {
            return 0;
        }
        if ("long".equals(className)) {
            return 0L;
        }
        if ("float".equals(className)) {
            return Float.valueOf(0.0f);
        }
        if ("double".equals(className)) {
            return 0.0;
        }
        return null;
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return ReflectionUtils.getDefaultValue(clazz.getName());
        }
        if (ReflectionUtils.isSuccessorOf(clazz, "java.lang.String")) {
            return "<dynamic>";
        }
        if (ReflectionUtils.isSuccessorOf(clazz, "java.util.List")) {
            return new ArrayList();
        }
        if (ReflectionUtils.isSuccessorOf(clazz, "java.util.Set")) {
            return new HashSet();
        }
        if (ReflectionUtils.isSuccessorOf(clazz, "java.util.Map")) {
            return new HashMap();
        }
        return null;
    }

    public static boolean isSuccessorOf(Class<?> clazz, String requiredClass) {
        if (clazz == null) {
            return false;
        }
        String clazzName = clazz.getName();
        IsSuccessorResult result = ReflectionUtils.isSuccessorOf_checkCache(clazz, requiredClass);
        if (result == IsSuccessorResult.TRUE) {
            return true;
        }
        if (result == IsSuccessorResult.FALSE) {
            return false;
        }
        if (clazzName.equals(requiredClass)) {
            ReflectionUtils.isSuccessorOf_addCache(clazz, requiredClass, IsSuccessorResult.TRUE);
            return true;
        }
        if (ReflectionUtils.isSuccessorOf(clazz.getSuperclass(), requiredClass)) {
            ReflectionUtils.isSuccessorOf_addCache(clazz, requiredClass, IsSuccessorResult.TRUE);
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaceClass = classArray[n2];
            if (ReflectionUtils.isSuccessorOf(interfaceClass, requiredClass)) {
                ReflectionUtils.isSuccessorOf_addCache(clazz, requiredClass, IsSuccessorResult.TRUE);
                return true;
            }
            ++n2;
        }
        ReflectionUtils.isSuccessorOf_addCache(clazz, requiredClass, IsSuccessorResult.FALSE);
        return false;
    }

    private static void isSuccessorOf_addCache(Class<?> clazz, String requiredClass, IsSuccessorResult result) {
        WeakHashMap<Class<Object>, IsSuccessorResult> classes = m_isSuccessorOfCache.get(requiredClass);
        if (classes == null) {
            classes = new WeakHashMap();
            m_isSuccessorOfCache.put(requiredClass, classes);
        }
        classes.put(clazz, result);
    }

    private static IsSuccessorResult isSuccessorOf_checkCache(Class<?> clazz, String requiredClass) {
        WeakHashMap<Class<?>, IsSuccessorResult> classes = m_isSuccessorOfCache.get(requiredClass);
        if (classes != null) {
            return classes.get(clazz);
        }
        return IsSuccessorResult.UNKNOWN;
    }

    public static boolean isAssignableFrom(Class<?> targetClass, Object candidate) {
        if (targetClass.isPrimitive()) {
            if (targetClass == Byte.TYPE) {
                return candidate instanceof Byte;
            }
            if (targetClass == Character.TYPE) {
                return candidate instanceof Character;
            }
            if (targetClass == Short.TYPE) {
                return candidate instanceof Short;
            }
            if (targetClass == Integer.TYPE) {
                return candidate instanceof Integer;
            }
            if (targetClass == Long.TYPE) {
                return candidate instanceof Long;
            }
            if (targetClass == Float.TYPE) {
                return candidate instanceof Float;
            }
            if (targetClass == Double.TYPE) {
                return candidate instanceof Double;
            }
        }
        if (candidate == null) {
            return true;
        }
        return targetClass.isInstance(candidate);
    }

    public static boolean isSuccessorOf(Object candidate, String requiredClass) {
        if (candidate == null) {
            return false;
        }
        Class<?> candidateClass = candidate.getClass();
        if (!requiredClass.contains(".")) {
            Class primitiveType;
            Field fieldTYPE = ReflectionUtils.getFieldByName(candidateClass, "TYPE");
            return fieldTYPE != null && Objects.equals((primitiveType = (Class)ReflectionUtils.getFieldObject(candidateClass, "TYPE")).getName(), requiredClass);
        }
        return ReflectionUtils.isSuccessorOf(candidateClass, requiredClass);
    }

    public static boolean isMemberClass(Class<?> clazz) {
        Assert.isNotNull(clazz);
        return ExecutionUtils.runObjectIgnore(() -> clazz.isMemberClass(), false);
    }

    public static List<Class<?>> getSuperHierarchy(Class<?> clazz) throws Exception {
        ArrayList types = new ArrayList();
        types.add(clazz);
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interfaceClass = classArray[n2];
                types.addAll(ReflectionUtils.getSuperHierarchy(interfaceClass));
                ++n2;
            }
            types.addAll(ReflectionUtils.getSuperHierarchy(superclass));
        }
        return types;
    }

    public static boolean isMoreSpecific(Class<?>[] base, Class<?>[] specific) {
        if (base.length != specific.length) {
            return false;
        }
        int i = 0;
        while (i < base.length) {
            if (!ReflectionUtils.isMoreSpecific(base[i], specific[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isMoreSpecific(Class<?> base, Class<?> specific) {
        return base.isAssignableFrom(specific);
    }

    public static boolean isEnchancedClass(Class<?> clazz) {
        return clazz.getName().indexOf(36) != -1;
    }

    public static Class<?> getNormalClass(Class<?> clazz) {
        while (ReflectionUtils.isEnchancedClass(clazz)) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static String toString(Method method) {
        String methodSignature = ReflectionUtils.getMethodSignature(method);
        while (ReflectionUtils.isEnchancedClass(method.getDeclaringClass())) {
            Class<?> superClass = method.getDeclaringClass().getSuperclass();
            Method superMethod = ReflectionUtils.getMethodBySignature(superClass, methodSignature);
            if (superMethod == null) break;
            method = superMethod;
        }
        return method.toString();
    }

    public static String getShortConstructorString(Constructor<?> constructor) {
        if (constructor == null) {
            return "<null-constructor>";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(ReflectionUtils.getShortName(constructor.getDeclaringClass()));
        buffer.append('(');
        Class<?>[] parameters = constructor.getParameterTypes();
        int i = 0;
        while (i < parameters.length) {
            Class<?> parameterType = parameters[i];
            if (i != 0) {
                buffer.append(',');
            }
            buffer.append(ReflectionUtils.getShortName(parameterType));
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public static String getFullyQualifiedName(Type type, boolean runtime) {
        Assert.isNotNull(type);
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return ReflectionUtils.getFullyQualifiedName(clazz.getComponentType(), runtime) + "[]";
            }
            String name = clazz.getName();
            if (!runtime) {
                name = name.replace('$', '.');
            }
            return name;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return ReflectionUtils.getFullyQualifiedName(genericArrayType.getGenericComponentType(), runtime) + "[]";
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            StringBuilder sb = new StringBuilder();
            sb.append(ReflectionUtils.getFullyQualifiedName(rawType, runtime));
            sb.append("<");
            boolean firstTypeArgument = true;
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type typeArgument = typeArray[n2];
                if (!firstTypeArgument) {
                    sb.append(",");
                }
                firstTypeArgument = false;
                sb.append(ReflectionUtils.getFullyQualifiedName(typeArgument, runtime));
                ++n2;
            }
            sb.append(">");
            return sb.toString();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return "? extends " + ReflectionUtils.getFullyQualifiedName(wildcardType.getUpperBounds()[0], runtime);
        }
        TypeVariable typeVariable = (TypeVariable)type;
        return typeVariable.getName();
    }

    private static void appendParameterTypes(StringBuilder buffer, Type[] parameterTypes) {
        buffer.append('(');
        boolean firstParameter = true;
        Type[] typeArray = parameterTypes;
        int n = parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameterType = typeArray[n2];
            if (firstParameter) {
                firstParameter = false;
            } else {
                buffer.append(',');
            }
            buffer.append(ReflectionUtils.getFullyQualifiedName(parameterType, false));
            ++n2;
        }
        buffer.append(')');
    }

    public static String getCanonicalName(Class<?> clazz) {
        return ReflectionUtils.getFullyQualifiedName(clazz, false);
    }

    public static String getShortName(Class<?> clazz) {
        String className = ReflectionUtils.getFullyQualifiedName(clazz, false);
        if (clazz.isMemberClass()) {
            Class<?> topClass = ReflectionUtils.getTopLevelClass(clazz);
            String topName = topClass.getName();
            String topPackage = StringUtils.substringBeforeLast((String)topName, (String)".") + ".";
            return className.substring(topPackage.length());
        }
        if (className.indexOf(46) != -1) {
            return StringUtils.substringAfterLast((String)className, (String)".");
        }
        return className;
    }

    private static Class<?> getTopLevelClass(Class<?> clazz) {
        while (clazz.isMemberClass()) {
            clazz = clazz.getEnclosingClass();
        }
        return clazz;
    }

    public static boolean isPublic(Constructor<?> constructor) {
        return Modifier.isPublic(constructor.getModifiers());
    }

    public static boolean isProtected(Constructor<?> constructor) {
        return Modifier.isProtected(constructor.getModifiers());
    }

    public static boolean isPrivate(Constructor<?> constructor) {
        return Modifier.isPrivate(constructor.getModifiers());
    }

    public static boolean isPackagePrivate(Constructor<?> constructor) {
        return !ReflectionUtils.isPublic(constructor) && !ReflectionUtils.isProtected(constructor) && !ReflectionUtils.isPrivate(constructor);
    }

    public static boolean isPublic(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    public static boolean isProtected(Method method) {
        return Modifier.isProtected(method.getModifiers());
    }

    public static boolean isPrivate(Method method) {
        return Modifier.isPrivate(method.getModifiers());
    }

    public static boolean isPackagePrivate(Method method) {
        return !ReflectionUtils.isPublic(method) && !ReflectionUtils.isProtected(method) && !ReflectionUtils.isPrivate(method);
    }

    public static boolean isAbstract(Method method) {
        return Modifier.isAbstract(method.getModifiers());
    }

    public static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static boolean isPublic(Field field) {
        return Modifier.isPublic(field.getModifiers());
    }

    public static boolean isProtected(Field field) {
        return Modifier.isProtected(field.getModifiers());
    }

    public static boolean isPrivate(Field field) {
        return Modifier.isPrivate(field.getModifiers());
    }

    public static boolean isPackagePrivate(Field field) {
        return !ReflectionUtils.isPublic(field) && !ReflectionUtils.isProtected(field) && !ReflectionUtils.isPrivate(field);
    }

    public static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isProtected(Class<?> clazz) {
        return Modifier.isProtected(clazz.getModifiers());
    }

    public static boolean isPrivate(Class<?> clazz) {
        return Modifier.isPrivate(clazz.getModifiers());
    }

    public static boolean isPackagePrivate(Class<?> clazz) {
        return !ReflectionUtils.isPublic(clazz) && !ReflectionUtils.isProtected(clazz) && !ReflectionUtils.isPrivate(clazz);
    }

    public static Map<String, Method> getMethods(Class<?> clazz) {
        int n;
        HashMap<String, Method> methods = new HashMap<String, Method>();
        Class<?> c = clazz;
        while (c != null) {
            Method[] methodArray = c.getDeclaredMethods();
            int n2 = methodArray.length;
            n = 0;
            while (n < n2) {
                String signature;
                Method method = methodArray[n];
                if (method.trySetAccessible() && !methods.containsKey(signature = ReflectionUtils.getMethodSignature(method))) {
                    methods.put(signature, method);
                }
                ++n;
            }
            c = c.getSuperclass();
        }
        Class<?>[] classArray = clazz.getInterfaces();
        n = classArray.length;
        int n3 = 0;
        while (n3 < n) {
            Class<?> interfaceClass = classArray[n3];
            Method[] methodArray = interfaceClass.getDeclaredMethods();
            int n4 = methodArray.length;
            int n5 = 0;
            while (n5 < n4) {
                String signature;
                Method method = methodArray[n5];
                if (method.trySetAccessible() && !methods.containsKey(signature = ReflectionUtils.getMethodSignature(method))) {
                    methods.put(signature, method);
                }
                ++n5;
            }
            ++n3;
        }
        return methods;
    }

    public static String getMethodSignature(Method method) {
        Assert.isNotNull(method);
        return ReflectionUtils.getMethodSignature(method.getName(), method.getParameterTypes());
    }

    public static String getMethodSignature(String name, Type ... parameterTypes) {
        Assert.isNotNull(name);
        Assert.isNotNull(parameterTypes);
        StringBuilder buffer = new StringBuilder();
        buffer.append(name);
        ReflectionUtils.appendParameterTypes(buffer, parameterTypes);
        return buffer.toString();
    }

    public static String getMethodGenericSignature(Method method) {
        Assert.isNotNull(method);
        return ReflectionUtils.getMethodSignature(method.getName(), method.getGenericParameterTypes());
    }

    public static Method getMethodByName(Class<?> clazz, String name) {
        Assert.isNotNull(clazz);
        Assert.isNotNull(name);
        for (Method method : ReflectionUtils.getMethods(clazz).values()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public static Method getMethodBySignature(Class<?> clazz, String signature) {
        Assert.isNotNull(clazz);
        Assert.isNotNull(signature);
        Map<String, Method> cache = m_getMethodBySignature.get(clazz);
        if (cache == null) {
            cache = ReflectionUtils.getMethods(clazz);
            m_getMethodBySignature.put(clazz, cache);
        }
        return cache.get(signature);
    }

    public static Method getMethodByGenericSignature(Class<?> clazz, String signature) {
        Assert.isNotNull(clazz);
        Assert.isNotNull(signature);
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (ReflectionUtils.getMethodGenericSignature(method).equals(signature)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        Assert.isNotNull(clazz);
        Assert.isNotNull(name);
        Assert.isNotNull(parameterTypes);
        String signature = ReflectionUtils.getMethodSignature(name, parameterTypes);
        return ReflectionUtils.getMethodBySignature(clazz, signature);
    }

    public static boolean isAlreadyDeclaredIn(Method method, Class<?> targetClass) {
        Class<?> declaringClass = method.getDeclaringClass();
        return declaringClass.isAssignableFrom(targetClass);
    }

    public static boolean isMoreSpecific(Method base, Method specific) {
        return base.getName().equals(specific.getName()) && ReflectionUtils.isMoreSpecific(base.getParameterTypes(), specific.getParameterTypes());
    }

    public static Method getMostSpecific(List<Method> methods) {
        Method mostSpecific = null;
        for (Method method : methods) {
            if (mostSpecific != null && !ReflectionUtils.isMoreSpecific(mostSpecific, method)) continue;
            mostSpecific = method;
        }
        return mostSpecific;
    }

    public static Object invokeMethodEx(Object object, String signature, Object ... arguments) {
        try {
            return ReflectionUtils.invokeMethod(object, signature, arguments);
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate(e);
        }
    }

    public static Object invokeMethod(Object object, String signature, Object ... arguments) throws Exception {
        Assert.isNotNull(object);
        Assert.isNotNull(arguments);
        Class<?> refClass = ReflectionUtils.getRefClass(object);
        Object refObject = ReflectionUtils.getRefObject(object);
        Method method = ReflectionUtils.getMethodBySignature(refClass, signature);
        Assert.isNotNull(method, "Can not find method " + signature + " in " + String.valueOf(refClass));
        return ReflectionUtils.invokeMethod(method, refObject, arguments);
    }

    public static Object invokeMethod(Method method, Object object, Object ... arguments) throws Exception {
        Assert.isNotNull(method);
        Assert.isNotNull(arguments);
        try {
            if (method.trySetAccessible()) {
                return method.invoke(object, arguments);
            }
            return null;
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.propagate(e.getCause());
        }
    }

    public static Object invokeMethod2(Object object, String name) throws Exception {
        return ReflectionUtils.invokeMethod(object, name + "()", new Object[0]);
    }

    public static Object invokeMethod2(Object object, String name, Class<?> parameterType_1, Object argument_1) throws Exception {
        Class[] types = new Class[]{parameterType_1};
        Object[] values = new Object[]{argument_1};
        return ReflectionUtils.invokeMethod2(object, name, types, values);
    }

    public static Object invokeMethod2(Object object, String name, Class<?> parameterType_1, Class<?> parameterType_2, Object argument_1, Object argument_2) throws Exception {
        Class[] types = new Class[]{parameterType_1, parameterType_2};
        Object[] values = new Object[]{argument_1, argument_2};
        return ReflectionUtils.invokeMethod2(object, name, types, values);
    }

    public static Object invokeMethod2(Object object, String name, Class<?> parameterType_1, Class<?> parameterType_2, Class<?> parameterType_3, Object argument_1, Object argument_2, Object argument_3) throws Exception {
        Class[] types = new Class[]{parameterType_1, parameterType_2, parameterType_3};
        Object[] values = new Object[]{argument_1, argument_2, argument_3};
        return ReflectionUtils.invokeMethod2(object, name, types, values);
    }

    public static Object invokeMethod2(Object object, String name, Class<?> parameterType_1, Class<?> parameterType_2, Class<?> parameterType_3, Class<?> parameterType_4, Object argument_1, Object argument_2, Object argument_3, Object argument_4) throws Exception {
        Class[] types = new Class[]{parameterType_1, parameterType_2, parameterType_3, parameterType_4};
        Object[] values = new Object[]{argument_1, argument_2, argument_3, argument_4};
        return ReflectionUtils.invokeMethod2(object, name, types, values);
    }

    public static Object invokeMethod2(Object object, String name, Class<?>[] parameterTypes, Object[] arguments) throws Exception {
        Assert.equals(parameterTypes.length, arguments.length);
        String signature = ReflectionUtils.getMethodSignature(name, parameterTypes);
        return ReflectionUtils.invokeMethod(object, signature, arguments);
    }

    public static String getConstructorSignature(Constructor<?> constructor) {
        Assert.isNotNull(constructor);
        return ReflectionUtils.getConstructorSignature(constructor.getParameterTypes());
    }

    public static String getConstructorGenericSignature(Constructor<?> constructor) {
        Assert.isNotNull(constructor);
        return ReflectionUtils.getConstructorSignature(constructor.getGenericParameterTypes());
    }

    public static String getConstructorSignature(Type ... parameterTypes) {
        Assert.isNotNull(parameterTypes);
        StringBuilder buffer = new StringBuilder();
        buffer.append("<init>");
        ReflectionUtils.appendParameterTypes(buffer, parameterTypes);
        return buffer.toString();
    }

    public static <T> Constructor<T> getConstructorBySignature(Class<T> clazz, String signature) {
        Assert.isNotNull(clazz);
        Assert.isNotNull(signature);
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            if (ReflectionUtils.getConstructorSignature(constructor).equals(signature)) {
                return constructor;
            }
            ++n2;
        }
        return null;
    }

    public static <T> Constructor<T> getConstructorByGenericSignature(Class<T> clazz, String signature) {
        Assert.isNotNull(clazz);
        Assert.isNotNull(signature);
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            if (ReflectionUtils.getConstructorGenericSignature(constructor).equals(signature)) {
                return constructor;
            }
            ++n2;
        }
        return null;
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Assert.isNotNull(clazz);
        Assert.isNotNull(parameterTypes);
        String signature = ReflectionUtils.getConstructorSignature(parameterTypes);
        return ReflectionUtils.getConstructorBySignature(clazz, signature);
    }

    public static <T> Constructor<T> getConstructorForArguments(Class<T> clazz, Object ... arguments) {
        Assert.isNotNull(clazz);
        Assert.isNotNull(arguments);
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            boolean canUse = true;
            if (parameterTypes.length == arguments.length) {
                int i = 0;
                while (i < parameterTypes.length) {
                    Class<?> parameterType = parameterTypes[i];
                    Object argument = arguments[i];
                    if (!ReflectionUtils.isAssignableFrom(parameterType, argument)) {
                        canUse = false;
                        break;
                    }
                    ++i;
                }
                if (canUse) {
                    return constructor;
                }
            }
            ++n2;
        }
        return null;
    }

    public static <T> T newInstance(Class<T> clazz, String signature, Object ... arguments) {
        Constructor<T> constructor = ReflectionUtils.getConstructorBySignature(clazz, signature);
        return ReflectionUtils.newInstance(constructor, arguments);
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... arguments) {
        block4: {
            if (constructor == null) {
                return null;
            }
            try {
                if (!constructor.trySetAccessible()) break block4;
                return constructor.newInstance(arguments);
            }
            catch (IllegalArgumentException e) {
                throw ReflectionUtils.propagate(e.getCause());
            }
            catch (ReflectiveOperationException e) {
                throw ReflectionUtils.propagate(e);
            }
        }
        return null;
    }

    public static boolean equals(Constructor<?> constructor_1, Constructor<?> constructor_2) {
        if (constructor_1 == constructor_2) {
            return true;
        }
        return constructor_1.getDeclaringClass() == constructor_2.getDeclaringClass() && Objects.equals(ReflectionUtils.getConstructorSignature(constructor_1), ReflectionUtils.getConstructorSignature(constructor_2));
    }

    public static Constructor<?> getShortestConstructor(Class<?> clazz) {
        Constructor<?> shortest = null;
        int minCount = Integer.MAX_VALUE;
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            int thisCount = constructor.getParameterTypes().length;
            if (minCount > thisCount) {
                shortest = constructor;
                minCount = thisCount;
            }
            ++n2;
        }
        return shortest;
    }

    public static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                fields.add(field);
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static Field getFieldByName(Class<?> clazz, String name) {
        Assert.isNotNull(clazz);
        Assert.isNotNull(name);
        while (clazz != null) {
            Class<?>[] interfaceClasses;
            Field[] declaredFields;
            Field[] fieldArray = declaredFields = clazz.getDeclaredFields();
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getName().equals(name)) {
                    return field;
                }
                ++n2;
            }
            Class<?>[] classArray = interfaceClasses = clazz.getInterfaces();
            int n3 = interfaceClasses.length;
            n = 0;
            while (n < n3) {
                Class<?> interfaceClass = classArray[n];
                Field field = ReflectionUtils.getFieldByName(interfaceClass, name);
                if (field != null) {
                    return field;
                }
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Object getFieldObject(Object object, String name) {
        return ReflectionUtils.getFieldObject(object, name, true);
    }

    public static Object getFieldOptObject(Object object, String name) {
        return ReflectionUtils.getFieldObject(object, name, false);
    }

    private static Object getFieldObject(Object object, String name, boolean errorIfMissing) {
        Assert.isNotNull(object);
        Assert.isNotNull(name);
        return ExecutionUtils.runObject(() -> {
            Class<?> refClass = ReflectionUtils.getRefClass(object);
            Object refObject = ReflectionUtils.getRefObject(object);
            Field field = ReflectionUtils.getFieldByName(refClass, name);
            if (field == null) {
                if (errorIfMissing) {
                    String msg = "Unable to find '%s' in '%s'".formatted(name, refClass);
                    throw new IllegalArgumentException(msg);
                }
                return null;
            }
            if (field.trySetAccessible()) {
                return field.get(refObject);
            }
            return null;
        });
    }

    public static String getFieldString(Object object, String name) {
        return (String)ReflectionUtils.getFieldObject(object, name);
    }

    public static int getFieldInt(Object object, String name) {
        return (Integer)ReflectionUtils.getFieldObject(object, name);
    }

    public static short getFieldShort(Object object, String name) {
        return (Short)ReflectionUtils.getFieldObject(object, name);
    }

    public static long getFieldLong(Object object, String name) {
        return (Long)ReflectionUtils.getFieldObject(object, name);
    }

    public static float getFieldFloat(Object object, String name) {
        return ((Float)ReflectionUtils.getFieldObject(object, name)).floatValue();
    }

    public static boolean getFieldBoolean(Object object, String name) {
        return (Boolean)ReflectionUtils.getFieldObject(object, name);
    }

    public static double getFieldDouble(Object object, String name) {
        return (Double)ReflectionUtils.getFieldObject(object, name);
    }

    public static void setField(Object object, String name, Object value) {
        ReflectionUtils.setField(object, name, value, true);
    }

    public static void setFieldOpt(Object object, String name, Object value) {
        ReflectionUtils.setField(object, name, value, false);
    }

    private static void setField(Object object, String name, Object value, boolean errorIfMissing) {
        try {
            Assert.isNotNull(object);
            Class<?> refClass = ReflectionUtils.getRefClass(object);
            Object refObject = ReflectionUtils.getRefObject(object);
            Field field = ReflectionUtils.getFieldByName(refClass, name);
            if (field == null) {
                if (errorIfMissing) {
                    String msg = "Unable to find '%s' in '%s'".formatted(name, refClass);
                    throw new IllegalArgumentException(msg);
                }
                return;
            }
            FieldUtils.writeField((Field)ReflectionUtils.getFieldByName(refClass, name), (Object)refObject, (Object)value, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.propagate(e);
        }
    }

    private static Class<?> getRefClass(Object object) {
        return object instanceof Class ? (Class<?>)object : object.getClass();
    }

    private static Object getRefObject(Object object) {
        return object instanceof Class ? null : object;
    }

    public static RuntimeException propagate(Throwable throwable) {
        if (System.getProperty("wbp.ReflectionUtils.propagate().forceReturn") == null) {
            ExceptionThrower.spit(throwable);
        }
        return null;
    }

    public static Exception getExceptionToThrow(Throwable e) {
        if (e instanceof Exception) {
            return (Exception)e;
        }
        return new Exception(e);
    }

    public static BeanInfo getBeanInfo(Class<?> clazz) throws IntrospectionException {
        String className = clazz.getName();
        if (className.startsWith("java.lang.") || className.startsWith("java.awt.") || className.startsWith("javax.swing.") || className.startsWith("org.eclipse.swt") || className.startsWith("org.eclipse.jface") || className.startsWith("org.eclipse.ui.forms")) {
            return null;
        }
        Introspector.flushCaches();
        String[] standard_beanInfoSearchPath = Introspector.getBeanInfoSearchPath();
        try {
            Introspector.setBeanInfoSearchPath(new String[0]);
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            return beanInfo;
        }
        finally {
            Introspector.flushCaches();
            Introspector.setBeanInfoSearchPath(standard_beanInfoSearchPath);
        }
    }

    public static void flushPropertyDescriptorsCache(Class<?> clazz) {
        m_propertyDescriptorsCache.remove(clazz);
    }

    public static List<PropertyDescriptor> getPropertyDescriptors(BeanInfo beanInfo, Class<?> componentClass) throws Exception {
        List<PropertyDescriptor> descriptors = m_propertyDescriptorsCache.get(componentClass);
        if (descriptors != null) {
            return descriptors;
        }
        descriptors = new ArrayList<PropertyDescriptor>();
        if (beanInfo != null) {
            Collections.addAll(descriptors, beanInfo.getPropertyDescriptors());
            Iterator<PropertyDescriptor> I = descriptors.iterator();
            while (I.hasNext()) {
                PropertyDescriptor descriptor = I.next();
                if (!(descriptor instanceof IndexedPropertyDescriptor)) continue;
                I.remove();
            }
        }
        TreeMap<String, Method> propertyToGetter = new TreeMap<String, Method>();
        TreeMap<String, Method> propertyToSetter = new TreeMap<String, Method>();
        for (PropertyDescriptor propertyDescriptor : descriptors) {
            String propertyName;
            Method readMethod = ReflectionUtils.getReadMethod(propertyDescriptor);
            Method writeMethod = ReflectionUtils.getWriteMethod(propertyDescriptor);
            if (readMethod != null) {
                propertyName = ReflectionUtils.getQualifiedPropertyName(readMethod);
                propertyToGetter.put(propertyName, readMethod);
                propertyDescriptor.setName(propertyName);
            }
            if (writeMethod == null) continue;
            propertyName = ReflectionUtils.getQualifiedPropertyName(writeMethod);
            propertyToSetter.put(propertyName, writeMethod);
            propertyDescriptor.setName(propertyName);
        }
        TreeSet<String> newPropertyNames = new TreeSet<String>();
        ReflectionUtils.appendPropertyComponents(componentClass, newPropertyNames, propertyToGetter, propertyToSetter);
        for (String propertyName : newPropertyNames) {
            ReflectionUtils.addPropertyDescriptor(descriptors, propertyName, propertyToGetter, propertyToSetter);
        }
        ReflectionUtils.useSimplePropertyNamesWherePossible(descriptors);
        m_propertyDescriptorsCache.put(componentClass, descriptors);
        return descriptors;
    }

    private static void useSimplePropertyNamesWherePossible(List<PropertyDescriptor> descriptors) {
        String simplePropertyName;
        String qualifiedPropertyName;
        HashSetValuedHashMap simplePropertyNames = new HashSetValuedHashMap();
        for (PropertyDescriptor propertyDescriptor : descriptors) {
            qualifiedPropertyName = propertyDescriptor.getName();
            simplePropertyName = ReflectionUtils.getSimplePropertyName(qualifiedPropertyName);
            simplePropertyNames.put((Object)simplePropertyName, (Object)qualifiedPropertyName);
        }
        for (PropertyDescriptor propertyDescriptor : descriptors) {
            qualifiedPropertyName = propertyDescriptor.getName();
            simplePropertyName = ReflectionUtils.getSimplePropertyName(qualifiedPropertyName);
            if (simplePropertyNames.get((Object)simplePropertyName).size() != 1) continue;
            propertyDescriptor.setName(simplePropertyName);
        }
    }

    private static void addPropertyDescriptor(List<PropertyDescriptor> descriptors, String qualifiedPropertyName, Map<String, Method> propertyToGetter, Map<String, Method> propertyToSetter) throws Exception {
        if (qualifiedPropertyName.startsWith("(")) {
            return;
        }
        Method getMethod = propertyToGetter.get(qualifiedPropertyName);
        Method setMethod = propertyToSetter.get(qualifiedPropertyName);
        if (!ReflectionUtils.isValidForJavaIBM(getMethod) || !ReflectionUtils.isValidForJavaIBM(setMethod)) {
            return;
        }
        if (getMethod != null && getMethod.getReturnType() == Void.TYPE) {
            return;
        }
        descriptors.add(new PropertyDescriptor(qualifiedPropertyName, getMethod, setMethod));
    }

    private static boolean isValidForJavaIBM(Method method) {
        if (method == null) {
            return true;
        }
        return !EnvironmentUtils.isJavaIBM() || ReflectionUtils.isPublic(method);
    }

    private static void appendPropertyComponents(Class<?> currentClass, Set<String> newPropertyNames, Map<String, Method> propertyToGetter, Map<String, Method> propertyToSetter) {
        GenericDeclaration[] genericDeclarationArray = currentClass.getDeclaredMethods();
        int n = genericDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = genericDeclarationArray[n2];
            int methodModifiers = method.getModifiers();
            boolean isPublic = Modifier.isPublic(methodModifiers);
            boolean isProtected = Modifier.isProtected(methodModifiers);
            boolean isStatic = Modifier.isStatic(methodModifiers);
            if (!method.isBridge() && !isStatic && (isPublic || isProtected)) {
                String propertyName;
                String methodName = method.getName();
                if (methodName.startsWith("set") && method.getParameterTypes().length == 1 && !propertyToSetter.containsKey(propertyName = ReflectionUtils.getQualifiedPropertyName(method))) {
                    newPropertyNames.add(propertyName);
                    propertyToSetter.put(propertyName, method);
                }
                if (method.getParameterTypes().length == 0) {
                    if (methodName.startsWith("get") && !propertyToGetter.containsKey(propertyName = ReflectionUtils.getQualifiedPropertyName(method))) {
                        newPropertyNames.add(propertyName);
                        propertyToGetter.put(propertyName, method);
                    }
                    if (methodName.startsWith("is") && !propertyToGetter.containsKey(propertyName = ReflectionUtils.getQualifiedPropertyName(method))) {
                        newPropertyNames.add(propertyName);
                        propertyToGetter.put(propertyName, method);
                    }
                }
            }
            ++n2;
        }
        genericDeclarationArray = currentClass.getInterfaces();
        n = genericDeclarationArray.length;
        n2 = 0;
        while (n2 < n) {
            GenericDeclaration interfaceClass = genericDeclarationArray[n2];
            ReflectionUtils.appendPropertyComponents(interfaceClass, newPropertyNames, propertyToGetter, propertyToSetter);
            ++n2;
        }
        if (currentClass.getSuperclass() != null) {
            ReflectionUtils.appendPropertyComponents(currentClass.getSuperclass(), newPropertyNames, propertyToGetter, propertyToSetter);
        }
    }

    private static String getQualifiedPropertyName(Method method) {
        Object types;
        String propertyName = method.getName();
        if (propertyName.startsWith("is")) {
            propertyName = propertyName.substring(2);
        } else if (propertyName.startsWith("get")) {
            propertyName = propertyName.substring(3);
        } else if (propertyName.startsWith("set")) {
            propertyName = propertyName.substring(3);
        }
        propertyName = Introspector.decapitalize(propertyName);
        Type[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            types = "(" + ReflectionUtils.getFullyQualifiedName(method.getReturnType(), false) + ")";
        } else {
            StringBuilder buffer = new StringBuilder();
            ReflectionUtils.appendParameterTypes(buffer, parameterTypes);
            types = buffer.toString();
        }
        return propertyName + (String)types;
    }

    private static String getSimplePropertyName(String qualifiedPropertyName) {
        return StringUtils.substringBefore((String)qualifiedPropertyName, (String)"(");
    }

    private static class ExceptionThrower {
        private ExceptionThrower() {
        }

        private static synchronized void spit(Throwable t) {
            if (System.getProperty("wbp.ReflectionUtils.propagate().dontThrow") == null) {
                try {
                    if (System.getProperty("wbp.ReflectionUtils.propagate().InstantiationException") != null) {
                        ExceptionThrower.spit0(new InstantiationException());
                    }
                    if (System.getProperty("wbp.ReflectionUtils.propagate().IllegalAccessException") != null) {
                        ExceptionThrower.spit0(new IllegalAccessException());
                    }
                    ExceptionThrower.spit0(t);
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }

        private static <T extends Throwable> void spit0(Throwable t) throws T, InstantiationException, IllegalAccessException {
            throw t;
        }
    }

    private static enum IsSuccessorResult {
        UNKNOWN,
        FALSE,
        TRUE;

    }
}

