/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.presentation;

import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;

public final class CFlatButton
extends Label {
    private static final Color COLOR_FACE = DrawUtils.getShiftedColor(ColorConstants.button, 12);
    private static final Color COLOR_FACE_SELECTED = ColorConstants.buttonDarker;
    private static final Color COLOR_BORDER_GRADIENT1 = DrawUtils.getShiftedColor(COLOR_FACE, -12);
    private static final Color COLOR_BORDER_GRADIENT1_SELECTED = DrawUtils.getShiftedColor(COLOR_FACE_SELECTED, 64);
    private static final Color COLOR_BORDER_GRADIENT2 = DrawUtils.getShiftedColor(COLOR_FACE, -8);
    private static final Color COLOR_BORDER_GRADIENT2_SELECTED = DrawUtils.getShiftedColor(COLOR_FACE_SELECTED, -8);
    private Image m_image;
    private ButtonModel m_model;

    public CFlatButton(ButtonModel model, Image image) {
        this.m_model = model;
        this.m_image = image;
    }

    public void paint(Graphics gc) {
        boolean isSelected = this.m_model.isPressed() | this.m_model.isSelected();
        Color faceColor = isSelected ? COLOR_FACE_SELECTED : COLOR_FACE;
        Color borderGradientColor1 = isSelected ? COLOR_BORDER_GRADIENT1_SELECTED : COLOR_BORDER_GRADIENT1;
        Color borderGradientColor2 = isSelected ? COLOR_BORDER_GRADIENT2_SELECTED : COLOR_BORDER_GRADIENT2;
        Rectangle ca = this.getClientArea();
        gc.setForegroundColor(ColorConstants.buttonDarker);
        gc.drawRectangle(ca.x, ca.y, ca.width - 1, ca.height - 1);
        this.cropClientArea(ca);
        gc.setForegroundColor(borderGradientColor1);
        gc.setBackgroundColor(borderGradientColor2);
        gc.fillGradient(ca.x, ca.y, ca.width, ca.height, true);
        this.cropClientArea(ca);
        gc.setBackgroundColor(faceColor);
        gc.fillRectangle(ca);
        Rectangle ca1 = this.getClientArea();
        this.cropClientArea(ca1);
        gc.setForegroundColor(faceColor);
        gc.setBackgroundColor(borderGradientColor1);
        gc.fillGradient(ca1.x, ca1.y, ca1.width, ca1.height / 4, true);
        ++ca1.x;
        ca1.width -= 2;
        gc.setForegroundColor(borderGradientColor1);
        gc.setBackgroundColor(faceColor);
        gc.fillGradient(ca1.x, ca1.y + ca1.height / 4 - 1, ca1.width, ca1.height / 2, true);
        if (this.m_image != null) {
            org.eclipse.swt.graphics.Rectangle imageBounds = this.m_image.getBounds();
            int x = ca.x + (ca.width - imageBounds.width) / 2;
            int y = ca.y + (ca.height - imageBounds.height) / 2;
            gc.drawImage(this.m_image, x, y);
        }
    }

    private void cropClientArea(Rectangle ca) {
        ++ca.x;
        ++ca.y;
        ca.width -= 2;
        ca.height -= 2;
    }
}

