/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;

public abstract class AbstractComboPropertyEditor
extends TextDisplayPropertyEditor {
    private CCombo m_combo;
    private boolean m_doDropDown;

    @Override
    public boolean activate(final PropertyTable propertyTable, final Property property, Point location) throws Exception {
        this.m_combo = new CCombo((Composite)propertyTable.getControl(), 0);
        this.m_doDropDown = true;
        this.addItems(property, this.m_combo);
        this.selectItem(property, this.m_combo);
        this.m_combo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                propertyTable.deactivateEditor(true);
            }
        });
        this.m_combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AbstractComboPropertyEditor.this.m_combo.getSelectionIndex();
                AbstractComboPropertyEditor.this.toProperty(propertyTable, property, index);
            }
        });
        this.m_combo.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                switch (event.keyCode) {
                    case 27: {
                        propertyTable.deactivateEditor(false);
                        break;
                    }
                    case 127: {
                        try {
                            property.setValue(Property.UNKNOWN_VALUE);
                            event.doit = false;
                            AbstractComboPropertyEditor.this.selectItem(property, AbstractComboPropertyEditor.this.m_combo);
                        }
                        catch (Throwable e) {
                            propertyTable.handleException(e);
                            propertyTable.deactivateEditor(false);
                        }
                        AbstractComboPropertyEditor.this.m_combo.setListVisible(false);
                    }
                }
            }
        });
        this.m_combo.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                int index = (AbstractComboPropertyEditor.this.m_combo.getSelectionIndex() + 1) % AbstractComboPropertyEditor.this.m_combo.getItemCount();
                AbstractComboPropertyEditor.this.toProperty(propertyTable, property, index);
            }
        });
        return true;
    }

    @Override
    public final void setBounds(Rectangle bounds) {
        this.m_combo.setBounds(bounds);
        if (this.m_doDropDown) {
            this.m_doDropDown = false;
            this.m_combo.setFocus();
            this.m_combo.setListVisible(true);
        }
    }

    @Override
    public final void deactivate(PropertyTable propertyTable, Property property, boolean save) {
        if (this.m_combo != null) {
            this.m_combo.dispose();
            this.m_combo = null;
        }
    }

    protected abstract void addItems(Property var1, CCombo var2) throws Exception;

    protected abstract void selectItem(Property var1, CCombo var2) throws Exception;

    protected abstract void toPropertyEx(Property var1, CCombo var2, int var3) throws Exception;

    private void toProperty(PropertyTable propertyTable, Property property, int index) {
        try {
            this.toPropertyEx(property, this.m_combo, index);
        }
        catch (Throwable e) {
            propertyTable.handleException(e);
        }
        propertyTable.deactivateEditor(false);
    }
}

