/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.actions.assistant;

import java.util.ArrayList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.actions.assistant.LayoutAssistantWindow;

public final class LayoutAssistantAction
extends Action {
    private final IEditorPart m_editor;
    private final EditPartViewer m_viewer;
    private LayoutAssistantWindow m_assistantWindow;
    private final IWorkbenchWindow m_workbenchWindow;
    private final IPartListener m_windowPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (LayoutAssistantAction.this.m_editor == part && LayoutAssistantAction.this.m_assistantWindow != null) {
                LayoutAssistantAction.this.m_assistantWindow.open();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (LayoutAssistantAction.this.m_editor == part && LayoutAssistantAction.this.m_assistantWindow != null) {
                LayoutAssistantAction.this.m_assistantWindow.hide();
            }
        }

        public void partClosed(IWorkbenchPart part) {
            if (LayoutAssistantAction.this.m_editor == part) {
                LayoutAssistantAction.this.closeWindow();
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }
    };

    public LayoutAssistantAction(IEditorPart editor, EditPartViewer viewer) {
        super(Messages.LayoutAssistantAction_text, 2);
        this.setToolTipText(Messages.LayoutAssistantAction_toolTip);
        this.setImageDescriptor(DesignerPlugin.getImageDescriptor("actions/assistant/assistant.png"));
        this.setDisabledImageDescriptor(DesignerPlugin.getImageDescriptor("actions/assistant/assistant_disabled.png"));
        this.m_editor = editor;
        this.m_workbenchWindow = this.m_editor.getEditorSite().getWorkbenchWindow();
        this.m_viewer = viewer;
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LayoutAssistantAction.this.updateWindow();
            }
        });
    }

    public void setRoot(ObjectInfo rootObject) {
        rootObject.addBroadcastListener(new ObjectEventListener(){

            @Override
            public void refreshed() throws Exception {
                LayoutAssistantAction.this.updateWindow();
            }
        });
    }

    public void run() {
        if (this.m_assistantWindow == null) {
            this.m_assistantWindow = new LayoutAssistantWindow(DesignerPlugin.getShell());
            this.setChecked(true);
            this.showWindow();
            this.updateWindow();
        } else {
            this.closeWindow();
        }
    }

    public void showWindow() {
        if (this.m_assistantWindow != null) {
            this.m_workbenchWindow.getPartService().addPartListener(this.m_windowPartListener);
            this.m_assistantWindow.open();
            this.m_assistantWindow.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    LayoutAssistantAction.this.setChecked(false);
                    LayoutAssistantAction.this.m_assistantWindow = null;
                }
            });
        }
    }

    public void hideWindow() {
        if (this.m_assistantWindow != null) {
            this.m_workbenchWindow.getPartService().removePartListener(this.m_windowPartListener);
            this.m_assistantWindow.hide();
        }
    }

    public void closeWindow() {
        if (this.m_assistantWindow != null) {
            this.hideWindow();
            this.m_assistantWindow.close();
            this.m_assistantWindow = null;
        }
    }

    private void updateWindow() {
        if (this.m_assistantWindow != null) {
            ArrayList<Object> selectedObjects = new ArrayList<Object>();
            for (EditPart editPart : this.m_viewer.getSelectedEditParts()) {
                selectedObjects.add(editPart.getModel());
            }
            this.m_assistantWindow.update(selectedObjects);
        }
    }
}

