/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.eval;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.eval.ExecutionFlowProvider;
import org.eclipse.wb.internal.core.model.variable.LazyVariableSupportUtils;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.MultipleConstructorsError;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;

public final class ExecutionFlowUtils {
    static final String KEY_FRAME_INVOCATION = "ExecutionFlowUtils.frameInvocation";
    private static final String WBP_PARSER_CONSTRUCTOR = "@wbp.parser.constructor";
    private static final TypeCache<TypeCache.SimpleKey> PROXY_CACHE = new TypeCache.WithInlineExpunction(TypeCache.Sort.WEAK);
    private static final String KEY_LAST_VARIABLE_STAMP = "KEY_LAST_VARIABLE_STAMP";
    private static final String KEY_DECLARATION = "KEY_DECLARATION";
    private static final String KEY_REFERENCES = "KEY_REFERENCES";
    private static final String KEY_ASSIGNMENTS = "KEY_ASSIGNMENTS";
    private static final String KEY_LAST_ASSIGNMENT = "KEY_LAST_ASSIGNMENT";
    private static final String KEY_LAST_DECLARATION_ASSIGNMENT = "KEY_LAST_DECLARATION_ASSIGNMENT";

    private ExecutionFlowUtils() {
    }

    public static void visit(VisitingContext context, ExecutionFlowDescription flowDescription, ExecutionFlowFrameVisitor visitor) {
        ExecutionFlowUtils.visit(context, flowDescription, visitor, flowDescription.getStartMethods());
    }

    public static void visit(VisitingContext context, ExecutionFlowDescription flowDescription, ExecutionFlowFrameVisitor visitor, List<MethodDeclaration> methodsToVisit) {
        TypeDeclaration typeDeclaration = AstNodeUtils.getParentType(methodsToVisit.get(0));
        if (!context.instanceInitialized) {
            visitor.enterFrame((ASTNode)typeDeclaration);
        }
        for (MethodDeclaration method : methodsToVisit) {
            if (!context.classInitialized) {
                ExecutionFlowUtils.visitFields(visitor, typeDeclaration, true);
                ExecutionFlowUtils.visitInitializers(context, flowDescription, visitor, typeDeclaration, true);
                context.classInitialized = true;
            }
            if (!context.instanceInitialized && !AstNodeUtils.isStatic((BodyDeclaration)method)) {
                ExecutionFlowUtils.visitFields(visitor, typeDeclaration, false);
                ExecutionFlowUtils.visitInitializers(context, flowDescription, visitor, typeDeclaration, false);
                context.instanceInitialized = true;
            }
            ExecutionFlowUtils.visit(context, flowDescription, visitor, method);
        }
    }

    private static void visit(VisitingContext context, ExecutionFlowDescription flowDescription, ExecutionFlowFrameVisitor visitor, MethodDeclaration method) {
        if (visitor.enterFrame((ASTNode)method)) {
            for (SingleVariableDeclaration parameter : DomGenerics.parameters(method)) {
                parameter.accept((ASTVisitor)visitor);
            }
            Block body = method.getBody();
            if (body != null) {
                ExecutionFlowUtils.visitStatement(context, flowDescription, (Statement)body, visitor);
            }
            visitor.leaveFrame((ASTNode)method);
        }
    }

    private static void visitFields(ExecutionFlowFrameVisitor visitor, TypeDeclaration typeDeclaration, boolean onlyStatic) {
        FieldDeclaration[] fields;
        FieldDeclaration[] fieldDeclarationArray = fields = typeDeclaration.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            boolean isStatic = AstNodeUtils.isStatic((BodyDeclaration)fieldDeclaration);
            if (onlyStatic && isStatic) {
                fieldDeclaration.accept((ASTVisitor)visitor);
            }
            if (!onlyStatic && !isStatic) {
                fieldDeclaration.accept((ASTVisitor)visitor);
            }
            ++n2;
        }
    }

    private static void visitInitializers(VisitingContext context, ExecutionFlowDescription flowDescription, ExecutionFlowFrameVisitor visitor, TypeDeclaration typeDeclaration, boolean onlyStatic) {
        List<BodyDeclaration> bodyDeclarations = DomGenerics.bodyDeclarations(typeDeclaration);
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            boolean isStatic = AstNodeUtils.isStatic(bodyDeclaration);
            if (!(bodyDeclaration instanceof Initializer)) continue;
            Initializer initializer = (Initializer)bodyDeclaration;
            if (context == null) continue;
            if (onlyStatic && isStatic) {
                ExecutionFlowUtils.visitStatement(context, flowDescription, (Statement)initializer.getBody(), visitor);
            }
            if (onlyStatic || isStatic) continue;
            ExecutionFlowUtils.visitStatement(context, flowDescription, (Statement)initializer.getBody(), visitor);
        }
    }

    private static void visitStatement(VisitingContext context, ExecutionFlowDescription flowDescription, Statement statement, ExecutionFlowFrameVisitor visitor) {
        if (statement.getLocationInParent() == MethodDeclaration.BODY_PROPERTY) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)statement.getParent();
            if (context.visitedMethods.contains(methodDeclaration)) {
                return;
            }
            context.visitedMethods.add(methodDeclaration);
        }
        ExecutionFlowUtils.visitBinaryFlowMethods(true, context, flowDescription, statement, visitor);
        flowDescription.enterStatement(statement);
        try {
            ExecutionFlowUtils.visitStatement0(context, flowDescription, statement, visitor);
        }
        finally {
            flowDescription.leaveStatement(statement);
        }
        ExecutionFlowUtils.visitBinaryFlowMethods(false, context, flowDescription, statement, visitor);
    }

    private static void visitStatement0(VisitingContext context, ExecutionFlowDescription flowDescription, Statement statement, ExecutionFlowFrameVisitor visitor) {
        visitor.m_currentStatement = statement;
        if (statement instanceof Block) {
            Block block = (Block)statement;
            if (visitor.enterFrame((ASTNode)block)) {
                for (Statement childStatement : DomGenerics.statements(block)) {
                    ExecutionFlowUtils.visitStatement(context, flowDescription, childStatement, visitor);
                }
                visitor.leaveFrame((ASTNode)block);
            }
        } else if (statement instanceof TryStatement) {
            TryStatement tryStatement = (TryStatement)statement;
            ExecutionFlowUtils.visitStatement(context, flowDescription, (Statement)tryStatement.getBody(), visitor);
        } else if (statement instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)statement;
            if (ExecutionFlowUtils.shouldVisit_IfStatement_Then(ifStatement)) {
                ExecutionFlowUtils.visitStatement(context, flowDescription, ifStatement.getThenStatement(), visitor);
            } else if (ifStatement.getElseStatement() != null && ExecutionFlowUtils.shouldVisit_IfStatement_Else(ifStatement)) {
                ExecutionFlowUtils.visitStatement(context, flowDescription, ifStatement.getElseStatement(), visitor);
            }
        } else if (ExecutionFlowUtils.shouldVisitStatement(statement)) {
            ASTVisitor complexVisitor = ExecutionFlowUtils.getInterceptingVisitor(context, flowDescription, visitor);
            statement.accept(complexVisitor);
        }
    }

    private static ASTVisitor getInterceptingVisitor(VisitingContext context, ExecutionFlowDescription flowDescription, ExecutionFlowFrameVisitor visitor) {
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = new ByteBuddy().subclass(VisitorStub.class).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)new ExecutionFlowHandler()));
        ClassLoader proxyClassLoader = ExecutionFlowUtils.class.getClassLoader();
        TypeCache.SimpleKey proxyKey = new TypeCache.SimpleKey(VisitorStub.class, new Class[0]);
        try {
            return (ASTVisitor)PROXY_CACHE.findOrInsert(proxyClassLoader, (Object)proxyKey, () -> ExecutionFlowUtils.lambda$0((DynamicType.Builder)builder, proxyClassLoader)).getConstructor(VisitingContext.class, ExecutionFlowDescription.class, ExecutionFlowFrameVisitor.class).newInstance(new Object[]{context, flowDescription, visitor});
        }
        catch (ReflectiveOperationException e) {
            throw new DesignerException(313, (Throwable)e, new Object[0]);
        }
    }

    private static boolean shouldVisitAnonymousClassDeclaration(ASTNode anonymous) {
        for (ExecutionFlowProvider provider : ExecutionFlowUtils.getExecutionFlowProviders()) {
            if (!provider.shouldVisit(anonymous)) continue;
            return true;
        }
        return false;
    }

    private static List<ExecutionFlowProvider> getExecutionFlowProviders() {
        return ExternalFactoriesHelper.getElementsInstances(ExecutionFlowProvider.class, (String)"org.eclipse.wb.core.java.executionFlowProviders", (String)"provider");
    }

    private static void visitBinaryFlowMethods(boolean beforeStatement, VisitingContext context, ExecutionFlowDescription flowDescription, Statement statement, ExecutionFlowFrameVisitor visitor) {
        if (context.useBinaryFlow) {
            List<MethodDeclaration> binaryFlowMethods;
            List<MethodDeclaration> list = binaryFlowMethods = beforeStatement ? flowDescription.getBinaryFlowMethodsBefore(statement) : flowDescription.getBinaryFlowMethodsAfter(statement);
            if (binaryFlowMethods != null) {
                for (MethodDeclaration method : binaryFlowMethods) {
                    ExecutionFlowUtils.visit(context, flowDescription, visitor, method);
                }
            }
        }
    }

    private static boolean shouldVisitStatement(Statement statement) {
        return statement instanceof ExpressionStatement || statement instanceof VariableDeclarationStatement || statement instanceof ConstructorInvocation || statement instanceof SuperConstructorInvocation || statement instanceof ReturnStatement;
    }

    private static boolean shouldVisit_IfStatement_Then(IfStatement ifStatement) {
        MethodDeclaration method;
        Expression expression = ifStatement.getExpression();
        if (expression instanceof BooleanLiteral) {
            BooleanLiteral literal = (BooleanLiteral)expression;
            return literal.booleanValue();
        }
        if (AstNodeUtils.isMethodInvocation((ASTNode)expression, "isDesignTime()")) {
            return true;
        }
        Block block = (Block)ifStatement.getParent();
        return block.getParent() instanceof MethodDeclaration && LazyVariableSupportUtils.getInformation(method = (MethodDeclaration)block.getParent()) != null;
    }

    private static boolean shouldVisit_IfStatement_Else(IfStatement ifStatement) {
        PrefixExpression prefixExpression;
        Expression expression = ifStatement.getExpression();
        if (expression instanceof BooleanLiteral) {
            BooleanLiteral literal = (BooleanLiteral)expression;
            return !literal.booleanValue();
        }
        return expression instanceof PrefixExpression && (prefixExpression = (PrefixExpression)expression).getOperator() == PrefixExpression.Operator.NOT && AstNodeUtils.isMethodInvocation((ASTNode)prefixExpression.getOperand(), "isDesignTime()");
    }

    public static MethodDeclaration getExecutionFlowConstructor(TypeDeclaration typeDeclaration) {
        ArrayList<MethodDeclaration> constructors = new ArrayList<MethodDeclaration>();
        MethodDeclaration[] methodDeclarationArray = typeDeclaration.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            if (methodDeclaration.isConstructor()) {
                constructors.add(methodDeclaration);
            }
            ++n2;
        }
        if (constructors.isEmpty()) {
            return null;
        }
        if (constructors.size() == 1) {
            return (MethodDeclaration)constructors.get(0);
        }
        for (MethodDeclaration constructor : constructors) {
            if (!AstNodeUtils.hasJavaDocTag((BodyDeclaration)constructor, WBP_PARSER_CONSTRUCTOR)) continue;
            return constructor;
        }
        for (ExecutionFlowProvider provider : ExecutionFlowUtils.getExecutionFlowProviders()) {
            MethodDeclaration constructor = provider.getDefaultConstructor(typeDeclaration);
            if (constructor == null) continue;
            return constructor;
        }
        throw new MultipleConstructorsError();
    }

    public static MethodDeclaration getExecutionFlow_entryPoint(TypeDeclaration typeDeclaration) {
        MethodDeclaration[] methodDeclarationArray = typeDeclaration.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration method = methodDeclarationArray[n2];
            if (AstNodeUtils.hasJavaDocTag((BodyDeclaration)method, "@wbp.parser.entryPoint")) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public static boolean hasVariableStamp(ASTNode variable) {
        return variable.getProperty(KEY_LAST_VARIABLE_STAMP) != null;
    }

    public static VariableDeclaration getDeclaration(ExecutionFlowDescription flowDescription, ASTNode variable) {
        if (EnvironmentUtils.isTestingTime()) {
            Assert.isTrue((boolean)AstNodeUtils.isVariable(variable));
        }
        return (VariableDeclaration)ExecutionFlowUtils.getVariableCachedValue(flowDescription, variable, KEY_DECLARATION);
    }

    public static List<Expression> getReferences(ExecutionFlowDescription flowDescription, ASTNode variable) {
        if (EnvironmentUtils.isTestingTime()) {
            Assert.isTrue((boolean)AstNodeUtils.isVariable(variable));
        }
        return ExecutionFlowUtils.getVariableCachedList_notNull(flowDescription, variable, KEY_REFERENCES);
    }

    public static List<Expression> getAssignments(ExecutionFlowDescription flowDescription, ASTNode variable) {
        if (EnvironmentUtils.isTestingTime()) {
            Assert.isTrue((boolean)AstNodeUtils.isVariable(variable));
        }
        return ExecutionFlowUtils.getVariableCachedList_notNull(flowDescription, variable, KEY_ASSIGNMENTS);
    }

    public static ASTNode getLastAssignment(ExecutionFlowDescription flowDescription, ASTNode variable) {
        if (EnvironmentUtils.isTestingTime()) {
            Assert.isTrue((boolean)AstNodeUtils.isVariable(variable));
        }
        return (ASTNode)ExecutionFlowUtils.getVariableCachedValue(flowDescription, variable, KEY_LAST_ASSIGNMENT);
    }

    private static <T> List<T> getVariableCachedList_notNull(ExecutionFlowDescription flowDescription, ASTNode variable, String key) {
        List result = (List)ExecutionFlowUtils.getVariableCachedValue(flowDescription, variable, key);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public static Expression getFinalExpression(ExecutionFlowDescription flowDescription, Expression expression) {
        while (expression instanceof SimpleName) {
            ASTNode assignment = ExecutionFlowUtils.getLastAssignment(flowDescription, (ASTNode)expression);
            if (assignment instanceof Assignment) {
                expression = ((Assignment)assignment).getRightHandSide();
                continue;
            }
            if (!(assignment instanceof VariableDeclarationFragment)) break;
            expression = ((VariableDeclarationFragment)assignment).getInitializer();
        }
        return expression;
    }

    private static Object getVariableCachedValue(ExecutionFlowDescription flowDescription, ASTNode variable, String key) {
        if (ExecutionFlowUtils.clearCachedValuesForDanglingNode(variable)) {
            return null;
        }
        Long lastStamp = (Long)variable.getProperty(KEY_LAST_VARIABLE_STAMP);
        if (lastStamp != null && lastStamp.longValue() == variable.getAST().modificationCount()) {
            return variable.getProperty(key);
        }
        ExecutionFlowUtils.prepareAssignmentInformation(flowDescription);
        return variable.getProperty(key);
    }

    private static boolean clearCachedValuesForDanglingNode(ASTNode variable) {
        if (AstNodeUtils.isDanglingNode(variable)) {
            Field[] fieldArray = ExecutionFlowUtils.class.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                String fieldName = field.getName();
                if (fieldName.startsWith("KEY_")) {
                    variable.setProperty(fieldName, null);
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private static void prepareAssignmentInformation(ExecutionFlowDescription flowDescription) {
        final Long assignmentStamp = flowDescription.getAST().modificationCount();
        ExecutionFlowUtils.visit(new VisitingContext(true), flowDescription, new AbstractVariablesExecutionFlowVisitor(true){

            public void endVisit(Assignment node) {
                Expression leftSide = node.getLeftHandSide();
                if (AstNodeUtils.isVariable((ASTNode)leftSide)) {
                    Expression variable = leftSide;
                    this.executionFlowContext.addAssignment(variable, node);
                    this.executionFlowContext.storeAssignments(variable);
                }
            }

            public void postVisit(ASTNode node) {
                if (node instanceof Expression) {
                    Expression variable = (Expression)node;
                    if (AstNodeUtils.isVariable(node)) {
                        variable.setProperty(ExecutionFlowUtils.KEY_LAST_VARIABLE_STAMP, (Object)assignmentStamp);
                        this.executionFlowContext.storeAssignments(variable);
                    }
                }
            }
        });
        flowDescription.getCompilationUnit().accept((ASTVisitor)new AbstractVariablesExecutionFlowVisitor(false){

            @Override
            public boolean visit(AnonymousClassDeclaration node) {
                return true;
            }

            @Override
            public void preVisit(ASTNode node) {
                super.preVisit(node);
                if (this.isFrameNode(node)) {
                    this.enterFrame(node);
                    if (node instanceof TypeDeclaration) {
                        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
                        ExecutionFlowUtils.visitFields(this, typeDeclaration, true);
                        ExecutionFlowUtils.visitFields(this, typeDeclaration, false);
                    }
                }
            }

            public void postVisit(ASTNode node) {
                super.postVisit(node);
                if (this.isFrameNode(node)) {
                    this.leaveFrame(node);
                }
                if (node instanceof Expression) {
                    if (AstNodeUtils.isVariable(node)) {
                        this.executionFlowContext.storeReferences((Expression)node);
                    }
                    if (node instanceof QualifiedName) {
                        QualifiedName qualifiedName = (QualifiedName)node;
                        CompilationUnit unit = (CompilationUnit)qualifiedName.getRoot();
                        TypeDeclaration topType = (TypeDeclaration)unit.types().get(0);
                        if (qualifiedName.getQualifier().resolveTypeBinding() == topType.resolveBinding()) {
                            this.executionFlowContext.storeReferences((Expression)qualifiedName.getName());
                        }
                    }
                }
            }

            private boolean isFrameNode(ASTNode node) {
                return node instanceof TypeDeclaration || node instanceof MethodDeclaration || node instanceof Block;
            }
        });
    }

    public static List<ASTNode> getInvocations(ExecutionFlowDescription flowDescription, MethodDeclaration methodDeclaration) {
        final ArrayList<ASTNode> invocations = new ArrayList<ASTNode>();
        IMethodBinding requiredBinding = AstNodeUtils.getMethodBinding(methodDeclaration);
        if (requiredBinding == null) {
            return invocations;
        }
        final String requiredType = AstNodeUtils.getFullyQualifiedName(requiredBinding.getDeclaringClass(), false);
        final String requiredSignature = AstNodeUtils.getMethodSignature(methodDeclaration);
        ExecutionFlowUtils.visit(new VisitingContext(true), flowDescription, new ExecutionFlowFrameVisitor(){

            public void endVisit(MethodInvocation node) {
                IMethodBinding binding = AstNodeUtils.getMethodBinding(node);
                this.addInvocation((ASTNode)node, binding);
            }

            public void endVisit(ClassInstanceCreation node) {
                IMethodBinding binding = AstNodeUtils.getCreationBinding(node);
                this.addInvocation((ASTNode)node, binding);
            }

            public void endVisit(ConstructorInvocation node) {
                IMethodBinding binding = AstNodeUtils.getBinding(node);
                this.addInvocation((ASTNode)node, binding);
            }

            private void addInvocation(ASTNode invocation, IMethodBinding binding) {
                if (binding != null) {
                    String signature = AstNodeUtils.getMethodSignature(binding);
                    String type = AstNodeUtils.getFullyQualifiedName(binding.getDeclaringClass(), false);
                    if (signature.equals(requiredSignature) && type.equals(requiredType)) {
                        invocations.add(invocation);
                    }
                }
            }
        });
        return invocations;
    }

    private static /* synthetic */ Class lambda$0(DynamicType.Builder builder, ClassLoader classLoader) throws Exception {
        return builder.make().load(classLoader).getLoaded();
    }

    private static abstract class AbstractVariablesExecutionFlowVisitor
    extends ExecutionFlowFrameVisitor {
        protected final ExecutionFlowContext executionFlowContext;

        public AbstractVariablesExecutionFlowVisitor(boolean forExecutionFlow) {
            this.executionFlowContext = new ExecutionFlowContext(forExecutionFlow);
        }

        @Override
        public boolean enterFrame(ASTNode node) {
            this.executionFlowContext.enterFrame(node);
            if (node instanceof MethodDeclaration) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)node;
                for (SingleVariableDeclaration parameter : DomGenerics.parameters(methodDeclaration)) {
                    this.executionFlowContext.define((VariableDeclaration)parameter);
                }
            }
            return true;
        }

        @Override
        public void leaveFrame(ASTNode node) {
            this.executionFlowContext.leaveFrame();
        }

        public void preVisit(ASTNode node) {
            if (node instanceof VariableDeclaration) {
                VariableDeclaration variableDeclaration = (VariableDeclaration)node;
                this.executionFlowContext.define(variableDeclaration);
            }
        }
    }

    private static final class ExecutionFlowContext {
        private final boolean m_forExecutionFlow;
        private final LinkedList<ExecutionFlowFrame> m_stack = new LinkedList();
        private ExecutionFlowFrame m_currentFrame;

        public ExecutionFlowContext(boolean forExecutionFlow) {
            this.m_forExecutionFlow = forExecutionFlow;
        }

        private MethodDeclaration getNewFrameMethod(ASTNode node) {
            if (node instanceof MethodDeclaration) {
                return (MethodDeclaration)node;
            }
            if (this.m_currentFrame != null) {
                return this.m_currentFrame.getMethod();
            }
            return null;
        }

        public void enterFrame(ASTNode node) {
            this.m_currentFrame = new ExecutionFlowFrame(this.getNewFrameMethod(node), this.m_forExecutionFlow, node instanceof TypeDeclaration);
            this.m_stack.addFirst(this.m_currentFrame);
        }

        public void leaveFrame() {
            Assert.isTrue((this.m_stack.removeFirst() == this.m_currentFrame ? 1 : 0) != 0);
            this.m_currentFrame = this.m_stack.peek();
        }

        public void define(VariableDeclaration variableDeclaration) {
            ExecutionFlowFrame frame = this.getFrameForDeclaration(variableDeclaration);
            frame.define(variableDeclaration);
        }

        private ExecutionFlowFrame getFrameForDeclaration(VariableDeclaration variableDeclaration) {
            if (variableDeclaration.getLocationInParent() == FieldDeclaration.FRAGMENTS_PROPERTY) {
                int i = this.m_stack.size() - 1;
                while (i >= 0) {
                    ExecutionFlowFrame frame = this.m_stack.get(i);
                    if (frame.m_forTypeDeclaration) {
                        return frame;
                    }
                    --i;
                }
            }
            return this.m_currentFrame;
        }

        public void addAssignment(Expression variable, Assignment assignment) {
            ExecutionFlowFrame definingFrame = this.getDefiningFrame(variable);
            if (definingFrame != null) {
                definingFrame.addAssignment(variable, (ASTNode)assignment);
            }
        }

        public void storeAssignments(Expression node) {
            ExecutionFlowFrame definingFrame = this.getDefiningFrame(node);
            if (definingFrame != null) {
                VariableDeclaration declaration = definingFrame.getDeclaration(node);
                node.setProperty(ExecutionFlowUtils.KEY_DECLARATION, (Object)declaration);
                node.setProperty(ExecutionFlowUtils.KEY_LAST_ASSIGNMENT, (Object)definingFrame.getLastAssignment(node));
                node.setProperty(ExecutionFlowUtils.KEY_ASSIGNMENTS, definingFrame.getAssignments(node));
            }
        }

        public void storeReferences(Expression variable) {
            ExecutionFlowFrame definingFrame = this.getDefiningFrame(variable);
            if (definingFrame != null) {
                variable.setProperty(ExecutionFlowUtils.KEY_REFERENCES, definingFrame.getReferences(variable));
                if (variable.getProperty(ExecutionFlowUtils.KEY_LAST_ASSIGNMENT) == null) {
                    Assert.isTrue((!this.m_forExecutionFlow ? 1 : 0) != 0);
                    VariableDeclaration declaration = definingFrame.getDeclaration(variable);
                    variable.setProperty(ExecutionFlowUtils.KEY_LAST_ASSIGNMENT, declaration.getProperty(ExecutionFlowUtils.KEY_LAST_DECLARATION_ASSIGNMENT));
                }
            }
        }

        private ExecutionFlowFrame getDefiningFrame(Expression variable) {
            for (ExecutionFlowFrame frame : this.m_stack) {
                if (!frame.defines(variable)) continue;
                return frame;
            }
            return null;
        }
    }

    private static final class ExecutionFlowFrame {
        private final MethodDeclaration m_method;
        private final boolean m_forExecutionFlow;
        private final boolean m_forTypeDeclaration;
        private final Map<String, VariableDeclaration> m_variableToDeclaration = new HashMap<String, VariableDeclaration>();
        private final Map<String, ASTNode> m_assignments = new HashMap<String, ASTNode>();
        private final Map<String, Expression> m_assignmentsVariables = new HashMap<String, Expression>();
        private final Map<String, ASTNode> m_variableToLastAssignment = new HashMap<String, ASTNode>();
        private final Map<String, List<ASTNode>> m_variableToAssignments = new HashMap<String, List<ASTNode>>();
        private final Map<String, List<Expression>> m_variableToReferences = new HashMap<String, List<Expression>>();

        public ExecutionFlowFrame(MethodDeclaration method, boolean forExecutionFlow, boolean forTypeDeclaration) {
            this.m_method = method;
            this.m_forExecutionFlow = forExecutionFlow;
            this.m_forTypeDeclaration = forTypeDeclaration;
        }

        public boolean defines(Expression variable) {
            if (variable instanceof FieldAccess && !this.m_forTypeDeclaration) {
                return false;
            }
            return this.getDeclaration(variable) != null;
        }

        public void define(VariableDeclaration declaration) {
            SimpleName variable = declaration.getName();
            String variableName = variable.getIdentifier();
            this.m_variableToDeclaration.put(variableName, declaration);
            this.addAssignment((Expression)variable, (ASTNode)declaration);
        }

        public void addAssignment(Expression variable, ASTNode node) {
            String variableName = AstNodeUtils.getVariableName((ASTNode)variable);
            this.m_variableToLastAssignment.put(variableName, node);
            Expression initializer = null;
            if (node instanceof VariableDeclaration) {
                VariableDeclaration declaration = (VariableDeclaration)node;
                initializer = declaration.getInitializer();
            } else if (node instanceof Assignment) {
                Assignment assignment = (Assignment)node;
                initializer = assignment.getRightHandSide();
            }
            if (initializer != null) {
                this.getAssignments(variable).add(node);
                this.getAssignments().put(variableName, node);
                this.getAssignmentsVariables().put(variableName, variable);
            }
            if (this.m_forExecutionFlow) {
                VariableDeclaration declaration = this.m_variableToDeclaration.get(variableName);
                declaration.setProperty(ExecutionFlowUtils.KEY_LAST_DECLARATION_ASSIGNMENT, (Object)node);
            }
        }

        public MethodDeclaration getMethod() {
            return this.m_method;
        }

        public VariableDeclaration getDeclaration(Expression variable) {
            String variableName = AstNodeUtils.getVariableName((ASTNode)variable);
            return this.m_variableToDeclaration.get(variableName);
        }

        public ASTNode getLastAssignment(Expression variable) {
            String variableName = AstNodeUtils.getVariableName((ASTNode)variable);
            return this.m_variableToLastAssignment.get(variableName);
        }

        public List<ASTNode> getAssignments(Expression variable) {
            String variableName = AstNodeUtils.getVariableName((ASTNode)variable);
            List<ASTNode> assignments = this.m_variableToAssignments.get(variableName);
            if (assignments == null) {
                assignments = new ArrayList<ASTNode>();
                this.m_variableToAssignments.put(variableName, assignments);
            }
            return assignments;
        }

        public Map<String, ASTNode> getAssignments() {
            return this.m_assignments;
        }

        public Map<String, Expression> getAssignmentsVariables() {
            return this.m_assignmentsVariables;
        }

        public List<Expression> getReferences(Expression variable) {
            String variableName = AstNodeUtils.getVariableName((ASTNode)variable);
            List<Expression> references = this.m_variableToReferences.get(variableName);
            if (references == null) {
                references = new ArrayList<Expression>();
                this.m_variableToReferences.put(variableName, references);
            }
            if (!references.contains(variable)) {
                references.add(variable);
            }
            return references;
        }
    }

    public static class ExecutionFlowFrameVisitor
    extends ASTVisitor {
        public Statement m_currentStatement;

        public boolean visit(AnonymousClassDeclaration node) {
            return ExecutionFlowUtils.shouldVisitAnonymousClassDeclaration((ASTNode)node);
        }

        public boolean visit(LambdaExpression node) {
            return ExecutionFlowUtils.shouldVisitAnonymousClassDeclaration((ASTNode)node);
        }

        public boolean enterFrame(ASTNode node) {
            return true;
        }

        public void leaveFrame(ASTNode node) {
        }
    }

    private static class ExecutionFlowHandler
    implements InvocationHandler {
        private ExecutionFlowHandler() {
        }

        @Override
        public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
            VisitorStub stub = (VisitorStub)((Object)obj);
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == 1) {
                Class<?> parameterType = parameterTypes[0];
                if (method.getName().equals("endVisit")) {
                    if (parameterType == ClassInstanceCreation.class) {
                        this.endVisit(stub, (ClassInstanceCreation)args[0]);
                    } else if (parameterType == MethodInvocation.class) {
                        this.endVisit(stub, (MethodInvocation)args[0]);
                    } else if (parameterType == ConstructorInvocation.class) {
                        this.endVisit(stub, (ConstructorInvocation)args[0]);
                    }
                }
            }
            try {
                return method.invoke((Object)stub.visitor, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private void endVisit(VisitorStub stub, ClassInstanceCreation node) {
            String identifier = stub.flowDescription.geTypeDeclaration().getName().getIdentifier();
            if (!node.toString().contains(identifier)) {
                return;
            }
            MethodDeclaration methodDeclaration = AstNodeUtils.getLocalConstructorDeclaration(node);
            if (methodDeclaration != null) {
                ExecutionFlowUtils.visit(stub.context, stub.flowDescription, stub.visitor, List.of(methodDeclaration));
            }
        }

        private void endVisit(VisitorStub stub, MethodInvocation node) {
            MethodDeclaration methodDeclaration = AstNodeUtils.getLocalMethodDeclaration(node);
            if (methodDeclaration != null) {
                methodDeclaration.setProperty(ExecutionFlowUtils.KEY_FRAME_INVOCATION, (Object)node);
                if (node.getExpression() != null && !(node.getExpression() instanceof ThisExpression)) {
                    ExecutionFlowUtils.visit(stub.context, stub.flowDescription, stub.visitor, List.of(methodDeclaration));
                } else {
                    ExecutionFlowUtils.visit(stub.context, stub.flowDescription, stub.visitor, methodDeclaration);
                }
            }
        }

        private void endVisit(VisitorStub stub, ConstructorInvocation node) {
            MethodDeclaration constructor = AstNodeUtils.getConstructor(node);
            constructor.setProperty(ExecutionFlowUtils.KEY_FRAME_INVOCATION, (Object)node);
            ExecutionFlowUtils.visit(stub.context, stub.flowDescription, stub.visitor, List.of(constructor));
        }
    }

    public static class VisitingContext {
        boolean classInitialized;
        boolean instanceInitialized;
        boolean useBinaryFlow;
        final Set<MethodDeclaration> visitedMethods = new HashSet<MethodDeclaration>();

        public VisitingContext(boolean useBinaryFlow) {
            this.useBinaryFlow = useBinaryFlow;
        }
    }

    public static class VisitorStub
    extends ASTVisitor {
        private final VisitingContext context;
        private final ExecutionFlowDescription flowDescription;
        private final ExecutionFlowFrameVisitor visitor;

        public VisitorStub(VisitingContext context, ExecutionFlowDescription flowDescription, ExecutionFlowFrameVisitor visitor) {
            this.context = context;
            this.flowDescription = flowDescription;
            this.visitor = visitor;
        }
    }
}

