/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.tool.api;

import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ecore.extender.business.internal.ExtenderPlugin;
import org.eclipse.sirius.ecore.extender.business.internal.Messages;
import org.eclipse.sirius.ecore.extender.tool.internal.ReferencesResolver;
import org.eclipse.sirius.ext.emf.EReferencePredicate;

public final class ModelUtils {
    private static final String ENCODING_PROPERTY = "file.encoding";

    private ModelUtils() {
    }

    public static void attachResource(URI resourceURI, EObject root) {
        Resource newResource = ModelUtils.createResource(resourceURI);
        newResource.getContents().add((Object)root);
    }

    public static void attachResource(URI resourceURI, ResourceSet resourceSet, EObject root) {
        Resource newResource = ModelUtils.createResource(resourceURI, resourceSet);
        newResource.getContents().add((Object)root);
    }

    public static Resource createResource(URI modelURI) {
        return ModelUtils.createResource(modelURI, (ResourceSet)new ResourceSetImpl());
    }

    public static Resource createResource(URI modelURI, ResourceSet resourceSet) {
        Resource.Factory.Registry registry;
        Object resourceFactory;
        String fileExtension = modelURI.fileExtension();
        if (fileExtension == null || fileExtension.length() == 0) {
            fileExtension = "*";
        }
        if ((resourceFactory = (registry = Resource.Factory.Registry.INSTANCE).getExtensionToFactoryMap().get(fileExtension)) != null) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, resourceFactory);
        } else {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, new XMIResourceFactoryImpl());
        }
        return resourceSet.createResource(modelURI);
    }

    public static List<EObject> getModelsFrom(File directory, ResourceSet resourceSet) throws IOException {
        return ModelUtils.getModelsFrom(directory, null, resourceSet);
    }

    public static List<EObject> getModelsFrom(File directory, String extension, ResourceSet resourceSet) throws IOException {
        ArrayList<EObject> models = new ArrayList<EObject>();
        String fileExtension = extension != null ? extension : "";
        if (directory.exists() && directory.isDirectory() && directory.listFiles() != null) {
            File[] files = directory.listFiles();
            StringBuffer pattern = new StringBuffer("[^.].*?\\Q");
            pattern.append(fileExtension);
            pattern.append("\\E");
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                File aFile = file;
                if (!aFile.isDirectory() && aFile.getName().matches(pattern.toString())) {
                    models.add(ModelUtils.load(aFile, resourceSet));
                }
                ++n2;
            }
        }
        return models;
    }

    public static EObject load(File file, ResourceSet resourceSet) throws IOException {
        return ModelUtils.load(URI.createFileURI((String)file.getPath()), resourceSet);
    }

    public static EObject load(InputStream stream, String fileName, ResourceSet resourceSet) throws IOException {
        if (stream == null) {
            throw new NullPointerException(Messages.ModelUtils_missingInputStream);
        }
        EObject result = null;
        Resource modelResource = ModelUtils.createResource(URI.createURI((String)fileName), resourceSet);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", System.getProperty(ENCODING_PROPERTY));
        modelResource.load(stream, options);
        if (modelResource.getContents().size() > 0) {
            result = (EObject)modelResource.getContents().get(0);
        }
        return result;
    }

    public static EObject load(URI modelURI, ResourceSet resourceSet) throws IOException {
        Resource modelResource = resourceSet.getResource(modelURI, false);
        if (modelResource == null) {
            modelResource = ModelUtils.createResource(modelURI, resourceSet);
        }
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put("ENCODING", System.getProperty(ENCODING_PROPERTY));
        return ModelUtils.load(modelResource, options);
    }

    public static Resource getResource(ResourceSet resourceSet, URI resourceURI) {
        Resource resource;
        block2: {
            resource = null;
            try {
                resource = resourceSet.getResource(resourceURI, true);
            }
            catch (WrappedException e) {
                if (!ExtenderPlugin.getPlugin().isDebugging()) break block2;
                ExtenderPlugin.getPlugin().getLog().log((IStatus)new Status(2, "org.eclipse.sirius.ecore.extender", e.getMessage(), (Throwable)e));
            }
        }
        return resource;
    }

    public static EObject loadFast(URI modelURI, ResourceSet resourceSet) throws IOException {
        Resource modelResource = ModelUtils.createResource(modelURI, resourceSet);
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put("ENCODING", System.getProperty(ENCODING_PROPERTY));
        options.put("DEFER_ATTACHMENT", Boolean.TRUE);
        options.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        options.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
        options.put("USE_PARSER_POOL", new XMLParserPoolImpl(true));
        return ModelUtils.load(modelResource, options);
    }

    private static EObject load(Resource modelResource, Map<Object, Object> options) throws IOException {
        EObject result = null;
        modelResource.load(options);
        if (modelResource.getContents().size() > 0) {
            result = (EObject)modelResource.getContents().get(0);
        }
        return result;
    }

    public static void save(EObject root, String path) throws IOException {
        if (root == null) {
            throw new NullPointerException(Messages.ModelUtils_nullSerializationError);
        }
        Resource newModelResource = ModelUtils.createResource(URI.createFileURI((String)path));
        newModelResource.getContents().add((Object)root);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", System.getProperty(ENCODING_PROPERTY));
        newModelResource.save(options);
    }

    public static String serialize(EObject root) throws IOException {
        if (root == null) {
            throw new NullPointerException(Messages.ModelUtils_nullSerializationError);
        }
        XMIResourceImpl newResource = new XMIResourceImpl();
        StringWriter writer = new StringWriter();
        newResource.getContents().add((Object)root);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", System.getProperty(ENCODING_PROPERTY));
        newResource.save((Writer)writer, options);
        String result = writer.toString();
        writer.flush();
        return result;
    }

    public static void resolveAll(ResourceSet set) {
        IPermissionAuthority authority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(set);
        List<Resource> cachedIdsResources = ReferencesResolver.prepareResolveAll(set, authority);
        EcoreUtil.resolveAll((ResourceSet)set);
        ReferencesResolver.unprepareResolveAll(authority, cachedIdsResources);
    }

    public static void resolveAll(ResourceSet set, EReferencePredicate filter) {
        IPermissionAuthority authority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(set);
        List<Resource> cachedIdsResources = ReferencesResolver.prepareResolveAll(set, authority);
        new ReferencesResolver(set, filter).resolve((IProgressMonitor)new NullProgressMonitor());
        ReferencesResolver.unprepareResolveAll(authority, cachedIdsResources);
    }

    public static void resolveAll(EObject root) {
        IPermissionAuthority authority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(root);
        if (authority != null) {
            authority.setListening(false);
        }
        List<Resource> cachedIDsResources = Collections.emptyList();
        Resource rootResource = root.eResource();
        if (rootResource != null && rootResource.getResourceSet() != null) {
            cachedIDsResources = ModelUtils.cachedEObjectIDs(rootResource.getResourceSet());
        }
        EcoreUtil.resolveAll((EObject)root);
        ModelUtils.uncachedEObejctIDs(cachedIDsResources);
        if (authority != null) {
            authority.setListening(true);
        }
    }

    public static void resolveAll(Resource res) {
        ModelUtils.resolveAll(res, false);
    }

    public static void resolveAll(Resource res, boolean recursive) {
        IPermissionAuthority authority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(res);
        if (authority != null) {
            authority.setListening(false);
        }
        List<Resource> cachedIDsResources = Collections.emptyList();
        if (res != null && res.getResourceSet() != null) {
            cachedIDsResources = ModelUtils.cachedEObjectIDs(res.getResourceSet());
        }
        ArrayList resourcesBeforeResolveAll = new ArrayList(res.getResourceSet().getResources());
        EcoreUtil.resolveAll((Resource)res);
        if (recursive) {
            ArrayList resourcesAfterResolveAll = new ArrayList(res.getResourceSet().getResources());
            Iterators.removeAll(resourcesAfterResolveAll.iterator(), resourcesBeforeResolveAll);
            for (Resource resource : resourcesAfterResolveAll) {
                ModelUtils.resolveAll(resource, recursive);
            }
        }
        ModelUtils.uncachedEObejctIDs(cachedIDsResources);
        if (authority != null) {
            authority.setListening(true);
        }
    }

    public static boolean validateProxies(EObject eObject) {
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
        return diagnostic.getSeverity() != 4 || !ModelUtils.hasAnyFailingProxy(diagnostic);
    }

    private static boolean hasAnyFailingProxy(Diagnostic diagnostic) {
        boolean result = false;
        if (diagnostic.getCode() == 4) {
            result = true;
        }
        int i = 0;
        while (!result && i < diagnostic.getChildren().size()) {
            result = ModelUtils.hasAnyFailingProxy((Diagnostic)diagnostic.getChildren().get(i));
            ++i;
        }
        return result;
    }

    public static List<Resource> cachedEObjectIDs(ResourceSet resourceSet) {
        LinkedList<Resource> result = new LinkedList<Resource>();
        for (Resource currentResource : resourceSet.getResources()) {
            if (!(currentResource instanceof ResourceImpl) || ((ResourceImpl)currentResource).getIntrinsicIDToEObjectMap() != null) continue;
            ((ResourceImpl)currentResource).setIntrinsicIDToEObjectMap(new HashMap());
            result.add(currentResource);
        }
        return result;
    }

    public static void uncachedEObejctIDs(List<Resource> resources) {
        for (Resource currentResource : resources) {
            if (!(currentResource instanceof ResourceImpl)) continue;
            ((ResourceImpl)currentResource).setIntrinsicIDToEObjectMap(null);
        }
    }
}

