/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.formatter.core.PHPCodeFormatter;
import org.eclipse.php.formatter.core.profiles.CodeFormatterPreferences;
import org.eclipse.php.internal.core.format.FormatPreferencesSupport;
import org.eclipse.php.internal.core.format.IFormatterCommonPreferences;
import org.eclipse.php.internal.formatter.core.Logger;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class PHPCodeFormatterCommonPreferences
implements IFormatterCommonPreferences {
    public int getIndentationWrappedLineSize(IDocument document) {
        CodeFormatterPreferences preferences = this.getPreferences(document);
        if (preferences == null) {
            return FormatPreferencesSupport.getInstance().getIndentationWrappedLineSize(document);
        }
        return preferences.line_wrap_wrapped_lines_indentation;
    }

    public int getIndentationArrayInitSize(IDocument document) {
        CodeFormatterPreferences preferences = this.getPreferences(document);
        if (preferences == null) {
            return FormatPreferencesSupport.getInstance().getIndentationArrayInitSize(document);
        }
        return preferences.line_wrap_array_init_indentation;
    }

    public int getIndentationSize(IDocument document) {
        CodeFormatterPreferences preferences = this.getPreferences(document);
        if (preferences == null) {
            return FormatPreferencesSupport.getInstance().getIndentationSize(document);
        }
        return preferences.indentationSize;
    }

    public char getIndentationChar(IDocument document) {
        CodeFormatterPreferences preferences = this.getPreferences(document);
        if (preferences == null) {
            return FormatPreferencesSupport.getInstance().getIndentationChar(document);
        }
        return preferences.indentationChar;
    }

    public int getTabSize(IDocument document) {
        CodeFormatterPreferences preferences = this.getPreferences(document);
        if (preferences == null) {
            return FormatPreferencesSupport.getInstance().getIndentationSize(document);
        }
        return preferences.tabSize;
    }

    public boolean useTab(IDocument document) {
        return this.getIndentationChar(document) == '\t';
    }

    private CodeFormatterPreferences getPreferences(IDocument document) {
        block16: {
            IStructuredModel structuredModel = null;
            try {
                if (!(document instanceof IStructuredDocument)) break block16;
                structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                if (structuredModel == null) {
                    try {
                        CodeFormatterPreferences preferences;
                        CodeFormatterPreferences codeFormatterPreferences = preferences = PHPCodeFormatter.getPreferences(null);
                        return codeFormatterPreferences;
                    }
                    catch (Exception preferences) {
                        if (structuredModel != null) {
                            structuredModel.releaseFromRead();
                        }
                        return null;
                    }
                }
                IProject project = this.getProject(structuredModel);
                if (project == null) {
                    Logger.logException(new IllegalStateException("Cann't resolve file name"));
                }
                try {
                    CodeFormatterPreferences preferences;
                    CodeFormatterPreferences codeFormatterPreferences = preferences = PHPCodeFormatter.getPreferences(project);
                    return codeFormatterPreferences;
                }
                catch (Exception exception) {
                    try {
                    }
                    catch (Exception e) {
                        Logger.logException(e);
                    }
                }
            }
            finally {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
        }
        return null;
    }

    private final IProject getProject(IStructuredModel doModelForPHP) {
        IFile file;
        String id = doModelForPHP.getId();
        if (id != null && (file = this.getFile(id)) != null) {
            return file.getProject();
        }
        return null;
    }

    private IFile getFile(String id) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(id));
    }
}

