/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.AttributeGroup;
import org.eclipse.php.core.ast.nodes.BodyDeclaration;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FormalParameterList;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.core.compiler.PHPFlags;

public class PropertyHook
extends BodyDeclaration {
    private boolean isReference;
    private Identifier name;
    private FormalParameterList parameters;
    private ASTNode body;
    public static final SimplePropertyDescriptor IS_REFERENCE_PROPERTY = new SimplePropertyDescriptor(PropertyHook.class, "isReference", Boolean.class, false);
    public static final SimplePropertyDescriptor MODIFIER_PROPERTY = new SimplePropertyDescriptor(PropertyHook.class, "modifier", Integer.class, false);
    public static final ChildPropertyDescriptor PARAMETERS_PROPERTY = new ChildPropertyDescriptor(PropertyHook.class, "parameters", FormalParameterList.class, false, true);
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(PropertyHook.class, "name", Identifier.class, true, false);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(PropertyHook.class, "body", ASTNode.class, false, true);
    public static final ChildListPropertyDescriptor ATTRIBUTES_PROPERTY = new ChildListPropertyDescriptor(PropertyHook.class, "attributes", AttributeGroup.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(5);
        propertyList.add(ATTRIBUTES_PROPERTY);
        propertyList.add(MODIFIER_PROPERTY);
        propertyList.add(NAME_PROPERTY);
        propertyList.add(IS_REFERENCE_PROPERTY);
        propertyList.add(PARAMETERS_PROPERTY);
        propertyList.add(BODY_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public PropertyHook(int start, int end, AST ast, int modifier, boolean isReference, Identifier name, FormalParameterList parameters, ASTNode body, List<AttributeGroup> attributes) {
        super(start, end, ast, modifier);
        if (attributes != null) {
            this.attributes().addAll(attributes);
        }
        this.setIsReference(isReference);
        this.setName(name);
        this.setParameters(parameters);
        this.setBody(body);
    }

    public PropertyHook(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (AttributeGroup attr : this.attributes()) {
            attr.accept(visitor);
        }
        if (this.name != null) {
            this.name.accept(visitor);
        }
        if (this.parameters != null) {
            this.parameters.accept(visitor);
        }
        if (this.body != null) {
            this.body.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (AttributeGroup attr : this.attributes()) {
            attr.traverseTopDown(visitor);
        }
        if (this.name != null) {
            this.name.traverseTopDown(visitor);
        }
        if (this.parameters != null) {
            this.parameters.traverseTopDown(visitor);
        }
        if (this.body != null) {
            this.body.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        if (this.body != null) {
            this.body.traverseTopDown(visitor);
        }
        if (this.parameters != null) {
            this.parameters.traverseBottomUp(visitor);
        }
        if (this.name != null) {
            this.name.traverseBottomUp(visitor);
        }
        for (AttributeGroup attr : this.attributes()) {
            attr.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<PropertyHook");
        this.appendInterval(buffer);
        buffer.append(" isReference='").append(this.isReference());
        buffer.append(" modifier='").append(PHPFlags.toString(this.getModifier())).append("'>\n");
        this.name.toString(buffer, tab + "\t");
        buffer.append("\n");
        this.toStringAttributes(buffer, tab + "\t");
        buffer.append("\n");
        if (this.parameters != null) {
            this.parameters.toString(buffer, tab + "\t");
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("<HookBody>\n");
        if (this.body != null) {
            this.body.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</HookBody>\n");
        buffer.append(tab).append("</PropertyHook>\n");
    }

    @Override
    public int getType() {
        return 95;
    }

    public ASTNode body() {
        return this.body;
    }

    public void setBody(ASTNode body) {
        ASTNode oldChild = this.body;
        this.preReplaceChild(oldChild, body, BODY_PROPERTY);
        this.body = body;
        this.postReplaceChild(oldChild, body, BODY_PROPERTY);
    }

    public FormalParameterList parameters() {
        return this.parameters;
    }

    public void setParameters(FormalParameterList parameters) {
        FormalParameterList oldChild = this.parameters;
        this.preReplaceChild(oldChild, parameters, PARAMETERS_PROPERTY);
        this.parameters = parameters;
        this.postReplaceChild(oldChild, parameters, PARAMETERS_PROPERTY);
    }

    public boolean isReference() {
        return this.isReference;
    }

    public final void setIsReference(boolean value) {
        this.preValueChange(IS_REFERENCE_PROPERTY);
        this.isReference = value;
        this.postValueChange(IS_REFERENCE_PROPERTY);
    }

    public Identifier name() {
        return this.name;
    }

    public void setName(Identifier name) {
        Identifier oldChild = this.name;
        this.preReplaceChild(oldChild, name, NAME_PROPERTY);
        this.name = name;
        this.postReplaceChild(oldChild, name, NAME_PROPERTY);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == IS_REFERENCE_PROPERTY) {
            if (get) {
                return this.isReference();
            }
            this.setIsReference(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.body();
            }
            this.setBody((Expression)child);
            return null;
        }
        if (property == PARAMETERS_PROPERTY) {
            if (get) {
                return this.parameters();
            }
            this.setParameters((FormalParameterList)child);
            return null;
        }
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.name();
            }
            this.setName((Identifier)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        ASTNode body = ASTNode.copySubtree(target, this.body());
        FormalParameterList formalParams = ASTNode.copySubtree(target, this.parameters());
        boolean isRef = this.isReference();
        int modifier = this.getModifier();
        Identifier name = ASTNode.copySubtree(target, this.name());
        List<AttributeGroup> attributes = ASTNode.copySubtrees(target, this.attributes());
        return new PropertyHook(this.getStart(), this.getEnd(), target, modifier, isRef, name, formalParams, body, attributes);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    protected ChildListPropertyDescriptor getAttributesProperty() {
        return ATTRIBUTES_PROPERTY;
    }

    @Override
    public SimplePropertyDescriptor getModifierProperty() {
        return MODIFIER_PROPERTY;
    }
}

