/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.buildpath;

import java.io.File;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.collection.ComposerPackages;
import org.eclipse.php.composer.api.objects.Autoload;
import org.eclipse.php.composer.api.objects.Namespace;
import org.eclipse.php.composer.core.resources.IComposerProject;

public class BuildPathParser {
    private static String EMPTY = "";
    private IComposerProject project;

    public BuildPathParser(IComposerProject project) {
        this.project = project;
    }

    public TreeSet<BuildPathInfo> getPathsInfo() {
        ComposerPackage composer = this.project.getComposerPackage();
        String vendor = this.project.getVendorDir();
        TreeSet<BuildPathInfo> paths = new TreeSet<BuildPathInfo>();
        this.parsePackage(composer, paths, EMPTY, 2);
        paths.add(new BuildPathInfo(vendor + "/composer", 4));
        ComposerPackages packages = this.project.getInstalledPackages();
        if (packages != null) {
            for (ComposerPackage p : packages) {
                this.parsePackage(p, paths, vendor + "/" + p.getName(), 4);
            }
        }
        return paths;
    }

    private void parsePackage(ComposerPackage pkg, TreeSet<BuildPathInfo> paths, String prefix, int type) {
        if (prefix != null && !((String)prefix).equals("") && !((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        this.parseAutoload(pkg.getAutoload(), paths, (String)prefix, type);
        this.parseAutoload(pkg.getAutoloadDev(), paths, (String)prefix, type);
    }

    private void parseAutoload(Autoload a, TreeSet<BuildPathInfo> paths, String prefix, int type) {
        String cleanedPath;
        for (Namespace namespace : a.getPsr0()) {
            for (Object path : namespace.getPaths()) {
                this.addPath(prefix + String.valueOf(path), paths, type);
            }
        }
        for (Namespace namespace : a.getPsr4()) {
            for (Object path : namespace.getPaths()) {
                this.addPath(prefix + String.valueOf(path), paths, type);
            }
        }
        for (Object path : a.getClassMap()) {
            cleanedPath = this.getDirectory(prefix + (String)path);
            this.addPath(cleanedPath, paths, type);
        }
        for (Object path : a.getFiles()) {
            cleanedPath = this.getDirectory(prefix + (String)path);
            this.addPath(cleanedPath, paths, type);
        }
    }

    private String getDirectory(String path) {
        String cleanedPath = null;
        IPath root = this.project.getProject().getLocation();
        File f = new File(root.toFile(), path);
        if (f.exists()) {
            cleanedPath = f.isDirectory() ? f.getPath().replace(root.toOSString(), "") : f.getParentFile().getPath().replace(root.toOSString(), "");
        }
        return cleanedPath;
    }

    private void addPath(String path, TreeSet<BuildPathInfo> paths, int type) {
        if (path != null && !path.trim().isEmpty()) {
            if ((path = path.replaceAll("\\\\", "/")).startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/.")) {
                path = path.substring(0, path.length() - 2);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.equals(".")) {
                path = "";
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            paths.add(new BuildPathInfo(path, type));
        }
    }

    public static class BuildPathInfo
    implements Comparable<BuildPathInfo> {
        public static final int SOURCE = 2;
        public static final int VENDOR = 4;
        public final String path;
        public final int type;

        public BuildPathInfo(String path, int type) {
            this.path = path;
            this.type = type;
        }

        @Override
        public int compareTo(BuildPathInfo o) {
            int c = this.path.compareTo(o.path);
            return c != 0 ? c : this.type - o.type;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BuildPathInfo)) {
                return false;
            }
            return this.compareTo((BuildPathInfo)obj) == 0;
        }
    }
}

