/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

public abstract class ConcurrentArray<E> {
    protected volatile E[] elements;
    private final E[] EMPTY = this.newArray(0);

    public boolean isEmpty() {
        return this.elements == null;
    }

    public E[] get() {
        E[] result = this.elements;
        return result == null ? this.EMPTY : result;
    }

    public synchronized boolean contains(E element) {
        if (this.elements == null) {
            return false;
        }
        int length = this.elements.length;
        int i = 0;
        while (i < length) {
            E e = this.elements[i];
            if (this.equals(element, e)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean validateAndAdd(E element, boolean unique) {
        if (!this.validate(element)) {
            return false;
        }
        return this.add(element, unique);
    }

    private synchronized boolean add(E element, boolean unique) {
        if (this.elements == null) {
            E[] array = this.newArray(1);
            array[0] = element;
            this.elements = array;
            this.elementAdded(element);
            this.firstElementAdded();
            return true;
        }
        int length = this.elements.length;
        if (unique) {
            int i = 0;
            while (i < length) {
                E e = this.elements[i];
                if (this.equals(element, e)) {
                    return false;
                }
                ++i;
            }
        }
        E[] array = this.newArray(length + 1);
        System.arraycopy(this.elements, 0, array, 0, length);
        array[length] = element;
        this.elements = array;
        this.elementAdded(element);
        return true;
    }

    public synchronized boolean addUnique(E element) {
        return this.validateAndAdd(element, true);
    }

    public synchronized void add(E element) {
        this.validateAndAdd(element, false);
    }

    public synchronized boolean remove(E element) {
        if (this.elements != null) {
            int length = this.elements.length;
            if (length == 1) {
                if (this.equals(this.elements[0], element)) {
                    this.elements = null;
                    this.elementRemoved(element);
                    this.lastElementRemoved();
                    return true;
                }
            } else {
                int i = 0;
                while (i < length) {
                    E e = this.elements[i];
                    if (this.equals(e, element)) {
                        E[] array = this.newArray(length - 1);
                        if (i > 0) {
                            System.arraycopy(this.elements, 0, array, 0, i);
                        }
                        if (i + 1 <= length - 1) {
                            System.arraycopy(this.elements, i + 1, array, i, length - 1 - i);
                        }
                        this.elements = array;
                        this.elementRemoved(element);
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    protected boolean validate(E element) {
        return true;
    }

    protected boolean equals(E e1, E e2) {
        return e1 == e2;
    }

    protected void elementAdded(E element) {
    }

    protected void elementRemoved(E element) {
    }

    protected void firstElementAdded() {
    }

    protected void lastElementRemoved() {
    }

    protected abstract E[] newArray(int var1);

    public static abstract class DuplicateCounter<E>
    extends ConcurrentArray<E> {
        private int maxDuplicates;

        public final int getMaxDuplicates() {
            return this.maxDuplicates;
        }

        @Override
        protected boolean validate(E element) {
            if (this.elements != null) {
                int duplicates = 0;
                int i = 0;
                while (i < this.elements.length) {
                    if (this.equals(element, this.elements[i])) {
                        ++duplicates;
                    }
                    ++i;
                }
                if (duplicates > this.maxDuplicates) {
                    this.maxDuplicates = duplicates;
                }
            }
            return true;
        }

        @Override
        protected boolean equals(E e1, E e2) {
            return e1 == e2;
        }
    }

    public static abstract class Unique<E>
    extends ConcurrentArray<E> {
        @Override
        protected boolean validate(E element) {
            if (this.elements != null) {
                int i = 0;
                while (i < this.elements.length) {
                    if (this.equals(element, this.elements[i])) {
                        this.violatingUniqueness(element);
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        @Override
        protected boolean equals(E e1, E e2) {
            return e1 == e2;
        }

        protected void violatingUniqueness(E element) {
        }
    }
}

