/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.common.cdo.server;

import java.util.Map;
import javax.sql.DataSource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.net4j.CDONet4jServerUtil;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.modisco.infra.common.cdo.internal.Activator;
import org.eclipse.modisco.infra.common.cdo.server.Server;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.OMLogHandler;
import org.eclipse.net4j.util.om.log.PrintLogHandler;
import org.eclipse.net4j.util.om.trace.OMTraceHandler;
import org.eclipse.net4j.util.om.trace.PrintTraceHandler;

public abstract class AbstractCDOServer
implements Server {
    protected static final int CURRENT_LRU_CAPACITY = 100000;
    protected static final int REVISED_LRU_CAPACITY = 10000;
    private static final String DB_NAME_PREFIX = "db";
    private static final int PORT = 2036;
    public static final String REPOSITORY_NAME = "repo1";
    public static final String HOSTNAME = "localhost";
    private IAcceptor acceptor;
    private IRepository repository;
    private Thread thread;
    private boolean started = false;

    public Object start(IApplicationContext context) throws Exception {
        this.start(DB_NAME_PREFIX + System.currentTimeMillis(), 2036);
        while (true) {
            Thread.sleep(Long.MAX_VALUE);
        }
    }

    protected synchronized void setStarted(boolean started) {
        this.started = started;
        this.notify();
    }

    @Override
    public synchronized boolean isStarted() {
        return this.started;
    }

    @Override
    public void start(final String dbName, final int port) throws Exception {
        this.thread = new Thread(){

            @Override
            public void run() {
                try {
                    Net4jUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
                    TCPUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
                    CDONet4jServerUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
                    OMPlatform.INSTANCE.addLogHandler((OMLogHandler)PrintLogHandler.CONSOLE);
                    OMPlatform.INSTANCE.addTraceHandler((OMTraceHandler)PrintTraceHandler.CONSOLE);
                    OMPlatform.INSTANCE.setDebugging(true);
                    DataSource dataSource = AbstractCDOServer.this.getDataSource(dbName);
                    IMappingStrategy mappingStrategy = AbstractCDOServer.this.getMappingStrategy();
                    IDBAdapter dbAdapter = AbstractCDOServer.this.getDBAdapter();
                    IDBConnectionProvider dbConnectionProvider = DBUtil.createConnectionProvider((DataSource)dataSource);
                    IDBStore store = CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)dbConnectionProvider);
                    Map<String, String> props = AbstractCDOServer.this.getProps();
                    IRepository repositoryLocal = CDOServerUtil.createRepository((String)AbstractCDOServer.REPOSITORY_NAME, (IStore)store, props);
                    AbstractCDOServer.this.setRepository(repositoryLocal);
                    CDOServerUtil.addRepository((IManagedContainer)IPluginContainer.INSTANCE, (IRepository)repositoryLocal);
                    IAcceptor acceptorLocal = this.startAcceptor(port);
                    AbstractCDOServer.this.setAcceptor(acceptorLocal);
                    AbstractCDOServer.this.setStarted(true);
                }
                catch (Exception e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    AbstractCDOServer.this.setStarted(true);
                }
            }

            private IAcceptor startAcceptor(int portParameter) {
                return (IAcceptor)IPluginContainer.INSTANCE.getElement("org.eclipse.net4j.acceptors", "tcp", "0.0.0.0:" + portParameter);
            }
        };
        this.thread.start();
    }

    @Override
    public void stop() {
        Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.modisco.infra.common.cdo", "Stopping the CDO server."));
        this.thread.interrupt();
        LifecycleUtil.deactivate((Object)this.getAcceptor());
        LifecycleUtil.deactivate((Object)this.getRepository());
        Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.modisco.infra.common.cdo", "The CDO server is stopped."));
    }

    protected abstract Map<String, String> getProps();

    protected abstract IMappingStrategy getMappingStrategy();

    protected abstract DataSource getDataSource(String var1) throws Exception;

    protected abstract IDBAdapter getDBAdapter();

    public void setRepository(IRepository repository) {
        this.repository = repository;
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public void setAcceptor(IAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public IAcceptor getAcceptor() {
        return this.acceptor;
    }
}

