/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.emf.ui.internal;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.modisco.facet.util.emf.core.ModelUtils;
import org.eclipse.modisco.facet.util.emf.ui.internal.utils.ImageProvider;
import org.eclipse.modisco.facet.util.emf.ui.internal.utils.ImageUtils;
import org.eclipse.swt.graphics.Image;

public class EmfLabelProvider
extends LabelProvider {
    public String getText(Object element) {
        String result = super.getText(element);
        if (element instanceof ResourceSet) {
            ResourceSet resourceSet = (ResourceSet)element;
            result = EmfLabelProvider.getResourceSetLabel(resourceSet);
        } else if (element instanceof Resource) {
            Resource resource = (Resource)element;
            result = EmfLabelProvider.getResourceLabel(resource);
        } else if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            result = ModelUtils.getName((EObject)eObject);
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            result = EmfLabelProvider.adaptAndGetResourceLabel(adaptable);
            if (result == null) {
                result = EmfLabelProvider.adaptAndGetResourceSetLabel(adaptable);
            }
        } else {
            result = element.toString();
        }
        return result;
    }

    private static String adaptAndGetResourceLabel(IAdaptable adaptable) {
        String result = null;
        Resource resource = (Resource)adaptable.getAdapter(Resource.class);
        if (resource != null) {
            result = EmfLabelProvider.getResourceLabel(resource);
        }
        return result;
    }

    private static String adaptAndGetResourceSetLabel(IAdaptable adaptable) {
        String result = null;
        ResourceSet resourceSet = (ResourceSet)adaptable.getAdapter(ResourceSet.class);
        if (resourceSet != null) {
            result = EmfLabelProvider.getResourceSetLabel(resourceSet);
        }
        return result;
    }

    private static String getResourceSetLabel(ResourceSet resourceSet) {
        String result = ResourceSet.class.getSimpleName() + " " + resourceSet.hashCode();
        return result;
    }

    private static String getResourceLabel(Resource resource) {
        EObject firstRoot = null;
        if (resource.getContents().size() > 0) {
            firstRoot = (EObject)resource.getContents().get(0);
        }
        StringBuffer strBuffer = new StringBuffer();
        URI uri = resource.getURI();
        String lastSegment = uri.lastSegment();
        strBuffer.append(lastSegment);
        if (firstRoot != null) {
            strBuffer.append(" - ");
            EPackage ePackage = firstRoot.eClass().getEPackage();
            String nsURI = ePackage.getName();
            strBuffer.append(nsURI);
        }
        if (resource.isModified()) {
            strBuffer.append(" *");
        }
        String result = strBuffer.toString();
        return result;
    }

    public Image getImage(Object element) {
        Image result = super.getImage(element);
        if (element instanceof Resource) {
            Resource resource = (Resource)element;
            result = EmfLabelProvider.getResourceImage(resource);
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            result = EmfLabelProvider.adaptAndGetResourceImage(adaptable);
        } else if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            result = ImageUtils.getImage(eObject);
        }
        return result;
    }

    private static Image adaptAndGetResourceImage(IAdaptable adaptable) {
        Image result = null;
        Resource resource = (Resource)adaptable.getAdapter(Resource.class);
        if (resource != null) {
            result = EmfLabelProvider.getResourceImage(resource);
        }
        return result;
    }

    private static Image getResourceImage(Resource resource) {
        EObject firstRoot;
        Image result = null;
        if (resource.getContents().size() > 0 && (result = ImageUtils.getImage(firstRoot = (EObject)resource.getContents().get(0))) == null) {
            result = ImageProvider.DEFAULT.getImage("icons/ModelIcon.gif");
        }
        return result;
    }
}

