/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.IMapExtractor;
import org.eclipse.mat.internal.collectionextract.FieldArrayCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.FieldSizeArrayCollectionExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.ObjectReference;

public class FieldSizeArrayMapExtractor
extends FieldSizeArrayCollectionExtractor
implements IMapExtractor {
    FieldArrayCollectionExtractor keysExtractor;

    public FieldSizeArrayMapExtractor(String sizeField, String valuesArrayField, String keysCollectionField) {
        super(sizeField, valuesArrayField);
        this.keysExtractor = new FieldArrayCollectionExtractor(keysCollectionField);
    }

    @Override
    public boolean hasCollisionRatio() {
        return true;
    }

    @Override
    public Double getCollisionRatio(IObject collection) throws SnapshotException {
        return 0.0;
    }

    @Override
    public Iterator<Map.Entry<IObject, IObject>> extractMapEntries(IObject collection) throws SnapshotException {
        final IObjectArray valueArray = this.extractEntries(collection);
        final IObjectArray keyArray = this.keysExtractor.extractEntries(collection);
        final ISnapshot snapshot = collection.getSnapshot();
        return new Iterator<Map.Entry<IObject, IObject>>(){
            int ix = 0;

            @Override
            public boolean hasNext() {
                while (this.ix < valueArray.getLength()) {
                    if (valueArray.getReferenceArray(this.ix, 1)[0] != 0L) {
                        return true;
                    }
                    ++this.ix;
                }
                return false;
            }

            @Override
            public Map.Entry<IObject, IObject> next() {
                if (this.hasNext()) {
                    IObject value;
                    IObject key;
                    int ix2 = this.ix++;
                    long keyaddr = keyArray.getReferenceArray(ix2, 1)[0];
                    try {
                        ObjectReference ref = new ObjectReference(snapshot, keyaddr);
                        key = ref.getObject();
                    }
                    catch (SnapshotException e) {
                        NoSuchElementException ise = new NoSuchElementException();
                        ise.initCause(e);
                        throw ise;
                    }
                    long valueaddr = valueArray.getReferenceArray(ix2, 1)[0];
                    try {
                        ObjectReference ref = new ObjectReference(snapshot, valueaddr);
                        value = ref.getObject();
                    }
                    catch (SnapshotException e) {
                        NoSuchElementException ise = new NoSuchElementException();
                        ise.initCause(e);
                        throw ise;
                    }
                    return new Map.Entry<IObject, IObject>(){

                        @Override
                        public IObject getKey() {
                            return key;
                        }

                        @Override
                        public IObject getValue() {
                            return value;
                        }

                        @Override
                        public IObject setValue(IObject value2) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
                throw new NoSuchElementException();
            }
        };
    }
}

