/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.AbstractPositionRequest;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.hover.IHoverRequest;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLHoverSettings;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

class HoverRequest
extends AbstractPositionRequest
implements IHoverRequest {
    private final SharedSettings settings;
    private Range hoverRange;
    private boolean open;

    public HoverRequest(DOMDocument xmlDocument, Position position, SharedSettings settings, XMLExtensionsRegistry extensionsRegistry) throws BadLocationException {
        super(xmlDocument, position, extensionsRegistry);
        this.settings = settings;
    }

    @Override
    protected DOMNode findNodeAt(DOMDocument xmlDocument, int offset) {
        DOMAttr attr;
        DOMNode node = xmlDocument.findNodeAt(offset);
        if (node != null && node.isElement() && (attr = DOMNode.findAttrAt(node, offset)) != null) {
            return attr;
        }
        return node;
    }

    @Override
    public Range getHoverRange() {
        return this.hoverRange;
    }

    public void setHoverRange(Range hoverRange) {
        this.hoverRange = hoverRange;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    @Override
    public boolean canSupportMarkupKind(String kind) {
        XMLHoverSettings hoverSettings = this.settings.getHoverSettings();
        return this.settings != null && hoverSettings.getCapabilities() != null && hoverSettings.getCapabilities().getContentFormat() != null && hoverSettings.getCapabilities().getContentFormat().contains(kind);
    }

    @Override
    public SharedSettings getSharedSettings() {
        return this.settings;
    }
}

