/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.project.facet;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryProviderFrameworkUi;
import org.eclipse.jst.jsf.core.internal.project.facet.IJSFFacetInstallDataModelProperties;
import org.eclipse.jst.jsf.core.internal.project.facet.JsfFacetConfigurationUtil;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.jst.jsf.ui.internal.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.IWizardContext;

public class JSFFacetInstallPage
extends DataModelWizardPage
implements IJSFFacetInstallDataModelProperties,
IFacetWizardPage {
    private final boolean jsfFacetConfigurationEnabled = JsfFacetConfigurationUtil.isJsfFacetConfigurationEnabled();
    private Button btnConfigureServlet;
    private Composite configureServletComposite;
    private Label lblJSFConfig;
    private Text txtJSFConfig;
    private Label lblJSFServletName;
    private Text txtJSFServletName;
    private Label lblJSFServletClassName;
    private Text txtJSFServletClassName;
    private Label lblJSFServletURLPatterns;
    private List lstJSFServletURLPatterns;
    private Button btnAddPattern;
    private Button btnRemovePattern;
    private IDialogSettings dialogSettings;
    private IDataModel webAppDataModel;
    private static final String SETTINGS_ROOT = "org.eclipse.jst.jsf.ui.jsfFacetInstall";
    private static final String SETTINGS_CONFIG = "configPath";
    private static final String SETTINGS_SERVLET = "servletName";
    private static final String SETTINGS_SERVLET_CLASSNAME = "servletClassname";
    private static final String SETTINGS_URL_MAPPINGS = "urlMappings";
    private static final String SETTINGS_URL_PATTERN = "pattern";
    private static final String SETTINGS_CONFIGURE_SERVLET = "configureServlet";
    private Composite composite = null;

    public JSFFacetInstallPage() {
        super(DataModelFactory.createDataModel((IDataModelProvider)new AbstractDataModelProvider(){}), "jsf.facet.install.page");
        this.setTitle(Messages.JSFFacetInstallPage_title);
        this.setDescription(Messages.JSFFacetInstallPage_description);
        this.dialogSettings = JSFUiPlugin.getDefault().getDialogSettings();
    }

    protected Composite createTopLevelComposite(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.composite = new Composite(parent, 0);
        GridLayout jsfCompositeLayout = new GridLayout(3, false);
        jsfCompositeLayout.marginTop = 0;
        jsfCompositeLayout.marginBottom = 0;
        jsfCompositeLayout.marginRight = 0;
        jsfCompositeLayout.marginLeft = 0;
        this.composite.setLayout((Layout)jsfCompositeLayout);
        LibraryInstallDelegate librariesInstallDelegate = (LibraryInstallDelegate)this.getDataModel().getProperty("IJSFFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE");
        Control librariesComposite = LibraryProviderFrameworkUi.createInstallLibraryPanel((Composite)this.composite, (LibraryInstallDelegate)librariesInstallDelegate, (String)Messages.JSFFacetInstallPage_JSFImplementationLibrariesFrame);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        librariesComposite.setLayoutData((Object)gd);
        Label spacer = new Label(this.composite, 0);
        spacer.setText("");
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        spacer.setLayoutData((Object)gd);
        if (this.jsfFacetConfigurationEnabled) {
            this.btnConfigureServlet = new Button(this.composite, 32);
            this.btnConfigureServlet.setText(Messages.JSFFacetInstallPage_ConfigureServletLabel);
            GridData gd0 = new GridData(768);
            gd0.horizontalSpan = 3;
            this.btnConfigureServlet.setLayoutData((Object)gd0);
            this.btnConfigureServlet.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    JSFFacetInstallPage.this.setCompositeEnabled(JSFFacetInstallPage.this.configureServletComposite, JSFFacetInstallPage.this.btnConfigureServlet.getSelection());
                }
            });
            this.configureServletComposite = new Composite(this.composite, 0);
            GridLayout csLayout = new GridLayout(3, false);
            csLayout.marginTop = 0;
            csLayout.marginBottom = 0;
            csLayout.marginRight = 0;
            csLayout.marginLeft = 5;
            this.configureServletComposite.setLayout((Layout)csLayout);
            GridData csGridData = new GridData(768);
            csGridData.horizontalSpan = 3;
            this.configureServletComposite.setLayoutData((Object)csGridData);
            this.lblJSFConfig = new Label(this.configureServletComposite, 0);
            this.lblJSFConfig.setText(Messages.JSFFacetInstallPage_JSFConfigLabel);
            this.lblJSFConfig.setLayoutData((Object)new GridData(1));
            this.txtJSFConfig = new Text(this.configureServletComposite, 2048);
            GridData gd1 = new GridData(768);
            gd1.horizontalSpan = 2;
            this.txtJSFConfig.setLayoutData((Object)gd1);
            this.lblJSFServletName = new Label(this.configureServletComposite, 0);
            this.lblJSFServletName.setText(Messages.JSFFacetInstallPage_JSFServletNameLabel);
            this.lblJSFServletName.setLayoutData((Object)new GridData(1));
            this.txtJSFServletName = new Text(this.configureServletComposite, 2048);
            GridData gd2 = new GridData(768);
            gd2.horizontalSpan = 2;
            this.txtJSFServletName.setLayoutData((Object)gd2);
            this.lblJSFServletClassName = new Label(this.configureServletComposite, 0);
            this.lblJSFServletClassName.setText(Messages.JSFFacetInstallPage_JSFServletClassNameLabel);
            this.lblJSFServletClassName.setLayoutData((Object)new GridData(1));
            this.txtJSFServletClassName = new Text(this.configureServletComposite, 2048);
            GridData gd2c = new GridData(768);
            gd2c.horizontalSpan = 2;
            this.txtJSFServletClassName.setLayoutData((Object)gd2c);
            this.lblJSFServletURLPatterns = new Label(this.configureServletComposite, 0);
            this.lblJSFServletURLPatterns.setText(Messages.JSFFacetInstallPage_JSFURLMappingLabel);
            this.lblJSFServletURLPatterns.setLayoutData((Object)new GridData(3));
            this.lstJSFServletURLPatterns = new List(this.configureServletComposite, 2048);
            GridData gd3 = new GridData(768);
            gd3.heightHint = this.convertHeightInCharsToPixels(5);
            this.lstJSFServletURLPatterns.setLayoutData((Object)gd3);
            this.lstJSFServletURLPatterns.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    JSFFacetInstallPage.this.btnRemovePattern.setEnabled(JSFFacetInstallPage.this.lstJSFServletURLPatterns.getSelectionCount() > 0);
                }
            });
            Composite btnComposite = new Composite(this.configureServletComposite, 0);
            GridLayout gl = new GridLayout(1, false);
            gl.marginLeft = 0;
            btnComposite.setLayout((Layout)gl);
            btnComposite.setLayoutData((Object)new GridData(19));
            this.btnAddPattern = new Button(btnComposite, 0);
            this.btnAddPattern.setText(Messages.JSFFacetInstallPage_Add2);
            this.btnAddPattern.setLayoutData((Object)new GridData(770));
            this.btnAddPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InputDialog dialog = new InputDialog(JSFFacetInstallPage.this.getShell(), Messages.JSFFacetInstallPage_PatternDialogTitle, Messages.JSFFacetInstallPage_PatternDialogDesc, null, new IInputValidator(){

                        public String isValid(String newText) {
                            return JSFFacetInstallPage.this.isValidPattern(newText);
                        }
                    });
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        JSFFacetInstallPage.this.addItemToList(dialog.getValue(), true);
                    }
                }
            });
            this.btnRemovePattern = new Button(btnComposite, 0);
            this.btnRemovePattern.setText(Messages.JSFFacetInstallPage_Remove);
            this.btnRemovePattern.setLayoutData((Object)new GridData(770));
            this.btnRemovePattern.setEnabled(false);
            this.btnRemovePattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    JSFFacetInstallPage.this.removeItemFromList(JSFFacetInstallPage.this.lstJSFServletURLPatterns.getSelection());
                    JSFFacetInstallPage.this.btnRemovePattern.setEnabled(false);
                }
            });
            this.addModificationListeners();
        }
        return this.composite;
    }

    private void setCompositeEnabled(Composite composite, boolean enabled) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setEnabled(enabled);
            if (child instanceof Composite) {
                this.setCompositeEnabled((Composite)child, enabled);
            }
            ++n2;
        }
    }

    private void initializeValues() {
        IDialogSettings root = this.dialogSettings.getSection(SETTINGS_ROOT);
        this.initJSFCfgCtrlValues(root);
        String conf = null;
        if (root != null) {
            conf = root.get(SETTINGS_CONFIG);
        }
        if (conf == null || conf.equals("")) {
            conf = (String)this.model.getDefaultProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH");
        }
        this.txtJSFConfig.setText(conf);
        String servletName = null;
        if (root != null) {
            servletName = root.get(SETTINGS_SERVLET);
        }
        if (servletName == null || servletName.equals("")) {
            servletName = (String)this.model.getDefaultProperty("IJSFFacetInstallDataModelProperties.SERVLET_NAME");
        }
        this.txtJSFServletName.setText(servletName);
        String servletClassname = null;
        if (root != null) {
            servletClassname = root.get(SETTINGS_SERVLET_CLASSNAME);
        }
        if (servletClassname == null || servletClassname.equals("")) {
            servletClassname = (String)this.model.getDefaultProperty("IJSFFacetInstallDataModelProperties.SERVLET_CLASSNAME");
        }
        this.txtJSFServletClassName.setText(servletClassname);
        this.loadURLMappingPatterns(root);
        String configureServlet = Boolean.TRUE.toString();
        if (root != null && ((configureServlet = root.get(SETTINGS_CONFIGURE_SERVLET)) == null || configureServlet.equals(""))) {
            configureServlet = ((Boolean)this.model.getDefaultProperty("IJSFFacetInstallDataModelProperties.CONFIGURE_SERVLET")).toString();
        }
        boolean enabled = Boolean.parseBoolean(configureServlet);
        this.btnConfigureServlet.setSelection(enabled);
        this.setCompositeEnabled(this.configureServletComposite, enabled);
    }

    private void initJSFCfgCtrlValues(IDialogSettings root) {
    }

    private void saveSettings() {
        DialogSettings root = new DialogSettings(SETTINGS_ROOT);
        this.dialogSettings.addSection((IDialogSettings)root);
        root.put(SETTINGS_CONFIGURE_SERVLET, this.getConfigureServlet());
        root.put(SETTINGS_CONFIG, this.getJSFConfig());
        root.put(SETTINGS_SERVLET, this.getJSFServletName());
        root.put(SETTINGS_SERVLET_CLASSNAME, this.getJSFServletClassname());
        DialogSettings mappings = new DialogSettings(SETTINGS_URL_MAPPINGS);
        root.addSection((IDialogSettings)mappings);
        mappings.put(SETTINGS_URL_PATTERN, this.getJSFPatterns());
    }

    private String getJSFConfig() {
        return this.txtJSFConfig.getText().trim();
    }

    private String getJSFServletName() {
        return this.txtJSFServletName.getText().trim();
    }

    private String getJSFServletClassname() {
        return this.txtJSFServletClassName.getText().trim();
    }

    private String[] getJSFPatterns() {
        return this.lstJSFServletURLPatterns.getItems();
    }

    private boolean getConfigureServlet() {
        return this.btnConfigureServlet.getSelection();
    }

    public void setConfig(Object config) {
        this.model.removeListener((IDataModelListener)this);
        this.synchHelper.dispose();
        this.model = (IDataModel)config;
        this.model.addListener((IDataModelListener)this);
        this.synchHelper = this.initializeSynchHelper(this.model);
    }

    public void transferStateToConfig() {
        if (this.jsfFacetConfigurationEnabled) {
            this.saveSettings();
        }
    }

    private void addModificationListeners() {
        this.synchHelper.synchCheckbox(this.btnConfigureServlet, "IJSFFacetInstallDataModelProperties.CONFIGURE_SERVLET", null);
        this.synchHelper.synchText(this.txtJSFConfig, "IJSFFacetInstallDataModelProperties.CONFIG_PATH", null);
        this.synchHelper.synchText(this.txtJSFServletName, "IJSFFacetInstallDataModelProperties.SERVLET_NAME", null);
        this.synchHelper.synchText(this.txtJSFServletClassName, "IJSFFacetInstallDataModelProperties.SERVLET_CLASSNAME", null);
        this.synchHelper.synchList(this.lstJSFServletURLPatterns, "IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS", null);
    }

    private String isValidPattern(String value) {
        if (value == null || value.trim().equals("")) {
            return Messages.JSFFacetInstallPage_PatternEmptyMsg;
        }
        if (this.lstJSFServletURLPatterns.indexOf(value) >= 0) {
            return Messages.JSFFacetInstallPage_PatternSpecifiedMsg;
        }
        return null;
    }

    private void loadURLMappingPatterns(IDialogSettings root) {
        this.lstJSFServletURLPatterns.removeAll();
        IDialogSettings mappings = null;
        if (root != null) {
            mappings = root.getSection(SETTINGS_URL_MAPPINGS);
        }
        String[] patterns = null;
        if (mappings != null) {
            patterns = mappings.getArray(SETTINGS_URL_PATTERN);
        }
        if (patterns == null || patterns.length == 0) {
            patterns = (String[])this.model.getDefaultProperty("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS");
        }
        int i = 0;
        while (i < patterns.length) {
            this.addItemToList(patterns[i], false);
            ++i;
        }
    }

    private void addItemToList(String pattern, boolean selectMe) {
        this.lstJSFServletURLPatterns.add(pattern == null ? "" : pattern);
        if (pattern == null && selectMe) {
            this.lstJSFServletURLPatterns.setSelection(this.lstJSFServletURLPatterns.getItemCount() - 1);
        }
        this.updateModelForURLPattern();
    }

    private void removeItemFromList(String[] selection) {
        int i = 0;
        while (i < selection.length) {
            String sel = selection[i];
            this.lstJSFServletURLPatterns.remove(sel);
            ++i;
        }
        this.updateModelForURLPattern();
    }

    private void updateModelForURLPattern() {
        this.model.setProperty("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS", (Object)this.lstJSFServletURLPatterns.getItems());
    }

    protected String[] getValidationPropertyNames() {
        if (this.jsfFacetConfigurationEnabled) {
            return new String[]{"IJSFFacetInstallDataModelProperties.CONFIG_PATH", "IJSFFacetInstallDataModelProperties.SERVLET_NAME", "IJSFFacetInstallDataModelProperties.SERVLET_CLASSNAME", "IJSFFacetInstallDataModelProperties.COMPONENT_LIBRARIES", "IJSFFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE"};
        }
        return new String[]{"IJSFFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE"};
    }

    public void setWizardContext(IWizardContext context) {
        Iterator it = context.getSelectedProjectFacets().iterator();
        IProjectFacetVersion webFacetVersion = null;
        while (it.hasNext()) {
            IProjectFacetVersion pfv = (IProjectFacetVersion)it.next();
            if (!pfv.getProjectFacet().getId().equals("jst.web")) continue;
            webFacetVersion = pfv;
            break;
        }
        if (webFacetVersion != null) {
            try {
                this.webAppDataModel = (IDataModel)context.getConfig(webFacetVersion, IFacetedProject.Action.Type.INSTALL, context.getProjectName());
                if (this.webAppDataModel != null) {
                    this.webAppDataModel.addListener((IDataModelListener)this);
                }
            }
            catch (CoreException e) {
                JSFUiPlugin.log(4, Messages.JSFFacetInstallPage_ErrorNoWebAppDataModel, e);
            }
        }
    }

    public void propertyChanged(DataModelEvent event) {
        String propertyName;
        if (this.webAppDataModel != null && this.jsfFacetConfigurationEnabled && (propertyName = event.getPropertyName()).equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
            this.model.setStringProperty("IJSFFacetInstallDataModelProperties.WEBCONTENT_DIR", event.getProperty().toString());
        }
        super.propertyChanged(event);
    }

    public void dispose() {
        if (this.webAppDataModel != null) {
            this.webAppDataModel.removeListener((IDataModelListener)this);
        }
        super.dispose();
    }

    protected void restoreDefaultSettings() {
        if (this.jsfFacetConfigurationEnabled) {
            this.initializeValues();
        }
    }

    protected boolean showValidationErrorsOnEnter() {
        return true;
    }

    public boolean isPageComplete() {
        LibraryInstallDelegate librariesInstallDelegate = (LibraryInstallDelegate)this.getDataModel().getProperty("IJSFFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE");
        if (librariesInstallDelegate == null) {
            throw new IllegalArgumentException("LibraryInstallDelegate is expected to be non-null");
        }
        return super.isPageComplete() && librariesInstallDelegate.validate().getSeverity() != 4;
    }
}

