/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal;

import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.jsf.common.internal.types.TypeComparatorPreferences;
import org.eclipse.jst.jsf.core.internal.IJSFPreferenceModel;
import org.eclipse.jst.jsf.validation.internal.Severity;

public class JSFTypeComparatorPreferences
extends TypeComparatorPreferences
implements IJSFPreferenceModel {
    private int[] _severities;
    public static final String INCOMPATIBLE_METHOD_TYPES = JSFTypeComparatorPreferences.createQualifiedKeyName("INCOMPATIBLE_METHOD_TYPES");
    public static final String INCOMPATIBLE_TYPES = JSFTypeComparatorPreferences.createQualifiedKeyName("INCOMPATIBLE_TYPES");
    public static final String METHOD_EXPRESSION_EXPECTED = JSFTypeComparatorPreferences.createQualifiedKeyName("METHOD_EXPRESSION_EXPECTED");
    public static final String PROPERTY_NOT_READABLE = JSFTypeComparatorPreferences.createQualifiedKeyName("PROPERTY_NOT_READABLE");
    public static final String PROPERTY_NOT_WRITABLE = JSFTypeComparatorPreferences.createQualifiedKeyName("PROPERTY_NOT_WRITABLE");
    public static final String VALUE_EXPRESSION_EXPECTED = JSFTypeComparatorPreferences.createQualifiedKeyName("VALUE_EXPRESSION_EXPECTED");

    @Override
    public void load(IPreferenceStore prefStore) {
        this.loadSeverities(prefStore);
    }

    private void loadSeverities(IPreferenceStore prefStore) {
        int[] severities = this.getSeverities();
        int i = 0;
        while (i < 6) {
            String key = JSFTypeComparatorPreferences.getKeyById(i);
            if (!prefStore.contains(key)) {
                int diagSeverity = this.getDefaultSeverity(i);
                Severity severity = JSFTypeComparatorPreferences.mapDiagToSeverity(diagSeverity);
                prefStore.setDefault(key, severity.toString());
            }
            String storedSeverity = prefStore.getString(key);
            severities[i] = JSFTypeComparatorPreferences.mapSeverityToDiag(storedSeverity);
            ++i;
        }
    }

    @Override
    public void commit(IPreferenceStore prefStore) {
        this.commitSeverities(prefStore);
    }

    private void commitSeverities(IPreferenceStore prefStore) {
        int[] severities = this.getSeverities();
        int i = 0;
        while (i < severities.length) {
            String key = JSFTypeComparatorPreferences.getKeyById(i);
            prefStore.setValue(key, JSFTypeComparatorPreferences.mapDiagToSeverity(severities[i]).toString());
            ++i;
        }
    }

    @Override
    public void setDefaults() {
        this.setProblemSeverityDefaults();
    }

    private void setProblemSeverityDefaults() {
        int[] severities = this.getSeverities();
        int i = 0;
        while (i < 6) {
            severities[i] = this.getDefaultSeverity(i);
            ++i;
        }
    }

    @Override
    public Object getValueByKey(IScopeContext context, String key) {
        try {
            Severity severity = this.getSeverity(key);
            return severity.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    public Object getStoredValueByKey(IScopeContext context, String key) {
        try {
            return context.getNode("org.eclipse.jst.jsf.core").get(key, JSFTypeComparatorPreferences.mapDiagToSeverity(this.getDefaultSeverity(JSFTypeComparatorPreferences.getIdByKey(key))).toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    public Object setValueByKey(IScopeContext context, String key, Object value) {
        Severity oldValue = this.getSeverity(key);
        this.setSeverity(key, (Severity)((Object)value));
        return oldValue;
    }

    public Severity getSeverity(String key) {
        int severityDiag = this._severities[JSFTypeComparatorPreferences.getIdByKey(key)];
        Severity severity = JSFTypeComparatorPreferences.mapDiagToSeverity(severityDiag);
        return severity;
    }

    public void setSeverity(String key, Severity severity) {
        int newSeverityDiag = JSFTypeComparatorPreferences.mapSeverityToDiag(severity.toString());
        int diagId = JSFTypeComparatorPreferences.getIdByKey(key);
        this._severities[diagId] = newSeverityDiag;
    }

    public final int getDiagnosticSeverity(int diagnosticId) {
        return this.getSeverities()[diagnosticId];
    }

    private int[] getSeverities() {
        if (this._severities == null) {
            this._severities = new int[6];
        }
        return this._severities;
    }

    public static Severity mapDiagToSeverity(int diagSeverity) {
        switch (diagSeverity) {
            case 4: {
                return Severity.ERROR;
            }
            case 2: {
                return Severity.WARNING;
            }
        }
        return Severity.IGNORE;
    }

    public static int mapSeverityToDiag(String severity) {
        if ("error".equals(severity)) {
            return 4;
        }
        if ("warning".equals(severity)) {
            return 2;
        }
        if ("ignore".equals(severity)) {
            return 0;
        }
        throw new IllegalArgumentException("Invalid enum name: " + severity);
    }

    public static String getKeyById(int diagnosticId) {
        switch (diagnosticId) {
            case 3: {
                return INCOMPATIBLE_METHOD_TYPES;
            }
            case 1: {
                return INCOMPATIBLE_TYPES;
            }
            case 0: {
                return METHOD_EXPRESSION_EXPECTED;
            }
            case 4: {
                return PROPERTY_NOT_READABLE;
            }
            case 5: {
                return PROPERTY_NOT_WRITABLE;
            }
            case 2: {
                return VALUE_EXPRESSION_EXPECTED;
            }
        }
        throw new IllegalArgumentException("Diagnostic Id: " + diagnosticId + " is out of range");
    }

    public static int getIdByKey(String key) {
        if (INCOMPATIBLE_METHOD_TYPES.equals(key)) {
            return 3;
        }
        if (INCOMPATIBLE_TYPES.equals(key)) {
            return 1;
        }
        if (METHOD_EXPRESSION_EXPECTED.equals(key)) {
            return 0;
        }
        if (PROPERTY_NOT_READABLE.equals(key)) {
            return 4;
        }
        if (PROPERTY_NOT_WRITABLE.equals(key)) {
            return 5;
        }
        if (VALUE_EXPRESSION_EXPECTED.equals(key)) {
            return 2;
        }
        throw new IllegalArgumentException("Severity Key: " + key);
    }

    private static String createQualifiedKeyName(String baseName) {
        return "org.eclipse.jst.jsf.core." + baseName;
    }
}

