/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.jee.model.internal.Web25ModelProvider;
import org.eclipse.jst.jee.model.internal.WebAnnotationReader;
import org.eclipse.jst.jee.model.internal.common.AbstractMergedModelProvider;
import org.eclipse.jst.jee.model.internal.mergers.ModelElementMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelException;
import org.eclipse.jst.jee.model.internal.mergers.WebApp3Merger;
import org.eclipse.jst.jee.model.internal.mergers.WebAppMerger;
import org.eclipse.jst.jee.web.Activator;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class Web25MergedModelProvider
extends AbstractMergedModelProvider<WebApp> {
    protected Path WEB_APP_XML_PATH = new Path("WEB-INF/web.xml");

    public Web25MergedModelProvider(IProject project) {
        super(project);
    }

    protected IModelProvider loadAnnotationModel(WebApp ddModel) throws CoreException {
        return new WebAnnotationReader(ProjectFacetsManager.create((IProject)this.project), ddModel);
    }

    protected IModelProvider loadDeploymentDescriptorModel() throws CoreException {
        return new Web25ModelProvider(this.project);
    }

    private WebApp getAnnotationWebApp() {
        return this.annotationModelProvider != null ? (WebApp)this.annotationModelProvider.getModelObject() : null;
    }

    private WebApp getXmlWebApp() {
        return this.ddProvider != null ? (WebApp)this.ddProvider.getModelObject() : null;
    }

    public Object getModelObject(IPath modelPath) {
        if (modelPath == null) {
            return this.getModelObject();
        }
        if (this.WEB_APP_XML_PATH.equals((Object)modelPath)) {
            return this.getXmlWebApp();
        }
        if ("java".equals(modelPath.getFileExtension()) || "class".equals(modelPath.getFileExtension())) {
            return this.getAnnotationWebApp();
        }
        return this.getModelObject();
    }

    public void modify(Runnable runnable, IPath modelPath) {
        if (this.mergedModel == null) {
            this.getMergedModel();
        }
        if (this.isDisposed()) {
            return;
        }
        WebApp backup = (WebApp)this.mergedModel;
        try {
            this.mergedModel = (WebApp)this.ddProvider.getModelObject();
            this.ddProvider.modify(runnable, modelPath);
        }
        finally {
            this.mergedModel = backup;
        }
        if (this.mergedModel == null) {
            this.mergedModel = (WebApp)this.getMergedModel();
        } else {
            this.merge(this.getXmlWebApp(), this.getAnnotationWebApp());
        }
    }

    private void clearModel(WebApp app) {
        if (app == null) {
            return;
        }
        app.getContextParams().clear();
        app.getDescriptions().clear();
        app.getDisplayNames().clear();
        app.getDistributables().clear();
        app.getEjbLocalRefs().clear();
        app.getEjbRefs().clear();
        app.getEnvEntries().clear();
        app.getErrorPages().clear();
        app.getFilterMappings().clear();
        app.getFilters().clear();
        app.getIcons().clear();
        app.getJspConfigs().clear();
        app.getListeners().clear();
        app.getLocalEncodingMappingsLists().clear();
        app.getLoginConfigs().clear();
        app.getMessageDestinationRefs().clear();
        app.getMessageDestinations().clear();
        app.getMimeMappings().clear();
        app.getPersistenceContextRefs().clear();
        app.getPersistenceUnitRefs().clear();
        app.getPostConstructs().clear();
        app.getPreDestroys().clear();
        app.getResourceEnvRefs().clear();
        app.getResourceRefs().clear();
        app.getSecurityConstraints().clear();
        app.getSecurityRoles().clear();
        app.getServiceRefs().clear();
        app.getServletMappings().clear();
        app.getServlets().clear();
        app.getSessionConfigs().clear();
        app.getWelcomeFileLists().clear();
    }

    protected void annotationModelChanged(IModelProviderEvent event) {
        this.internalModelChanged(event);
    }

    protected void xmlModelChanged(IModelProviderEvent event) {
        this.internalModelChanged(event);
    }

    private synchronized void internalModelChanged(IModelProviderEvent event) {
        this.merge(this.getXmlWebApp(), this.getAnnotationWebApp());
        this.notifyListeners(event);
    }

    protected WebApp merge(WebApp ddModel, WebApp annotationsModel) {
        try {
            if (this.mergedModel != ddModel) {
                this.clearModel((WebApp)this.mergedModel);
                this.mergeWithModel(ddModel, ModelElementMerger.COPY);
                this.mergeWithModel(annotationsModel, ModelElementMerger.ADD);
            }
        }
        catch (ModelException e) {
            Activator.logError(e);
        }
        return (WebApp)this.mergedModel;
    }

    private void mergeWithModel(WebApp model, int type) throws ModelException {
        WebAppMerger merger;
        if (model == null) {
            return;
        }
        try {
            merger = this.createWebMerger(model, type);
        }
        catch (CoreException e) {
            throw new ModelException((Exception)((Object)e));
        }
        merger.process();
    }

    private WebAppMerger createWebMerger(WebApp model, int type) throws CoreException {
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.project);
        if (facetedProject.getProjectFacetVersion(WebFacetUtils.WEB_FACET) != null && (double)Float.parseFloat(facetedProject.getProjectFacetVersion(WebFacetUtils.WEB_FACET).getVersionString()) > 2.5) {
            return new WebApp3Merger((JavaEEObject)this.mergedModel, (JavaEEObject)model, type);
        }
        return new WebAppMerger((JavaEEObject)this.mergedModel, (JavaEEObject)model, type);
    }

    protected WebApp createNewModelInstance() {
        return WebFactory.eINSTANCE.createWebApp();
    }
}

