/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.archive.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.jee.archive.AbstractArchiveLoadAdapter;
import org.eclipse.jst.jee.archive.ArchiveModelLoadException;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.ArchiveOptions;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveFactory;
import org.eclipse.jst.jee.archive.IArchiveLoadAdapter;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.archive.internal.ArchiveResourceImpl;
import org.eclipse.jst.jee.archive.internal.ArchiveUtil;
import org.eclipse.jst.jee.archive.internal.FailedToCloseException;
import org.eclipse.jst.jee.archive.internal.TempZipFileArchiveLoadAdapterImpl;
import org.eclipse.osgi.util.NLS;

public class ArchiveImpl
extends ArchiveResourceImpl
implements IArchive {
    private ArchiveOptions archiveOptions;
    private IArchiveLoadAdapter loadAdapter;
    private ArchiveFileIndex archiveFileIndex = new ArchiveFileIndex();
    private FailedToCloseException openendBy = null;
    protected IArchiveFactory archiveFactory;

    public ArchiveImpl(ArchiveOptions archiveOptions) {
        this.setType(2);
        this.setArchiveOptions(archiveOptions);
        this.loadAdapter = (IArchiveLoadAdapter)this.getArchiveOptions().getOption("LOAD_ADAPTER");
        this.loadAdapter.setArchive(this);
        this.openendBy = new FailedToCloseException();
    }

    @Override
    public boolean isOpen() {
        return this.openendBy != null;
    }

    public void close() {
        if (this.isOpen()) {
            this.openendBy = null;
            for (IArchive nestedArchive : this.getNestedArchives()) {
                IArchiveFactory.INSTANCE.closeArchive(nestedArchive);
            }
            this.loadAdapter.close();
            this.dispose();
        }
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.archiveFileIndex = null;
        this.loadAdapter = null;
        this.archiveFactory = null;
        this.archiveOptions = null;
    }

    @Override
    public IArchiveResource getArchiveResource(IPath archiveRelativePath) throws FileNotFoundException {
        AbstractArchiveLoadAdapter.verifyRelative(archiveRelativePath);
        IArchiveResource aFile = null;
        if (this.archiveFileIndex.containsFile(archiveRelativePath)) {
            aFile = this.archiveFileIndex.getFile(archiveRelativePath);
        } else if (!this.archiveFileIndex.isFullyIndexed()) {
            aFile = this.loadAdapter.getArchiveResource(archiveRelativePath);
            if (aFile == null) {
                this.archiveFileIndex.noteEmptyFile(archiveRelativePath);
            } else {
                this.archiveFileIndex.addFile(aFile);
            }
        }
        if (aFile == null) {
            throw new FileNotFoundException(NLS.bind((String)CommonArchiveResourceHandler.ArchiveImpl_0_in_1_, (Object[])new Object[]{archiveRelativePath.toString(), this.toString()}));
        }
        return aFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IArchiveResource> getArchiveResources() {
        ArchiveImpl archiveImpl = this;
        synchronized (archiveImpl) {
            if (!this.archiveFileIndex.isFullyIndexed()) {
                this.archiveFileIndex.fullyIndex(this.loadAdapter.getArchiveResources());
            }
        }
        return this.archiveFileIndex.getFullIndex();
    }

    public void setLoadAdapter(IArchiveLoadAdapter loadAdapter) {
        this.loadAdapter = loadAdapter;
    }

    @Override
    public IArchiveLoadAdapter getLoadAdapter() {
        return this.loadAdapter;
    }

    protected void setArchiveOptions(ArchiveOptions archiveOptions) {
        this.archiveOptions = archiveOptions;
    }

    @Override
    public ArchiveOptions getArchiveOptions() {
        return this.archiveOptions;
    }

    @Override
    public String toString() {
        return this.loadAdapter.toString();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.isOpen()) {
            System.err.println("Archive opener did not close archive: " + this);
            System.err.println("Archive was opened here:");
            this.openendBy.printStackTrace(System.err);
            this.close();
        }
    }

    @Override
    public boolean containsModelObject() {
        return this.containsModelObject(IArchive.EMPTY_MODEL_PATH);
    }

    @Override
    public boolean containsModelObject(IPath modelObjectPath) {
        AbstractArchiveLoadAdapter.verifyRelative(modelObjectPath);
        return this.getLoadAdapter().containsModelObject(modelObjectPath);
    }

    @Override
    public Object getModelObject() throws ArchiveModelLoadException {
        return this.getModelObject(IArchive.EMPTY_MODEL_PATH);
    }

    @Override
    public Object getModelObject(IPath modelObjectPath) throws ArchiveModelLoadException {
        AbstractArchiveLoadAdapter.verifyRelative(modelObjectPath);
        return this.getLoadAdapter().getModelObject(modelObjectPath);
    }

    @Override
    public boolean containsArchiveResource(IPath archiveRelativePath) {
        AbstractArchiveLoadAdapter.verifyRelative(archiveRelativePath);
        if (this.archiveFileIndex.containsFile(archiveRelativePath)) {
            return true;
        }
        if (!this.archiveFileIndex.isFullyIndexed()) {
            return this.loadAdapter.containsArchiveResource(archiveRelativePath);
        }
        return false;
    }

    @Override
    public IArchive getNestedArchive(IArchiveResource archiveResource) throws ArchiveOpenFailureException {
        try {
            if (archiveResource.getArchive() != this) {
                throw new ArchiveOpenFailureException("Attempted to open nested IArchive " + archiveResource.getPath() + " using an IArchiveResource not contained in this IArchive.");
            }
            this.getArchiveResources();
            IArchiveResource cachedArchiveResource = this.getArchiveResource(archiveResource.getPath());
            if (cachedArchiveResource.getType() == 2) {
                IArchive nestedArchive = (IArchive)cachedArchiveResource;
                if (!this.archiveFileIndex.getNestedArchives().contains(nestedArchive)) {
                    this.archiveFileIndex.getNestedArchives().add(nestedArchive);
                }
                return nestedArchive;
            }
            if (cachedArchiveResource.getType() == 1) {
                throw new ArchiveOpenFailureException("Attempted to open nested IArchive " + cachedArchiveResource.getPath() + " using a directory.");
            }
            TempZipFileArchiveLoadAdapterImpl nestedLoadAdapter = null;
            try {
                File tempFile = null;
                try {
                    tempFile = ArchiveUtil.createTempFile(cachedArchiveResource.getPath().toString());
                }
                catch (IOException iOException) {
                    ArchiveUtil.warn("Warning: Unable to create temp file for " + cachedArchiveResource.getPath() + ".  This will impact performance.");
                }
                if (tempFile != null) {
                    InputStream in = cachedArchiveResource.getInputStream();
                    FileOutputStream out = new FileOutputStream(tempFile);
                    ArchiveUtil.copy(in, out);
                    nestedLoadAdapter = new TempZipFileArchiveLoadAdapterImpl(tempFile);
                }
            }
            catch (IOException e) {
                throw new ArchiveOpenFailureException(e);
            }
            ArchiveOptions nestedArchiveOptions = this.cloneUnknownOptions(this.archiveOptions);
            nestedArchiveOptions.setOption("PARENT_ARCHIVE", this);
            nestedArchiveOptions.setOption("LOAD_ADAPTER", nestedLoadAdapter);
            nestedArchiveOptions.setOption("ARCHIVE_PATH", cachedArchiveResource.getPath());
            IArchive nestedArchive = this.archiveFactory.openArchive(nestedArchiveOptions);
            nestedArchive.setPath(cachedArchiveResource.getPath());
            nestedArchive.setArchive(this);
            return nestedArchive;
        }
        catch (FileNotFoundException e) {
            throw new ArchiveOpenFailureException(e);
        }
    }

    protected ArchiveOptions cloneUnknownOptions(ArchiveOptions archiveOptions) {
        ArchiveOptions newOptions = new ArchiveOptions();
        for (Object key : archiveOptions.keySet()) {
            if (key == "ARCHIVE_PATH" || key == "LOAD_ADAPTER" || key == "SAVE_ADAPTER") continue;
            newOptions.setOption(key, archiveOptions.getOption(key));
        }
        return newOptions;
    }

    @Override
    public List<IArchive> getNestedArchives() {
        return Collections.unmodifiableList(this.archiveFileIndex.getNestedArchives());
    }

    void addArchiveResourceInternal(IArchiveResource archiveResource) {
        this.archiveFileIndex.index.put(archiveResource.getPath(), archiveResource);
        if (archiveResource.getType() == 2) {
            this.archiveFileIndex.getNestedArchives().add((IArchive)archiveResource);
        }
        this.archiveFileIndex.fullIndex = null;
    }

    public void setArchiveFactory(IArchiveFactory archiveFactory) {
        this.archiveFactory = archiveFactory;
    }

    private class ArchiveFileIndex {
        private Map<IPath, IArchiveResource> index = new HashMap<IPath, IArchiveResource>();
        private List<IArchive> nestedArchives = null;
        private List<IArchiveResource> fullIndex = null;
        private boolean fullyIndexed = false;

        public synchronized List<IArchive> getNestedArchives() {
            if (this.nestedArchives == null) {
                this.nestedArchives = new ArrayList<IArchive>();
            }
            return this.nestedArchives;
        }

        public synchronized boolean containsFile(IPath archiveRelativePath) {
            AbstractArchiveLoadAdapter.verifyRelative(archiveRelativePath);
            return this.index.containsKey(archiveRelativePath);
        }

        public synchronized IArchiveResource getFile(IPath archiveRelativePath) {
            AbstractArchiveLoadAdapter.verifyRelative(archiveRelativePath);
            IArchiveResource aFile = this.index.get(archiveRelativePath);
            return aFile;
        }

        public synchronized void noteEmptyFile(IPath archiveRelativePath) {
            this.verifyNotFullyIndexed();
            AbstractArchiveLoadAdapter.verifyRelative(archiveRelativePath);
            this.index.put(archiveRelativePath, null);
        }

        public synchronized void addFile(IArchiveResource aFile) {
            this.verifyNotFullyIndexed();
            AbstractArchiveLoadAdapter.verifyRelative(aFile.getPath());
            this.index.put(aFile.getPath(), aFile);
        }

        public synchronized boolean isFullyIndexed() {
            return this.fullyIndexed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fullyIndex(List<IArchiveResource> files) {
            ArchiveFileIndex archiveFileIndex = this;
            synchronized (archiveFileIndex) {
                if (this.fullyIndexed) {
                    this.verifyNotFullyIndexed();
                }
                this.fullyIndexed = true;
            }
            for (IArchiveResource aFile : files) {
                AbstractArchiveLoadAdapter.verifyRelative(aFile.getPath());
                ArchiveFileIndex archiveFileIndex2 = this;
                synchronized (archiveFileIndex2) {
                    if (!this.index.containsKey(aFile.getPath())) {
                        this.index.put(aFile.getPath(), aFile);
                    }
                }
            }
        }

        public synchronized List<IArchiveResource> getFullIndex() {
            if (!this.isFullyIndexed()) {
                throw new RuntimeException("File list has not been fully indexed");
            }
            if (this.fullIndex == null) {
                ArrayList<IArchiveResource> list = new ArrayList<IArchiveResource>();
                list.addAll(this.index.values());
                this.fullIndex = Collections.unmodifiableList(list);
            }
            return this.fullIndex;
        }

        private void verifyNotFullyIndexed() {
            if (this.isFullyIndexed()) {
                throw new RuntimeException("Attempting to modify a fully indexed file list");
            }
        }
    }
}

