/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jpt.common.utility.internal.collection.IdentityHashBag;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticCollectionValueModel;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

public abstract class CompositePropertyValueModel<V, E>
extends CollectionPropertyValueModelAdapter<V, PropertyValueModel<? extends E>> {
    protected final IdentityHashBag<PropertyValueModel<? extends E>> componentPVMs = new IdentityHashBag();
    protected final PropertyChangeListener componentListener = this.buildComponentListener();

    public CompositePropertyValueModel(PropertyValueModel<? extends E> ... collection) {
        this(Arrays.asList(collection));
    }

    public <P extends PropertyValueModel<? extends E>> CompositePropertyValueModel(Collection<? extends P> collection) {
        this((CollectionValueModel<P>)new StaticCollectionValueModel<P>(collection));
    }

    public <P extends PropertyValueModel<? extends E>> CompositePropertyValueModel(CollectionValueModel<P> collectionModel) {
        super(collectionModel);
    }

    protected PropertyChangeListener buildComponentListener() {
        return new ComponentListener();
    }

    protected void componentChanged(PropertyChangeEvent event) {
        this.propertyChanged();
    }

    @Override
    protected void engageModel_() {
        super.engageModel_();
        this.addComponentPVMs(this.collectionModel);
    }

    protected <P extends PropertyValueModel<? extends E>> void addComponentPVMs(Iterable<P> pvms) {
        for (PropertyValueModel each : pvms) {
            this.componentPVMs.add(each);
            each.addPropertyChangeListener("value", this.componentListener);
        }
    }

    @Override
    protected void disengageModel_() {
        this.removeComponentPVMs(this.collectionModel);
        super.disengageModel_();
    }

    protected <P extends PropertyValueModel<? extends E>> void removeComponentPVMs(Iterable<P> pvms) {
        for (PropertyValueModel each : pvms) {
            each.removePropertyChangeListener("value", this.componentListener);
            this.componentPVMs.remove(each);
        }
    }

    @Override
    protected void itemsAdded(CollectionAddEvent event) {
        this.addComponentPVMs(this.getItems(event));
        super.itemsAdded(event);
    }

    @Override
    protected void itemsRemoved(CollectionRemoveEvent event) {
        this.removeComponentPVMs(this.getItems(event));
        super.itemsRemoved(event);
    }

    @Override
    protected void collectionCleared(CollectionClearEvent event) {
        this.removeAllComponentPVMs();
        super.collectionCleared(event);
    }

    protected void removeAllComponentPVMs() {
        ArrayList<PropertyValueModel<? extends E>> copy = new ArrayList<PropertyValueModel<? extends E>>(this.componentPVMs);
        this.removeComponentPVMs(copy);
    }

    @Override
    protected void collectionChanged(CollectionChangeEvent event) {
        this.removeAllComponentPVMs();
        this.addComponentPVMs(this.collectionModel);
        super.collectionChanged(event);
    }

    protected Iterable<? extends PropertyValueModel<? extends E>> getItems(CollectionAddEvent event) {
        return event.getItems();
    }

    protected Iterable<? extends PropertyValueModel<? extends E>> getItems(CollectionRemoveEvent event) {
        return event.getItems();
    }

    protected class ComponentListener
    extends PropertyChangeAdapter {
        protected ComponentListener() {
        }

        @Override
        public void propertyChanged(PropertyChangeEvent event) {
            CompositePropertyValueModel.this.componentChanged(event);
        }
    }
}

