/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.io.Serializable;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;

public class CloneListIterator<E>
implements ListIterator<E> {
    private final ListIterator<Object> listIterator;
    private int cursor;
    private State state;
    private final Adapter<E> adapter;

    public CloneListIterator(List<? extends E> list, Adapter<E> adapter) {
        this(list.toArray(), adapter);
    }

    protected CloneListIterator(Object[] array, Adapter<E> adapter) {
        if (adapter == null) {
            throw new NullPointerException();
        }
        this.listIterator = ListTools.arrayList(array).listIterator();
        this.adapter = adapter;
        this.cursor = 0;
        this.state = State.UNKNOWN;
    }

    @Override
    public boolean hasNext() {
        return this.listIterator.hasNext();
    }

    @Override
    public E next() {
        Object next = this.listIterator.next();
        ++this.cursor;
        this.state = State.NEXT;
        return (E)next;
    }

    @Override
    public void remove() {
        this.listIterator.remove();
        if (this.state != State.PREVIOUS) {
            --this.cursor;
        }
        this.adapter.remove(this.cursor);
    }

    @Override
    public int nextIndex() {
        return this.listIterator.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.listIterator.previousIndex();
    }

    @Override
    public boolean hasPrevious() {
        return this.listIterator.hasPrevious();
    }

    @Override
    public E previous() {
        Object previous = this.listIterator.previous();
        --this.cursor;
        this.state = State.PREVIOUS;
        return (E)previous;
    }

    @Override
    public void add(E o) {
        this.listIterator.add(o);
        this.adapter.add(this.cursor, o);
        ++this.cursor;
    }

    @Override
    public void set(E o) {
        this.listIterator.set(o);
        if (this.state == State.PREVIOUS) {
            this.adapter.set(this.cursor, o);
        } else {
            this.adapter.set(this.cursor - 1, o);
        }
    }

    public String toString() {
        return ObjectTools.toString(this);
    }

    public static interface Adapter<E> {
        public void add(int var1, E var2);

        public void remove(int var1);

        public void set(int var1, E var2);

        public static final class ReadOnly<S>
        implements Adapter<S>,
        Serializable {
            public static final Adapter INSTANCE = new ReadOnly();
            private static final long serialVersionUID = 1L;

            public static <R> Adapter<R> instance() {
                return INSTANCE;
            }

            private ReadOnly() {
            }

            @Override
            public void add(int index, Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(int index, Object o) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return ObjectTools.singletonToString(this);
            }

            private Object readResolve() {
                return INSTANCE;
            }
        }
    }

    private static enum State {
        UNKNOWN,
        PREVIOUS,
        NEXT;

    }
}

