/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.Locale;
import org.eclipse.jetty.http.ComplianceUtils;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.CookieParser;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.util.StringUtil;

public class RFC6265CookieParser
implements CookieParser {
    private final CookieParser.Handler _handler;
    private final CookieCompliance _complianceMode;
    private final ComplianceViolation.Listener _complianceListener;

    protected RFC6265CookieParser(CookieParser.Handler handler, CookieCompliance compliance, ComplianceViolation.Listener complianceListener) {
        this._handler = handler;
        this._complianceMode = compliance;
        this._complianceListener = complianceListener;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void parseField(String field) {
        state = State.START;
        attributeName = null;
        value = null;
        cookieName = null;
        cookieValue = null;
        cookiePath = null;
        cookieDomain = null;
        cookieComment = null;
        cookieVersion = 0;
        cookieInvalid = false;
        spaces = 0;
        supportObsoleteAttributes = this._complianceMode.allows(CookieCompliance.Violation.ATTRIBUTE_VALUES) != false || this._complianceMode.allows(CookieCompliance.Violation.ATTRIBUTES) != false;
        length = field.length();
        string = new StringBuilder();
        block32: for (i = 0; i <= length; ++i) {
            c = i == length ? ';' : (char)field.charAt(i);
            token = HttpTokens.getToken(c);
            if (token == null) {
                if (!ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.INVALID_COOKIES, field, this._complianceListener)) {
                    throw new CookieParser.InvalidCookieException("Invalid Cookie character: 0x%02x [%s]: %s".formatted(new Object[]{(byte)c, Character.valueOf(c), field}));
                }
                state = State.INVALID_COOKIE;
                continue;
            }
            switch (state.ordinal()) {
                case 0: {
                    if (c == ' ' || c == '\t' || c == ';') continue block32;
                    string.setLength(0);
                    if (token.isRfc2616Token()) {
                        if (StringUtil.isNotBlank((String)cookieName) && (c != '$' || !supportObsoleteAttributes)) {
                            this._handler.addCookie(cookieName, cookieValue, cookieVersion, cookieDomain, cookiePath, cookieComment);
                            cookieName = null;
                            cookieValue = null;
                            cookieDomain = null;
                            cookiePath = null;
                            cookieComment = null;
                        }
                        string.append(c);
                        state = State.IN_NAME;
                        continue block32;
                    }
                    if (ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.INVALID_COOKIES, field, this._complianceListener)) {
                        state = State.INVALID_COOKIE;
                        continue block32;
                    }
                    throw new CookieParser.InvalidCookieException("Bad Cookie name");
                }
                case 1: {
                    if (c == '=') {
                        if (string.charAt(0) == '$') {
                            attributeName = string.toString();
                        } else {
                            cookieName = string.toString();
                        }
                        state = State.VALUE;
                        continue block32;
                    }
                    if ((c == ' ' || c == '\t') && ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.OPTIONAL_WHITE_SPACE, field, this._complianceListener)) {
                        if (string.charAt(0) == '$') {
                            attributeName = string.toString();
                        } else {
                            cookieName = string.toString();
                        }
                        state = State.AFTER_NAME;
                        continue block32;
                    }
                    if (token.isRfc2616Token()) {
                        string.append(c);
                        continue block32;
                    }
                    if (ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.INVALID_COOKIES, string.toString(), this._complianceListener)) {
                        state = c == ';' ? State.START : State.INVALID_COOKIE;
                        continue block32;
                    }
                    throw new CookieParser.InvalidCookieException("Bad Cookie name");
                }
                case 2: {
                    if (c == '=') {
                        state = State.VALUE;
                        continue block32;
                    }
                    if (c == ';' || c == ',') {
                        state = State.START;
                        continue block32;
                    }
                    if (ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.INVALID_COOKIES, field, this._complianceListener)) {
                        state = State.INVALID_COOKIE;
                        continue block32;
                    }
                    throw new CookieParser.InvalidCookieException("Bad Cookie");
                }
                case 3: {
                    if (c == ' ' && ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.OPTIONAL_WHITE_SPACE, field, this._complianceListener)) continue block32;
                    string.setLength(0);
                    if (c == '\"') {
                        if (!this._complianceMode.allows(CookieCompliance.Violation.STRIPPED_QUOTES)) {
                            string.append(c);
                        }
                        state = State.IN_QUOTED_VALUE;
                        continue block32;
                    }
                    if (c == ';') {
                        value = "";
                        --i;
                        state = State.END;
                        continue block32;
                    }
                    if (token.isRfc6265CookieOctet()) {
                        string.append(c);
                        state = State.IN_VALUE;
                        continue block32;
                    }
                    if (ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.INVALID_COOKIES, "Illegal character '%s' in %s".formatted(new Object[]{Character.valueOf(c), field}), this._complianceListener)) {
                        state = State.INVALID_COOKIE;
                        continue block32;
                    }
                    throw new CookieParser.InvalidCookieException("Bad Cookie value");
                }
                case 4: {
                    if (c == ' ' && ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.SPACE_IN_VALUES, field, this._complianceListener)) {
                        spaces = 1;
                        state = State.SPACE_IN_VALUE;
                        continue block32;
                    }
                    if (c == ' ' || c == ';' || c == ',' || c == '\t') {
                        value = string.toString();
                        --i;
                        state = State.END;
                        continue block32;
                    }
                    if (token.isRfc6265CookieOctet()) {
                        string.append(c);
                        continue block32;
                    }
                    if (ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.INVALID_COOKIES, "Illegal character '%s' in %s".formatted(new Object[]{Character.valueOf(c), field}), this._complianceListener)) {
                        state = State.INVALID_COOKIE;
                        continue block32;
                    }
                    throw new CookieParser.InvalidCookieException("Bad Cookie value");
                }
                case 5: {
                    if (c == ' ') {
                        ++spaces;
                        continue block32;
                    }
                    if (c == ';' || c == ',' || c == '\t') {
                        value = string.toString();
                        --i;
                        state = State.END;
                        continue block32;
                    }
                    if (token.isRfc6265CookieOctet()) {
                        string.append(" ".repeat(spaces)).append(c);
                        state = State.IN_VALUE;
                        continue block32;
                    }
                    if (ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.INVALID_COOKIES, field, this._complianceListener)) {
                        state = State.INVALID_COOKIE;
                        continue block32;
                    }
                    throw new CookieParser.InvalidCookieException("Bad Cookie value");
                }
                case 6: {
                    if (c == '\"') {
                        if (this._complianceMode.allows(CookieCompliance.Violation.STRIPPED_QUOTES)) {
                            value = string.toString();
                            ComplianceUtils.notify(this._complianceListener, new ComplianceViolation.Event(this._complianceMode, CookieCompliance.Violation.STRIPPED_QUOTES, value, true));
                        } else {
                            string.append(c);
                            value = string.toString();
                            ComplianceUtils.notify(this._complianceListener, new ComplianceViolation.Event(this._complianceMode, CookieCompliance.Violation.STRIPPED_QUOTES, value, false));
                        }
                        state = State.AFTER_QUOTED_VALUE;
                        continue block32;
                    }
                    if (c == '\\' && ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.ESCAPE_IN_QUOTES, field, this._complianceListener)) {
                        state = State.ESCAPED_VALUE;
                        continue block32;
                    }
                    if (token.isRfc6265CookieOctet()) {
                        string.append(c);
                        continue block32;
                    }
                    if (ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.SPECIAL_CHARS_IN_QUOTES, "Character [" + c + "] is not allowed - " + field, this._complianceListener)) {
                        string.append(c);
                        continue block32;
                    }
                    if (c == ',' && ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.COMMA_NOT_VALID_OCTET, field, this._complianceListener)) {
                        string.append(c);
                        continue block32;
                    }
                    if (c == ' ' && ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.SPACE_IN_VALUES, field, this._complianceListener)) {
                        string.append(c);
                        continue block32;
                    }
                    if (ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.INVALID_COOKIES, "Illegal character '%s' in quoted section in %s".formatted(new Object[]{Character.valueOf(c), field}), this._complianceListener)) {
                        string.append(c);
                        if (cookieInvalid) continue block32;
                        cookieInvalid = true;
                        continue block32;
                    }
                    throw new CookieParser.InvalidCookieException("Bad Cookie quoted value");
                }
                case 7: {
                    string.append(c);
                    state = State.IN_QUOTED_VALUE;
                    continue block32;
                }
                case 8: {
                    if (c == ';' || c == ',' || c == ' ' || c == '\t') {
                        --i;
                        state = cookieInvalid != false ? State.INVALID_COOKIE : State.END;
                        continue block32;
                    }
                    if (ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.INVALID_COOKIES, field, this._complianceListener)) {
                        state = State.INVALID_COOKIE;
                        continue block32;
                    }
                    throw new CookieParser.InvalidCookieException("Bad Cookie quoted value");
                }
                case 9: {
                    if (c != 59) ** GOTO lbl192
                    state = State.START;
                    ** GOTO lbl201
lbl192:
                    // 1 sources

                    if (c != 44) ** GOTO lbl200
                    if (ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.COMMA_SEPARATOR, field, this._complianceListener)) {
                        state = State.START;
                    } else {
                        if (ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.INVALID_COOKIES, "Illegal character ',' in " + field, this._complianceListener)) {
                            state = State.INVALID_COOKIE;
                            continue block32;
                        }
                        throw new CookieParser.InvalidCookieException("Comma cookie separator");
lbl200:
                        // 1 sources

                        if ((c == ' ' || c == '\t') && ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.OPTIONAL_WHITE_SPACE, field, this._complianceListener)) continue block32;
                    }
lbl201:
                    // 3 sources

                    if (StringUtil.isBlank(attributeName)) {
                        cookieValue = value;
                    } else {
                        complianceAllowsAttributes = this._complianceMode.allows(CookieCompliance.Violation.ATTRIBUTES);
                        if (this._complianceMode.allows(CookieCompliance.Violation.ATTRIBUTE_VALUES)) {
                            ComplianceUtils.notify(this._complianceListener, new ComplianceViolation.Event(this._complianceMode, CookieCompliance.Violation.ATTRIBUTES, attributeName, complianceAllowsAttributes));
                            var20_20 = attributeName.toLowerCase(Locale.ENGLISH);
                            var21_21 = -1;
                            switch (var20_20.hashCode()) {
                                case 36680265: {
                                    if (!var20_20.equals("$path")) break;
                                    var21_21 = 0;
                                    break;
                                }
                                case 559163880: {
                                    if (!var20_20.equals("$domain")) break;
                                    var21_21 = 1;
                                    break;
                                }
                                case 36693669: {
                                    if (!var20_20.equals("$port")) break;
                                    var21_21 = 2;
                                    break;
                                }
                                case -1331729356: {
                                    if (!var20_20.equals("$version")) break;
                                    var21_21 = 3;
                                    break;
                                }
                                case 1302394512: {
                                    if (!var20_20.equals("$expires")) break;
                                    var21_21 = 4;
                                    break;
                                }
                                case -840396686: {
                                    if (!var20_20.equals("$max-age")) break;
                                    var21_21 = 5;
                                    break;
                                }
                                case 633432532: {
                                    if (!var20_20.equals("$commenturl")) break;
                                    var21_21 = 6;
                                    break;
                                }
                                case -732938821: {
                                    if (!var20_20.equals("$comment")) break;
                                    var21_21 = 7;
                                    break;
                                }
                                case -11970566: {
                                    if (!var20_20.equals("$discard")) break;
                                    var21_21 = 8;
                                    break;
                                }
                                case 979087515: {
                                    if (!var20_20.equals("$secure")) break;
                                    var21_21 = 9;
                                }
                            }
                            switch (var21_21) {
                                case 0: {
                                    cookiePath = value;
                                    break;
                                }
                                case 1: {
                                    cookieDomain = value;
                                    break;
                                }
                                case 2: {
                                    cookieComment = "$port=" + value;
                                    break;
                                }
                                case 3: {
                                    cookieVersion = Integer.parseInt(value);
                                    break;
                                }
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: {
                                    break;
                                }
                                default: {
                                    if (!ComplianceUtils.allows(this._complianceMode, CookieCompliance.Violation.INVALID_COOKIES, "Invalid Cookie attribute [%s]".formatted(new Object[]{attributeName}), this._complianceListener)) {
                                        throw new IllegalArgumentException("Invalid Cookie attribute: " + attributeName);
                                    }
                                    state = State.INVALID_COOKIE;
                                    break;
                                }
                            }
                        } else if (complianceAllowsAttributes) {
                            ComplianceUtils.notify(this._complianceListener, new ComplianceViolation.Event(this._complianceMode, CookieCompliance.Violation.ATTRIBUTES, attributeName, true));
                        } else {
                            cookieName = attributeName;
                            cookieValue = value;
                        }
                        attributeName = null;
                    }
                    value = null;
                    if (state != State.END) continue block32;
                    throw new CookieParser.InvalidCookieException("Invalid cookie");
                }
                case 10: {
                    attributeName = null;
                    value = null;
                    cookieName = null;
                    cookieValue = null;
                    cookiePath = null;
                    cookieDomain = null;
                    cookieComment = null;
                    cookieInvalid = false;
                    if (c != 59) continue block32;
                    state = State.START;
                }
            }
        }
        if (!cookieInvalid && !StringUtil.isBlank(cookieName)) {
            this._handler.addCookie(cookieName, cookieValue, cookieVersion, cookieDomain, cookiePath, cookieComment);
        }
    }

    private static enum State {
        START,
        IN_NAME,
        AFTER_NAME,
        VALUE,
        IN_VALUE,
        SPACE_IN_VALUE,
        IN_QUOTED_VALUE,
        ESCAPED_VALUE,
        AFTER_QUOTED_VALUE,
        END,
        INVALID_COOKIE;

    }
}

