/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public interface CDOEditorOpener {
    public static final int DEFAULT_PRIORITY = 500;

    public String getID();

    public String getName();

    public ImageDescriptor getIcon();

    public int getPriority();

    public String getRegex();

    public boolean matchesRegex(URI var1);

    public IEditorPart openEditor(IWorkbenchPage var1, URI var2);

    public static abstract class Default
    implements CDOEditorOpener {
        private String id;
        private String name;
        private ImageDescriptor icon;
        private String regex;
        private int priority = 500;
        @ReflectUtil.ExcludeFromDump
        private transient Pattern pattern;

        public Default() {
        }

        public Default(String id, String name, ImageDescriptor icon, String regex, int priority) {
            this.id = id;
            this.name = name;
            this.icon = icon;
            this.regex = regex;
            this.priority = priority;
        }

        @Override
        public String getID() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ImageDescriptor getIcon() {
            return this.icon;
        }

        @Override
        public final int getPriority() {
            return this.priority;
        }

        @Override
        public final String getRegex() {
            return this.regex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean matchesRegex(URI uri) {
            String string = this.regex;
            synchronized (string) {
                if (this.pattern == null) {
                    this.pattern = Pattern.compile(this.regex);
                }
            }
            Matcher matcher = this.pattern.matcher(uri.toString());
            return matcher.matches();
        }

        @Override
        public IEditorPart openEditor(final IWorkbenchPage page, URI uri) {
            HashSet editors = new HashSet();
            final IEditorPart[] editor = new IEditorPart[1];
            IPartListener partListener = new IPartListener(){

                public void partClosed(IWorkbenchPart part) {
                    if (part == editor[0]) {
                        page.removePartListener((IPartListener)this);
                    }
                }

                public void partOpened(IWorkbenchPart part) {
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partActivated(IWorkbenchPart part) {
                }
            };
            page.addPartListener(partListener);
            editor[0] = this.doOpenEditor(page, uri);
            if (!editors.contains(editor[0])) {
                page.removePartListener(partListener);
            }
            return editor[0];
        }

        protected abstract IEditorPart doOpenEditor(IWorkbenchPage var1, URI var2);

        public String toString() {
            return this.id + "[" + this.regex + "]";
        }
    }

    public static class Registry
    extends Container<CDOEditorOpener> {
        public static final Registry INSTANCE = new Registry();
        private static final String EXT_POINT = "editorOpeners";
        private final Map<String, CDOEditorOpener> editorOpeners = new HashMap<String, CDOEditorOpener>();

        public IEditorPart openEditor(IWorkbenchPage page, URI uri) {
            if (uri == null) {
                return null;
            }
            CDOEditorOpener[] cDOEditorOpenerArray = this.getEditorOpeners(uri);
            int n = cDOEditorOpenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOEditorOpener editorOpener = cDOEditorOpenerArray[n2];
                IEditorPart editor = editorOpener.openEditor(page, uri);
                if (editor != null) {
                    return editor;
                }
                ++n2;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOEditorOpener getEditorOpener(String id) {
            Map<String, CDOEditorOpener> map = this.editorOpeners;
            synchronized (map) {
                return this.editorOpeners.get(id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOEditorOpener[] getEditorOpeners(URI uri) {
            ArrayList<CDOEditorOpener> result = new ArrayList<CDOEditorOpener>();
            Map<String, CDOEditorOpener> map = this.editorOpeners;
            synchronized (map) {
                for (CDOEditorOpener editorOpener : this.editorOpeners.values()) {
                    if (!editorOpener.matchesRegex(uri)) continue;
                    result.add(editorOpener);
                }
            }
            Collections.sort(result, new Comparator<CDOEditorOpener>(){

                @Override
                public int compare(CDOEditorOpener o1, CDOEditorOpener o2) {
                    return -Integer.valueOf(o1.getPriority()).compareTo(o2.getPriority());
                }
            });
            return result.toArray(new CDOEditorOpener[result.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEditorOpener(CDOEditorOpener editorOpener) {
            boolean added;
            Map<String, CDOEditorOpener> map = this.editorOpeners;
            synchronized (map) {
                String id = editorOpener.getID();
                boolean bl = added = !this.editorOpeners.containsKey(id);
                if (added) {
                    this.editorOpeners.put(id, editorOpener);
                }
            }
            if (added) {
                this.fireElementAddedEvent(editorOpener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeEditorOpener(CDOEditorOpener editorOpener) {
            boolean removed;
            Map<String, CDOEditorOpener> map = this.editorOpeners;
            synchronized (map) {
                String id = editorOpener.getID();
                removed = this.editorOpeners.remove(id) != null;
            }
            if (removed) {
                this.fireElementRemovedEvent(editorOpener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOEditorOpener[] getElements() {
            Map<String, CDOEditorOpener> map = this.editorOpeners;
            synchronized (map) {
                return this.editorOpeners.values().toArray(new CDOEditorOpener[this.editorOpeners.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Map<String, CDOEditorOpener> map = this.editorOpeners;
            synchronized (map) {
                return this.editorOpeners.isEmpty();
            }
        }

        protected void doActivate() throws Exception {
            super.doActivate();
            if (OMPlatform.INSTANCE.isOSGiRunning()) {
                try {
                    this.readExtensions();
                }
                catch (Throwable t) {
                    OM.LOG.error(t);
                }
            }
        }

        public void readExtensions() {
            IConfigurationElement[] configurationElements;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = configurationElements = registry.getConfigurationElementsFor("org.eclipse.emf.cdo.ui", EXT_POINT);
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    EditorOpenerDescriptor descriptor = new EditorOpenerDescriptor(element);
                    this.addEditorOpener(descriptor);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
                ++n2;
            }
        }

        public static final class EditorOpenerDescriptor
        extends Default {
            private IConfigurationElement element;

            public EditorOpenerDescriptor(IConfigurationElement element) {
                super(EditorOpenerDescriptor.getID(element), EditorOpenerDescriptor.getName(element), EditorOpenerDescriptor.getIcon(element), EditorOpenerDescriptor.getRegex(element), EditorOpenerDescriptor.getPriority(element));
                this.element = element;
                if (StringUtil.isEmpty((String)element.getAttribute("class"))) {
                    throw new IllegalArgumentException(MessageFormat.format("Class not defined for extension {0}", element));
                }
            }

            @Override
            protected IEditorPart doOpenEditor(IWorkbenchPage page, URI uri) {
                return this.getEditorOpener().openEditor(page, uri);
            }

            private CDOEditorOpener getEditorOpener() {
                try {
                    return (CDOEditorOpener)this.element.createExecutableExtension("class");
                }
                catch (CoreException ex) {
                    throw WrappedException.wrap((Exception)((Object)ex));
                }
            }

            private static String getID(IConfigurationElement element) {
                String value = element.getAttribute("id");
                if (StringUtil.isEmpty((String)value)) {
                    throw new IllegalArgumentException(MessageFormat.format("ID not defined for extension {0}", element));
                }
                return value;
            }

            private static String getName(IConfigurationElement element) {
                String value = element.getAttribute("name");
                if (StringUtil.isEmpty((String)value)) {
                    throw new IllegalArgumentException(MessageFormat.format("Name not defined for extension {0}", element));
                }
                return value;
            }

            private static ImageDescriptor getIcon(IConfigurationElement element) {
                String icon = element.getAttribute("icon");
                if (icon != null) {
                    try {
                        return AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getNamespaceIdentifier(), (String)icon);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }

            private static String getRegex(IConfigurationElement element) {
                String value = element.getAttribute("regex");
                if (StringUtil.isEmpty((String)value)) {
                    throw new IllegalArgumentException(MessageFormat.format("Regex not defined for extension {0}", element));
                }
                return value;
            }

            private static int getPriority(IConfigurationElement element) {
                try {
                    String value = element.getAttribute("priority");
                    return Integer.parseInt(value);
                }
                catch (Exception ex) {
                    return 500;
                }
            }
        }
    }
}

