/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingUnitSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.DBStoreTable;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.ObjectTypeTable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.db.BatchedStatement;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class UnitMappingTable
extends DBStoreTable {
    private static final int WRITE_UNIT_MAPPING_BATCH_SIZE = 100000;
    private String sqlSelectRoots;
    private String sqlInsertMappings;
    private String sqlSelectClasses;
    private IDBField elem;
    private IDBField unit;

    public UnitMappingTable(IDBStore store) {
        super(store, NAMES.UNITS);
    }

    public final IDBField elem() {
        return this.elem;
    }

    public final IDBField unit() {
        return this.unit;
    }

    public List<CDOID> readUnitRoots(IDBStoreAccessor accessor) {
        ArrayList<CDOID> rootIDs = new ArrayList<CDOID>();
        IIDHandler idHandler = this.store().getIDHandler();
        Statement stmt = null;
        try {
            try {
                stmt = accessor.getDBConnection().createStatement();
                if (DBUtil.isTracerEnabled()) {
                    DBUtil.trace((String)stmt.toString());
                }
                ResultSet resultSet = stmt.executeQuery(this.sqlSelectRoots);
                while (resultSet.next()) {
                    CDOID rootID = idHandler.getCDOID(resultSet, 1);
                    rootIDs.add(rootID);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(stmt);
            throw throwable;
        }
        DBUtil.close((Statement)stmt);
        return rootIDs;
    }

    public void readUnitRevisions(IDBStoreAccessor accessor, IView view, CDOID rootID, CDORevisionHandler revisionHandler, OMMonitor monitor) {
        IIDHandler idHandler = this.store().getIDHandler();
        IMappingStrategy mappingStrategy = this.store().getMappingStrategy();
        IMetaDataManager metaDataManager = this.store().getMetaDataManager();
        long timeStamp = view.isHistorical() ? view.getTimeStamp() : this.store().getRepository().getTimeStamp();
        CDOBranchPoint branchPoint = view.getBranch().getPoint(timeStamp);
        IDBConnection connection = accessor.getDBConnection();
        IDBPreparedStatement stmt = connection.prepareStatement(this.sqlSelectClasses, IDBPreparedStatement.ReuseProbability.HIGH);
        int jdbcFetchSize = this.store().getJDBCFetchSize();
        int oldFetchSize = -1;
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, rootID);
                oldFetchSize = stmt.getFetchSize();
                stmt.setFetchSize(jdbcFetchSize);
                IDBResultSet resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    CDOID classID = idHandler.getCDOID((ResultSet)resultSet, 1);
                    EClass eClass = (EClass)metaDataManager.getMetaInstance(classID);
                    IClassMappingUnitSupport classMapping = (IClassMappingUnitSupport)mappingStrategy.getClassMapping(eClass);
                    classMapping.readUnitRevisions(accessor, branchPoint, rootID, revisionHandler);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            if (oldFetchSize != -1) {
                try {
                    stmt.setFetchSize(oldFetchSize);
                }
                catch (SQLException ex) {
                    throw new DBException((Throwable)ex);
                }
            }
            DBUtil.close((Statement)stmt);
        }
    }

    public BatchedStatement initUnit(IDBStoreAccessor accessor, long timeStamp, IView view, CDOID rootID, CDORevisionHandler revisionHandler, Set<CDOID> initializedIDs, OMMonitor monitor) {
        IIDHandler idHandler = this.store().getIDHandler();
        IDBConnection connection = accessor.getDBConnection();
        BatchedStatement stmt = DBUtil.batched((PreparedStatement)connection.prepareStatement(this.sqlInsertMappings, IDBPreparedStatement.ReuseProbability.HIGH), (int)100000);
        try {
            CDORevision revision = view.getRevision(rootID);
            this.initUnit(stmt, view, rootID, revisionHandler, initializedIDs, timeStamp, idHandler, revision, monitor);
            return stmt;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    private void initUnit(BatchedStatement stmt, IView view, CDOID rootID, CDORevisionHandler revisionHandler, Set<CDOID> initializedIDs, long timeStamp, IIDHandler idHandler, CDORevision revision, OMMonitor monitor) throws SQLException {
        revisionHandler.handleRevision(revision);
        CDOID id = revision.getID();
        initializedIDs.add(id);
        this.writeUnitMapping(stmt, rootID, timeStamp, idHandler, id);
        List children = CDORevisionUtil.getChildRevisions((CDORevision)revision, (CDORevisionProvider)view, (boolean)true);
        for (CDORevision child : children) {
            this.initUnit(stmt, view, rootID, revisionHandler, initializedIDs, timeStamp, idHandler, child, monitor);
        }
    }

    public void finishUnit(BatchedStatement stmt, CDOID rootID, List<CDOID> ids, long timeStamp) {
        IIDHandler idHandler = this.store().getIDHandler();
        Connection connection = null;
        try {
            try {
                connection = stmt.getConnection();
                for (CDOID id : ids) {
                    this.writeUnitMapping(stmt, rootID, timeStamp, idHandler, id);
                }
            }
            catch (SQLException ex) {
                DBUtil.rollbackSilently((Connection)connection);
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
        try {
            connection.commit();
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    public void writeUnitMappings(IDBStoreAccessor accessor, Map<CDOID, CDOID> unitMappings, long timeStamp) {
        IIDHandler idHandler = this.store().getIDHandler();
        IDBConnection connection = accessor.getDBConnection();
        BatchedStatement stmt = DBUtil.batched((PreparedStatement)connection.prepareStatement(this.sqlInsertMappings, IDBPreparedStatement.ReuseProbability.HIGH), (int)100000);
        try {
            try {
                for (Map.Entry<CDOID, CDOID> entry : unitMappings.entrySet()) {
                    CDOID id = entry.getKey();
                    CDOID rootID = entry.getValue();
                    this.writeUnitMapping(stmt, rootID, timeStamp, idHandler, id);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    private void writeUnitMapping(BatchedStatement stmt, CDOID rootID, long timeStamp, IIDHandler idHandler, CDOID id) throws SQLException {
        idHandler.setCDOID((PreparedStatement)stmt, 1, id);
        idHandler.setCDOID((PreparedStatement)stmt, 2, rootID);
        stmt.executeUpdate();
    }

    @Override
    protected void firstActivate(IDBTable table) {
        DBType idType = this.store().getIDHandler().getDBType();
        int idLength = this.store().getIDColumnLength();
        this.elem = table.addField(NAMES.ELEM, idType, idLength, true);
        this.unit = table.addField(NAMES.UNIT, idType, idLength);
        table.addIndex(IDBIndex.Type.PRIMARY_KEY, new IDBField[]{this.elem});
        table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{this.unit});
    }

    @Override
    protected void reActivate(IDBTable table) {
        this.elem = table.getField(NAMES.ELEM);
        this.unit = table.getField(NAMES.UNIT);
    }

    @Override
    protected void initSQL(IDBTable table) {
        ObjectTypeTable objects = ((AbstractHorizontalMappingStrategy)this.store().getMappingStrategy()).objects();
        this.sqlSelectRoots = "SELECT DISTINCT " + this.unit + " FROM " + table;
        this.sqlInsertMappings = "INSERT INTO " + table + " (" + this.elem + ", " + this.unit + ") VALUES (?, ?)";
        this.sqlSelectClasses = "SELECT " + objects.clazz() + ", COUNT(" + this.elem + ") FROM " + table + ", " + objects + " WHERE " + this.elem + "=" + objects.id() + " AND " + this.unit + "=? GROUP BY " + objects.clazz();
    }

    private static final class NAMES {
        private static final String UNITS = NAMES.name("cdo_units");
        private static final String ELEM = NAMES.name("cdo_elem");
        private static final String UNIT = NAMES.name("cdo_unit");

        private NAMES() {
        }

        private static String name(String name) {
            return DBUtil.name((String)name, UnitMappingTable.class);
        }
    }
}

