/*******************************************************************************
 * Copyright (c) 2000, 2007 IBM Corporation and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 
 *******************************************************************************/
package org.eclipse.dltk.internal.corext.refactoring.tagging;

public interface ITextUpdating {

	/**
	 * Performs a dynamic check whether this refactoring object is capable of
	 * updating references to the renamed element.
	 */
	public boolean canEnableTextUpdating();
	
	/**
	 * If <code>canEnableTextUpdating</code> returns <code>true</code>,
	 * then this method is used to ask the refactoring object whether references
	 * in regular (non Javadoc) comments and string literals should be updated.
	 * This call can be ignored if <code>canEnableTextUpdating</code> returns
	 * <code>false</code>.
	 */
	public boolean getUpdateTextualMatches();
	
	/**
	 * If <code>canEnableTextUpdating</code> returns <code>true</code>,
	 * then this method is used to inform the refactoring object whether references
	 * in regular (non Javadoc) comments and string literals should be updated.
	 * This call can be ignored if <code>canEnableTextUpdating</code> returns
	 * <code>false</code>.
	 */
	public void setUpdateTextualMatches(boolean update);
	
	/**
	 * Returns the current name of the element to be renamed.
	 * 
	 * @return the current name of the element to be renamed
	 */
	public String getCurrentElementName();
	
	/**
	 * Returns the current qualifier of the element to be renamed.
	 * 
	 * @return the current qualifier of the element to be renamed
	 */
	public String getCurrentElementQualifier();
	
	/**
	 * Returns the new name of the element
	 * 
	 * @return the new element name
	 */
	public String getNewElementName();
}


