/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.terminal.ui;

import java.nio.charset.Charset;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.terminal.ui.ConsoleTerminalListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.terminal.connector.ITerminalConnector;
import org.eclipse.terminal.connector.ITerminalControl;
import org.eclipse.terminal.control.ITerminalListener;
import org.eclipse.terminal.control.ITerminalViewControl;
import org.eclipse.terminal.control.TerminalViewControlFactory;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;

class TerminalConsolePage
implements IPageBookViewPage,
IAdaptable {
    private IPageSite site;
    private ITerminalViewControl viewer;
    private Composite composite;
    private final ITerminalConnector connector;
    private final Consumer<ITerminalControl> terminalControlHandler;

    public TerminalConsolePage(ITerminalConnector connector, Consumer<ITerminalControl> terminalControlHandler) {
        this.connector = connector;
        this.terminalControlHandler = terminalControlHandler;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new FillLayout());
        this.viewer = TerminalViewControlFactory.makeControl((ITerminalListener)new ConsoleTerminalListener(), (Composite)this.composite, (ITerminalConnector[])new ITerminalConnector[0], (boolean)true);
        this.viewer.setConnector(this.connector);
        this.viewer.setCharset(Charset.defaultCharset());
        this.viewer.clearTerminal();
        this.viewer.connectTerminal();
        ITerminalViewControl iTerminalViewControl = this.viewer;
        if (iTerminalViewControl instanceof ITerminalControl) {
            ITerminalControl ctrl = (ITerminalControl)iTerminalViewControl;
            ctrl.setConnectOnEnterIfClosed(false);
            ctrl.setVT100LineWrapping(true);
            if (this.terminalControlHandler != null) {
                this.terminalControlHandler.accept(ctrl);
            }
        }
    }

    public void dispose() {
        this.viewer.disposeTerminal();
        this.composite.dispose();
    }

    public Control getControl() {
        return this.composite;
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }

    public IPageSite getSite() {
        return this.site;
    }

    public void init(IPageSite site) throws PartInitException {
        this.site = site;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }
}

