/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.property;

import java.util.List;
import org.eclipse.acceleo.aql.ide.AcceleoPlugin;
import org.eclipse.acceleo.aql.ide.ui.AcceleoUIPlugin;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;

public class AcceleoPropertyTester
extends PropertyTester {
    public static final String IS_MAIN = "isMain";
    public static final String IS_BLOCK_SELECTION = "isBlockSelection";
    public static final String IS_ACCELEO_TEXT_SELECTION = "isAcceleoTextSelection";
    public static final String IS_IN_JAVA_PROJECT = "isInJavaProject";
    public static final String IS_IN_PLUGIN_PROJECT = "isInPluginProject";
    public static final String IS_IN_MAVEN_PROJECT = "isInMavenProject";
    private static final String PLUGIN_NATURE = "org.eclipse.pde.PluginNature";
    private static final String MAVEN_NATURE = "org.eclipse.m2e.core.maven2Nature";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        return switch (property) {
            case IS_MAIN -> {
                if (receiver instanceof IFile) {
                    yield AcceleoPlugin.isAcceleoMain((IResource)((IFile)receiver));
                }
                yield false;
            }
            case IS_BLOCK_SELECTION -> {
                if (receiver instanceof ITextSelection) {
                    ITextSelection selection = (ITextSelection)receiver;
                    IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (activeWorkbenchWindow != null) {
                        IEditorPart activeEditor = activeWorkbenchWindow.getActivePage().getActiveEditor();
                        if (activeEditor instanceof TextEditor) {
                            IDocument document = ((TextEditor)activeEditor).getDocumentProvider().getDocument((Object)activeEditor.getEditorInput());
                            if (selection.getOffset() - 1 < document.getLength()) {
                                boolean startAtNewLine = selection.getOffset() == 0 || document.get().charAt(selection.getOffset() - 1) == '\n' || document.get().charAt(selection.getOffset() - 1) == '\r';
                                yield startAtNewLine && (!selection.isEmpty() || !selection.getText().endsWith("\n")) && !selection.getText().endsWith("\r");
                            }
                            yield false;
                        }
                        yield false;
                    }
                    yield false;
                }
                yield false;
            }
            case IS_ACCELEO_TEXT_SELECTION -> {
                if (receiver instanceof ITextSelection) {
                    IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (activeWorkbenchWindow != null) {
                        IEditorPart activeEditor = activeWorkbenchWindow.getActivePage().getActiveEditor();
                        if (activeEditor instanceof TextEditor) {
                            IDocument document = ((TextEditor)activeEditor).getDocumentProvider().getDocument((Object)activeEditor.getEditorInput());
                            List contentTypes = LSPEclipseUtils.getDocumentContentTypes((IDocument)document);
                            boolean foundAcceleoContentType = false;
                            for (IContentType contentType : contentTypes) {
                                if (!"Acceleo".equals(contentType.getName())) continue;
                                foundAcceleoContentType = true;
                                break;
                            }
                            yield foundAcceleoContentType;
                        }
                        yield false;
                    }
                    yield false;
                }
                yield false;
            }
            case IS_IN_JAVA_PROJECT -> this.hasNature(receiver, "org.eclipse.jdt.core.javanature");
            case IS_IN_PLUGIN_PROJECT -> this.hasNature(receiver, PLUGIN_NATURE);
            case IS_IN_MAVEN_PROJECT -> this.hasNature(receiver, MAVEN_NATURE);
            default -> throw new IllegalStateException("Unkown property" + property);
        };
    }

    protected boolean hasNature(Object receiver, String nature) {
        boolean res;
        if (receiver instanceof IResource) {
            IProject project = ((IResource)receiver).getProject();
            if (project != null) {
                try {
                    res = project.hasNature(nature);
                }
                catch (CoreException e) {
                    AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "can't get nature for project " + project.getName(), (Throwable)e));
                    res = false;
                }
            } else {
                res = false;
            }
        } else {
            res = false;
        }
        return res;
    }
}

