/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.errors;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.editor.actions.RefreshAction;
import org.eclipse.wb.internal.core.editor.actions.SwitchAction;
import org.eclipse.wb.internal.core.editor.errors.ExceptionComposite;
import org.eclipse.wb.internal.core.editor.errors.report2.IReportEntry;
import org.eclipse.wb.internal.core.editor.errors.report2.StringFileReportEntry;
import org.eclipse.wb.internal.core.editor.errors.report2.ZipFileErrorReport;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class JavaExceptionComposite
extends ExceptionComposite {
    private ICompilationUnit m_compilationUnit;

    public JavaExceptionComposite(Composite parent, int style) {
        super(parent, style);
    }

    public void setException(Throwable e, Image screenshot, ICompilationUnit compilationUnit, JavaInfo javaInfo) {
        this.setException0(e, screenshot);
        Assert.isNotNull((Object)compilationUnit);
        this.m_compilationUnit = compilationUnit;
    }

    protected ZipFileErrorReport getZipFileErrorReport() {
        IProject project = this.m_compilationUnit.getJavaProject().getProject();
        return new ZipFileErrorReport(this.getScreenshotImage(), project, JavaExceptionComposite.getSourceFileReport(this.m_compilationUnit));
    }

    protected void doShowSource(int sourcePosition) {
        SwitchAction.showSource(sourcePosition);
    }

    protected void doRefresh() {
        new RefreshAction().run();
    }

    public static IReportEntry getSourceFileReport(ICompilationUnit compilationUnit) {
        try {
            return new StringFileReportEntry(compilationUnit.getElementName(), compilationUnit.getSource());
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

