/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.model.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.model.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.DNodeContainerQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.DNodeQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.internal.refresh.borderednode.CanonicalDBorderItemLocator;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutUtils;
import org.eclipse.sirius.diagram.ui.tools.api.util.GMFNotationHelper;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.AlphaDropShadowBorder;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.style.LabelBorderStyleDescription;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;

public final class GMFHelper {
    private static final Insets FREEFORM_CONTAINER_INSETS = new Insets(5, 4, 4, 4);
    private static final Insets LIST_CONTAINER_INSETS = new Insets(4, 0, 0, 0);
    private static final Insets HV_STACK_CONTAINER_INSETS = new Insets(4, 0, 0, 0);
    private static final int ICON_TEXT_GAP = 3;
    private static Map<Node, Rectangle> boundsCache = new HashMap<Node, Rectangle>();

    private GMFHelper() {
    }

    public static Point getAbsoluteLocation(Node node, boolean insetsAware, boolean adaptBorderNodeLocation) {
        EObject eObject;
        Point location = new Point(0, 0);
        LayoutConstraint layoutConstraint = node.getLayoutConstraint();
        if (layoutConstraint instanceof Bounds) {
            Bounds gmfBounds = (Bounds)layoutConstraint;
            if (!new ViewQuery((View)node).isRegion()) {
                location.setX(gmfBounds.getX());
                location.setY(gmfBounds.getY());
            }
        }
        ViewQuery viewQuery = new ViewQuery((View)node);
        if (adaptBorderNodeLocation && viewQuery.isBorderedNode() && layoutConstraint instanceof Bounds) {
            Node parentNode;
            LayoutConstraint layoutConstraint2;
            AbstractDNode parentAbstractDNode;
            DNode dNode;
            EObject eObject2;
            Bounds gmfBounds = (Bounds)layoutConstraint;
            eObject = node.getElement();
            if (eObject instanceof DNode && (eObject2 = (dNode = (DNode)eObject).eContainer()) instanceof AbstractDNode && (parentAbstractDNode = (AbstractDNode)eObject2).getOwnedBorderedNodes().contains((Object)dNode) && (layoutConstraint2 = (parentNode = (Node)node.eContainer()).getLayoutConstraint()) instanceof Bounds) {
                Bounds parentBounds = (Bounds)layoutConstraint2;
                int position = CanonicalDBorderItemLocator.findClosestSideOfParent(new Rectangle(gmfBounds.getX(), gmfBounds.getY(), gmfBounds.getWidth(), gmfBounds.getHeight()), new Rectangle(parentBounds.getX(), parentBounds.getY(), parentBounds.getWidth(), parentBounds.getHeight()));
                GMFHelper.centerLocationIfZero(location, position, parentBounds, gmfBounds);
            }
        }
        if (viewQuery.isListCompartment()) {
            titleBounds = GMFHelper.getAbsoluteBounds(GMFHelper.getPreviousChild(node), true, false, false, false);
            location.translate(titleBounds.preciseX(), titleBounds.preciseY() + titleBounds.preciseHeight());
            location.translate(0, 5);
        } else if (viewQuery.isListItem()) {
            eObject = node.eContainer();
            if (eObject instanceof Node) {
                container = (Node)eObject;
                if (container.getChildren().get(0) == node) {
                    parentNodeLocation = GMFHelper.getAbsoluteLocation(container, insetsAware, false);
                    location.translate(parentNodeLocation);
                    if (insetsAware) {
                        GMFHelper.translateWithInsets(location, node);
                    }
                } else {
                    previousChildBounds = GMFHelper.getAbsoluteBounds(GMFHelper.getPreviousChild(node), true, false, false, false);
                    location.translate(previousChildBounds.preciseX(), previousChildBounds.preciseY() + previousChildBounds.preciseHeight());
                }
            }
        } else if (viewQuery.isRegionContainerCompartment()) {
            titleBounds = GMFHelper.getAbsoluteBounds(GMFHelper.getPreviousChild(node), true, false, false, false);
            location.translate(titleBounds.preciseX(), titleBounds.preciseY() + titleBounds.preciseHeight());
            location.translate(0, 5);
        } else if (viewQuery.isVerticalRegion()) {
            eObject = node.eContainer();
            if (eObject instanceof Node) {
                container = (Node)eObject;
                if (container.getChildren().get(0) == node) {
                    parentNodeLocation = GMFHelper.getAbsoluteLocation(container, insetsAware, false);
                    location.translate(parentNodeLocation);
                    if (insetsAware) {
                        GMFHelper.translateWithInsets(location, node);
                    }
                } else {
                    previousChildBounds = GMFHelper.getAbsoluteBounds(GMFHelper.getPreviousChild(node), true, false, false, false);
                    location.translate(previousChildBounds.preciseX(), previousChildBounds.preciseY() + previousChildBounds.preciseHeight());
                }
            }
        } else if (viewQuery.isHorizontalRegion()) {
            eObject = node.eContainer();
            if (eObject instanceof Node) {
                container = (Node)eObject;
                if (container.getChildren().get(0) == node) {
                    parentNodeLocation = GMFHelper.getAbsoluteLocation(container, insetsAware, false);
                    location.translate(parentNodeLocation);
                    if (insetsAware) {
                        GMFHelper.translateWithInsets(location, node);
                    }
                } else {
                    previousChildBounds = GMFHelper.getAbsoluteBounds(GMFHelper.getPreviousChild(node), true, false, false, false);
                    location.translate(previousChildBounds.preciseX() + previousChildBounds.preciseWidth(), previousChildBounds.preciseY());
                }
            }
        } else {
            eObject = node.eContainer();
            if (eObject instanceof Node) {
                container = (Node)eObject;
                parentNodeLocation = GMFHelper.getAbsoluteLocation(container, insetsAware, true);
                location.translate(parentNodeLocation);
                if (insetsAware) {
                    GMFHelper.translateWithInsets(location, node);
                }
            }
        }
        return location;
    }

    private static Node getPreviousChild(Node searchedNode) {
        Node previousChild = null;
        boolean found = false;
        EObject eObject = searchedNode.eContainer();
        if (eObject instanceof Node) {
            Node container = (Node)eObject;
            Iterator children = container.getChildren().iterator();
            while (children.hasNext() && !found) {
                View child = (View)children.next();
                if (!(child instanceof Node)) continue;
                Node nodeChild = (Node)child;
                if (searchedNode == nodeChild) {
                    found = true;
                    continue;
                }
                previousChild = nodeChild;
            }
        }
        if (found) {
            return previousChild;
        }
        return null;
    }

    public static Dimension getTopLeftInsets(Node container) {
        Dimension result = new Dimension(0, 0);
        NodeQuery nodeQuery = new NodeQuery(container);
        if (nodeQuery.isContainer()) {
            EObject element = container.getElement();
            if (element instanceof DDiagramElementContainer) {
                DDiagramElementContainer ddec = (DDiagramElementContainer)element;
                if (ddec instanceof DNodeContainer) {
                    DNodeContainer dNodeContainer = (DNodeContainer)ddec;
                    if (new DNodeContainerExperimentalQuery(dNodeContainer).isRegionContainer()) {
                        result.setHeight(GMFHelper.HV_STACK_CONTAINER_INSETS.top);
                    } else if (GMFHelper.hasFullLabelBorder(ddec)) {
                        result.setHeight(GMFHelper.FREEFORM_CONTAINER_INSETS.top);
                    } else if (!new DDiagramElementContainerExperimentalQuery(ddec).isRegion()) {
                        result.setWidth(GMFHelper.FREEFORM_CONTAINER_INSETS.left);
                        result.setHeight(GMFHelper.FREEFORM_CONTAINER_INSETS.top);
                    }
                } else if (element instanceof DNodeList) {
                    result.setWidth(GMFHelper.LIST_CONTAINER_INSETS.left);
                    result.setHeight(GMFHelper.LIST_CONTAINER_INSETS.top);
                }
                if (!new DDiagramElementContainerExperimentalQuery(ddec).isRegion()) {
                    Dimension borderSize = GMFHelper.getBorderSize(ddec);
                    result.setWidth(result.width() + borderSize.width());
                    result.setHeight(result.height() + borderSize.height());
                }
            }
        } else if (nodeQuery.isListCompartment()) {
            result.setWidth(4);
            result.setHeight(1);
        } else if (nodeQuery.isRegionContainerCompartment()) {
            result.setWidth(0);
            result.setHeight(1);
        }
        return result;
    }

    public static Dimension getContainerTopLeftInsets(Node node, boolean searchFirstParentContainer) {
        Dimension result = new Dimension(0, 0);
        EObject nodeContainer = node.eContainer();
        if (nodeContainer instanceof Node) {
            Node parentNode = (Node)nodeContainer;
            NodeQuery nodeQuery = new NodeQuery(parentNode);
            if (nodeQuery.isContainer() || nodeQuery.isListCompartment() || nodeQuery.isRegionContainerCompartment()) {
                result = GMFHelper.getTopLeftInsets(parentNode);
            } else if (searchFirstParentContainer) {
                result = GMFHelper.getContainerTopLeftInsets(parentNode, searchFirstParentContainer);
            }
        }
        return result;
    }

    private static Dimension getBottomRightInsets(Node container) {
        Dimension result = new Dimension(0, 0);
        NodeQuery nodeQuery = new NodeQuery(container);
        if (nodeQuery.isContainer()) {
            EObject element = container.getElement();
            if (element instanceof DDiagramElementContainer) {
                DDiagramElementContainer ddec = (DDiagramElementContainer)element;
                if (ddec instanceof DNodeContainer) {
                    DNodeContainer dNodeContainer = (DNodeContainer)ddec;
                    if (new DNodeContainerExperimentalQuery(dNodeContainer).isRegionContainer()) {
                        result.setWidth(GMFHelper.LIST_CONTAINER_INSETS.right);
                        result.setHeight(GMFHelper.LIST_CONTAINER_INSETS.bottom);
                        Dimension borderSize = GMFHelper.getBorderSize(ddec);
                        result.setWidth(result.width() + borderSize.width());
                        result.setHeight(result.height() + borderSize.height());
                    } else if (new DDiagramElementContainerExperimentalQuery(ddec).isRegion()) {
                        Dimension borderSize = GMFHelper.getBorderSize(ddec);
                        result.setWidth(result.width() + borderSize.width());
                        result.setHeight(result.height() + borderSize.height());
                    } else {
                        if (GMFHelper.hasFullLabelBorder(ddec)) {
                            result.setHeight(GMFHelper.FREEFORM_CONTAINER_INSETS.bottom);
                        } else {
                            result.setWidth(GMFHelper.FREEFORM_CONTAINER_INSETS.right);
                            result.setHeight(GMFHelper.FREEFORM_CONTAINER_INSETS.bottom);
                        }
                        Dimension borderSize = GMFHelper.getBorderSize(ddec);
                        result.setWidth(result.width() + borderSize.width() * 2);
                        result.setHeight(result.height() + borderSize.height() * 2);
                    }
                } else if (ddec instanceof DNodeList) {
                    result.setWidth(GMFHelper.LIST_CONTAINER_INSETS.right);
                    result.setHeight(GMFHelper.LIST_CONTAINER_INSETS.bottom);
                    Dimension borderSize = GMFHelper.getBorderSize(ddec);
                    result.setWidth(result.width() + borderSize.width());
                    result.setHeight(result.height() + borderSize.height());
                }
            }
        } else if (nodeQuery.isListCompartment()) {
            result.setWidth(4);
            result.setHeight(0);
        }
        return result;
    }

    public static Dimension getContainerTopLeftInsetsAfterLabel(Node node, boolean searchFirstParentContainer) {
        Dimension result = new Dimension(0, 0);
        EObject nodeContainer = node.eContainer();
        if (nodeContainer instanceof Node) {
            Node parentNode = (Node)nodeContainer;
            NodeQuery nodeQuery = new NodeQuery(parentNode);
            if (nodeQuery.isContainer()) {
                EObject element = parentNode.getElement();
                if (element instanceof DDiagramElementContainer) {
                    DDiagramElementContainer dDiagramElementContainer = (DDiagramElementContainer)element;
                    result.setWidth(GMFHelper.FREEFORM_CONTAINER_INSETS.left);
                    result.setHeight(GMFHelper.FREEFORM_CONTAINER_INSETS.top);
                    Dimension borderSize = GMFHelper.getBorderSize(dDiagramElementContainer);
                    result.setWidth(result.width() + borderSize.width());
                    result.setHeight(result.height() + borderSize.height());
                }
            } else if (searchFirstParentContainer) {
                result = GMFHelper.getContainerTopLeftInsets(parentNode, searchFirstParentContainer);
            }
        }
        return result;
    }

    public static Dimension getBorderSize(DDiagramElementContainer ddec) {
        DDiagramElementContainerExperimentalQuery regionQuery;
        Dimension result = new Dimension(0, 0);
        int borderSize = 0;
        ContainerStyle containerStyle = ddec.getOwnedStyle();
        if (containerStyle != null && containerStyle.getBorderSize() != null) {
            borderSize = containerStyle.getBorderSize();
        }
        if ((regionQuery = new DDiagramElementContainerExperimentalQuery(ddec)).isRegionInHorizontalStack()) {
            result.setWidth(GMFHelper.isFirstRegion(ddec) ? 0 : borderSize);
            result.setHeight(1);
        } else if (regionQuery.isRegionInVerticalStack()) {
            result.setWidth(0);
            result.setHeight(GMFHelper.isFirstRegion(ddec) ? 1 : borderSize);
        } else {
            result.setWidth(borderSize);
            result.setHeight(borderSize);
        }
        return result;
    }

    private static void translateWithInsets(Point locationToTranslate, Node currentNode) {
        NodeQuery nodeQuery = new NodeQuery(currentNode);
        if (!nodeQuery.isBorderedNode()) {
            locationToTranslate.translate(GMFHelper.getContainerTopLeftInsets(currentNode, false));
            EObject eObject = currentNode.eContainer();
            if (eObject instanceof Node) {
                Node container = (Node)eObject;
                if (new ViewQuery((View)currentNode).isListItem() && container.getChildren().get(0) == currentNode) {
                    locationToTranslate.translate(0, 1);
                }
            }
        }
    }

    private static boolean hasFullLabelBorder(DDiagramElementContainer ddec) {
        Optional labelBorderStyle = new DDiagramElementContainerExperimentalQuery(ddec).getLabelBorderStyle();
        return labelBorderStyle.isPresent() && "labelBorderForContainer".equals(((LabelBorderStyleDescription)labelBorderStyle.get()).getId());
    }

    private static boolean isFirstRegion(DDiagramElementContainer ddec) {
        EObject potentialRegionContainer = ddec.eContainer();
        if (potentialRegionContainer instanceof DNodeContainer) {
            DNodeContainer dNodeContainer = (DNodeContainer)potentialRegionContainer;
            Optional<DDiagramElement> optionalDDiagramElement = dNodeContainer.getOwnedDiagramElements().stream().filter(DDiagramElementContainer.class::isInstance).findFirst();
            return optionalDDiagramElement.isPresent() && ddec == optionalDDiagramElement.get();
        }
        return false;
    }

    private static void translateWithInsets(Rectangle boundsToTranslate, Node currentNode) {
        Point location = boundsToTranslate.getLocation();
        GMFHelper.translateWithInsets(location, currentNode);
        boundsToTranslate.setLocation(location);
    }

    @Deprecated
    public static Point getLocation(Node node) {
        return GMFHelper.getAbsoluteLocation(node, true, true);
    }

    private static void centerLocationIfZero(Point location, int position, Bounds parentBounds, Bounds gmfBounds) {
        switch (position) {
            case 1: 
            case 4: {
                if (location.x != 0) break;
                location.setX(location.x + (parentBounds.getWidth() - gmfBounds.getWidth()) / 2);
                break;
            }
            case 8: 
            case 16: {
                if (location.y != 0) break;
                location.setY(location.y + (parentBounds.getHeight() - gmfBounds.getHeight()) / 2);
                break;
            }
        }
    }

    public static Rectangle getAbsoluteBounds(Node node, boolean insetsAware, boolean boxForConnection, boolean recursiveGetBounds, boolean adaptBorderNodeLocation) {
        Rectangle result;
        if (!recursiveGetBounds) {
            boundsCache.clear();
        }
        if (boundsCache.containsKey(node)) {
            result = boundsCache.get(node);
        } else {
            Point location = GMFHelper.getAbsoluteLocation(node, insetsAware, adaptBorderNodeLocation);
            Rectangle bounds = GMFHelper.getBounds(node, false, false, boxForConnection, recursiveGetBounds, location);
            result = new PrecisionRectangle(location.preciseX(), location.preciseY(), bounds.preciseWidth(), bounds.preciseHeight());
            if (recursiveGetBounds) {
                boundsCache.put(node, result);
            }
        }
        return result.getCopy();
    }

    public static Optional<Rectangle> getAbsoluteBounds(Edge edge) {
        return GMFHelper.getAbsoluteBounds(edge, false, false);
    }

    public static Optional<Rectangle> getAbsoluteBounds(Edge edge, boolean insetsAware, boolean boxForConnection) {
        Optional<Rectangle> optionalSourceBounds = GMFHelper.getAbsoluteBounds(edge.getSource(), insetsAware, boxForConnection);
        Optional<Rectangle> optionalTargetBounds = GMFHelper.getAbsoluteBounds(edge.getTarget(), insetsAware, boxForConnection);
        if (optionalSourceBounds.isPresent() && optionalTargetBounds.isPresent()) {
            return Optional.ofNullable(optionalSourceBounds.get().union(optionalTargetBounds.get()));
        }
        return Optional.empty();
    }

    public static Optional<Rectangle> getAbsoluteBounds(View view) {
        return GMFHelper.getAbsoluteBounds(view, false);
    }

    public static Optional<Rectangle> getAbsoluteBounds(View view, boolean insetsAware) {
        return GMFHelper.getAbsoluteBounds(view, insetsAware, false);
    }

    public static Optional<Rectangle> getAbsoluteBounds(View view, boolean insetsAware, boolean boxForConnection) {
        Optional<Rectangle> result = Optional.empty();
        if (view instanceof Node) {
            result = Optional.ofNullable(GMFHelper.getAbsoluteBounds((Node)view, insetsAware, boxForConnection, false, true));
        } else if (view instanceof Edge) {
            result = GMFHelper.getAbsoluteBounds((Edge)view, insetsAware, boxForConnection);
        }
        return result;
    }

    public static Rectangle getBounds(Node node) {
        return GMFHelper.getBounds(node, false);
    }

    public static Rectangle getBounds(Node node, boolean useFigureForAutoSizeConstraint) {
        return GMFHelper.getBounds(node, useFigureForAutoSizeConstraint, false);
    }

    public static Rectangle getBounds(Node node, boolean useFigureForAutoSizeConstraint, boolean forceFigureAutoSize) {
        return GMFHelper.getBounds(node, useFigureForAutoSizeConstraint, forceFigureAutoSize, false, false, new Point());
    }

    public static Rectangle getBounds(Node node, boolean useFigureForAutoSizeConstraint, boolean forceFigureAutoSize, boolean boxForConnection, boolean recursiveGetBounds, Point computedAbsoluteLocation) {
        PrecisionRectangle bounds = new PrecisionRectangle(computedAbsoluteLocation.preciseX(), computedAbsoluteLocation.preciseY(), 0.0, 0.0);
        LayoutConstraint layoutConstraint = node.getLayoutConstraint();
        EObject element = node.getElement();
        if (element instanceof AbstractDNode) {
            AbstractDNode abstractDNode = (AbstractDNode)element;
            if (layoutConstraint instanceof Size) {
                Size size = (Size)layoutConstraint;
                bounds.setWidth(size.getWidth());
                bounds.setHeight(size.getHeight());
            } else {
                bounds.setWidth(-1);
                bounds.setHeight(-1);
            }
            ViewQuery viewQuery = new ViewQuery((View)node);
            if (viewQuery.isForNameEditPart() || viewQuery.isListItem()) {
                if (abstractDNode.getName() == null || abstractDNode.getName().length() == 0) {
                    if (bounds.width == -1) {
                        bounds.setWidth(0);
                    }
                    if (bounds.height == -1) {
                        bounds.setHeight(0);
                    }
                } else {
                    GMFHelper.replaceAutoSize(node, bounds, useFigureForAutoSizeConstraint, GMFHelper.getLabelDimension(node, new Dimension(50, 20)), recursiveGetBounds);
                }
            } else {
                GMFHelper.replaceAutoSize(node, bounds, useFigureForAutoSizeConstraint, null, recursiveGetBounds);
            }
            if (boxForConnection) {
                double shadowBorderSize = GMFHelper.getShadowBorderSize(node);
                bounds.setPreciseWidth(bounds.preciseWidth() - shadowBorderSize);
                bounds.setPreciseHeight(bounds.preciseHeight() - shadowBorderSize);
            }
        }
        return bounds;
    }

    public static double getShadowBorderSize(Node node) {
        double shadowBorderSize = 0.0;
        if (GMFHelper.isShadowBorderNeeded(node)) {
            shadowBorderSize = AlphaDropShadowBorder.getDefaultShadowSize();
        }
        return shadowBorderSize;
    }

    private static boolean isShadowBorderNeeded(Node node) {
        boolean needShadowBorder = false;
        EObject element = node.getElement();
        ViewQuery viewQuery = new ViewQuery((View)node);
        if (!viewQuery.isFreeFormCompartment() && !viewQuery.isListCompartment() && !viewQuery.isForNameEditPart() && element instanceof DDiagramElementContainer) {
            DDiagramElementContainer ddec = (DDiagramElementContainer)element;
            needShadowBorder = !new DDiagramElementContainerExperimentalQuery(ddec).isRegion() && !(ddec.getOwnedStyle() instanceof WorkspaceImage);
        }
        return needShadowBorder;
    }

    private static void replaceAutoSize(Node node, PrecisionRectangle bounds, boolean useFigureForAutoSizeConstraint, Dimension providedDefaultSize, boolean recursive) {
        if (bounds.width == -1 || bounds.height == -1) {
            Dimension defaultSize = providedDefaultSize;
            if (providedDefaultSize == null) {
                EObject element = node.getElement();
                ViewQuery nodeQuery = new ViewQuery((View)node);
                if (nodeQuery.isFreeFormCompartment() || nodeQuery.isListCompartment()) {
                    defaultSize = new Dimension(11, 11);
                    if (node.getChildren().isEmpty() && (nodeQuery.isListCompartment() || nodeQuery.isVerticalRegionContainerCompartment() || nodeQuery.isHorizontalRegionContainerCompartment())) {
                        defaultSize.expand(0, 1);
                    }
                } else if (element instanceof AbstractDNode) {
                    AbstractDNode abstractDNode = (AbstractDNode)element;
                    defaultSize = GMFHelper.getDefaultSize(abstractDNode);
                }
            }
            if (useFigureForAutoSizeConstraint) {
                Optional<GraphicalEditPart> optionalTargetEditPart = GMFHelper.getGraphicalEditPart((View)node);
                if (optionalTargetEditPart.isPresent()) {
                    GraphicalEditPart graphicalEditPart = optionalTargetEditPart.get();
                    if (graphicalEditPart instanceof AbstractDiagramElementContainerEditPart) {
                        AbstractDiagramElementContainerEditPart abstractDiagramElementContainerEditPart = (AbstractDiagramElementContainerEditPart)graphicalEditPart;
                        abstractDiagramElementContainerEditPart.forceFigureAutosize();
                        ((GraphicalEditPart)graphicalEditPart.getParent()).getFigure().validate();
                    }
                    Rectangle figureBounds = graphicalEditPart.getFigure().getBounds();
                    if (bounds.width == -1) {
                        bounds.setWidth(figureBounds.width);
                    }
                    if (bounds.height == -1) {
                        bounds.setHeight(figureBounds.height);
                    }
                } else {
                    GMFHelper.lookForNextRegionLocation((Rectangle)bounds, node);
                }
            } else {
                Rectangle childrenBounds = GMFHelper.getChildrenBounds(node, recursive);
                double shadowBorderSize = GMFHelper.getShadowBorderSize(node);
                Dimension bottomRightInsets = GMFHelper.getBottomRightInsets(node);
                int borderNodesSides = 0;
                if (recursive) {
                    borderNodesSides = GMFHelper.getBorderNodesSides(node, childrenBounds);
                }
                boolean isBorderNodeOnRightSide = (4 & borderNodesSides) == 4;
                boolean isBorderNodeOnBottomSide = (0x20 & borderNodesSides) == 32;
                childrenBounds.resize(isBorderNodeOnRightSide ? 0.0 : (double)bottomRightInsets.width() + shadowBorderSize, isBorderNodeOnBottomSide ? 0.0 : (double)bottomRightInsets.height() + shadowBorderSize);
                if (bounds.width == -1) {
                    bounds.setPreciseWidth(defaultSize.preciseWidth());
                    double deltaWidth = childrenBounds.getRight().preciseX() - bounds.getRight().preciseX();
                    if (deltaWidth > 0.0) {
                        bounds.resize(deltaWidth, 0.0);
                    }
                }
                if (bounds.height == -1) {
                    bounds.setPreciseHeight(defaultSize.preciseHeight());
                    double deltaHeight = childrenBounds.getBottom().preciseY() - bounds.getBottom().preciseY();
                    if (deltaHeight > 0.0) {
                        bounds.resize(0.0, deltaHeight);
                    }
                }
            }
            if (bounds.width == -1) {
                bounds.setWidth(defaultSize.width);
            }
            if (bounds.height == -1) {
                bounds.setHeight(defaultSize.height);
            }
        }
    }

    private static int getBorderNodesSides(Node container, Rectangle containerChildrenBounds) {
        int result = 0;
        ListIterator children = container.getChildren().listIterator();
        while (children.hasNext()) {
            Node nodeChild;
            View child = (View)children.next();
            if (!(child instanceof Node) || !new NodeQuery(nodeChild = (Node)child).isBorderedNode()) continue;
            Rectangle borderNodeBounds = GMFHelper.getAbsoluteBounds(nodeChild, true, false, false, false);
            if (borderNodeBounds.preciseX() == containerChildrenBounds.preciseX()) {
                result |= 1;
            }
            if (borderNodeBounds.preciseY() == containerChildrenBounds.preciseY()) {
                result |= 8;
            }
            if (borderNodeBounds.preciseX() + borderNodeBounds.preciseWidth() == containerChildrenBounds.preciseX() + containerChildrenBounds.preciseWidth()) {
                result |= 4;
            }
            if (borderNodeBounds.preciseY() + borderNodeBounds.preciseHeight() != containerChildrenBounds.preciseY() + containerChildrenBounds.preciseHeight()) continue;
            result |= 0x20;
        }
        return result;
    }

    private static void lookForNextRegionLocation(Rectangle bounds, Node node) {
        EObject element = node.getElement();
        if (element instanceof DDiagramElementContainer) {
            DDiagramElementContainer ddec = (DDiagramElementContainer)element;
            EObject eObject = node.eContainer();
            if (eObject instanceof Node) {
                Node nodeContainer = (Node)eObject;
                DDiagramElementContainerExperimentalQuery query = new DDiagramElementContainerExperimentalQuery(ddec);
                boolean isRegion = query.isRegion();
                EList children = nodeContainer.getChildren();
                int currentIndex = children.indexOf((Object)node);
                if (currentIndex == 0 || !bounds.equals((Object)new Rectangle(0, 0, -1, -1))) {
                    LayoutConstraint layoutConstraint;
                    Node nextNode;
                    int visualID;
                    Object object;
                    int nextIndex = currentIndex + 1;
                    if (isRegion && nextIndex != 0 && nextIndex < children.size() && (object = children.get(nextIndex)) instanceof Node && (3008 == (visualID = SiriusVisualIDRegistry.getVisualID((nextNode = (Node)object).getType())) || 2003 == visualID || 3009 == visualID) && (layoutConstraint = nextNode.getLayoutConstraint()) instanceof Location) {
                        Location nextLocation = (Location)layoutConstraint;
                        if (bounds.width == -1 && query.isRegionInHorizontalStack() && nextLocation.getX() != 0) {
                            bounds.setWidth(nextLocation.getX() - bounds.x);
                        }
                        if (bounds.height == -1 && query.isRegionInVerticalStack() && nextLocation.getY() != 0) {
                            bounds.setHeight(nextLocation.getY() - bounds.y);
                        }
                    }
                }
            }
        }
    }

    private static Rectangle getChildrenBounds(Node container, boolean considerBorderNodes) {
        ViewQuery containerViewQuery;
        PrecisionRectangle result = null;
        if (container.getChildren().isEmpty()) {
            result = new PrecisionRectangle();
        }
        if ((containerViewQuery = new ViewQuery((View)container)).isListContainer() || containerViewQuery.isListCompartment() || containerViewQuery.isVerticalRegionContainerCompartment()) {
            if (!container.getChildren().isEmpty()) {
                Node lastChild = GMFHelper.getLastChild(container, considerBorderNodes);
                result = GMFHelper.getAbsoluteBounds(lastChild, true, false, true, false);
            }
        } else {
            ListIterator children = container.getChildren().listIterator();
            while (children.hasNext()) {
                View child = (View)children.next();
                if (!(child instanceof Node)) continue;
                Node nodeChild = (Node)child;
                if (!considerBorderNodes && new NodeQuery(nodeChild).isBorderedNode()) continue;
                Rectangle childAbsoluteBounds = GMFHelper.getAbsoluteBounds(nodeChild, true, false, true, false);
                if (result == null) {
                    result = childAbsoluteBounds.getCopy();
                    continue;
                }
                result.union(childAbsoluteBounds);
            }
        }
        return result;
    }

    private static Node getLastChild(Node container, boolean considerBorderNodes) {
        int i = container.getChildren().size() - 1;
        while (i >= 0) {
            Node currentNode = (Node)container.getChildren().get(i);
            if (considerBorderNodes || !new NodeQuery(currentNode).isBorderedNode()) {
                return currentNode;
            }
            --i;
        }
        return null;
    }

    private static Dimension getDefaultSize(AbstractDNode abstractDNode) {
        Dimension defaultSize = new Dimension(-1, -1);
        if (abstractDNode instanceof DNode) {
            DNode dNode = (DNode)abstractDNode;
            defaultSize = new DNodeQuery(dNode).getDefaultDimension();
        } else if (abstractDNode instanceof DNodeContainer) {
            DNodeContainer dNodeContainer = (DNodeContainer)abstractDNode;
            defaultSize = new DNodeContainerQuery(dNodeContainer).getDefaultDimension();
        } else if (abstractDNode instanceof DNodeList) {
            defaultSize = LayoutUtils.NEW_DEFAULT_CONTAINER_DIMENSION;
        }
        return defaultSize;
    }

    public static Optional<GraphicalEditPart> getGraphicalEditPart(View view) {
        if (view != null) {
            Diagram gmfDiagram = view.getDiagram();
            IEditorPart editor = EclipseUIUtil.getActiveEditor();
            if (GMFHelper.isEditorFor(editor, gmfDiagram)) {
                return GMFHelper.getGraphicalEditPart(view, (DiagramEditor)editor);
            }
            EObject eObject = gmfDiagram.getElement();
            if (eObject instanceof DDiagram) {
                DDiagram dDiagram = (DDiagram)eObject;
                for (IEditingSession uiSession : SessionUIManager.INSTANCE.getUISessions()) {
                    DialectEditor dialectEditor = uiSession.getEditor((DRepresentation)dDiagram);
                    if (!GMFHelper.isEditorFor((IEditorPart)dialectEditor, gmfDiagram)) continue;
                    return GMFHelper.getGraphicalEditPart(view, (DiagramEditor)dialectEditor);
                }
            }
        }
        return Optional.empty();
    }

    private static boolean isEditorFor(IEditorPart editor, Diagram diagram) {
        DiagramEditor diagramEditor;
        return editor instanceof DiagramEditor && (diagramEditor = (DiagramEditor)editor).getDiagram() == diagram;
    }

    public static Optional<GraphicalEditPart> getGraphicalEditPart(View view, DiagramEditor editor) {
        Optional<GraphicalEditPart> result = Optional.empty();
        Map editPartRegistry = editor.getDiagramGraphicalViewer().getEditPartRegistry();
        EditPart targetEditPart = (EditPart)editPartRegistry.get(view);
        if (targetEditPart instanceof GraphicalEditPart) {
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)targetEditPart;
            result = Optional.of(graphicalEditPart);
        }
        return result;
    }

    public static List<Point> getPointsFromSource(ConnectionEditPart edgeEditPart) throws IllegalArgumentException {
        Object object = edgeEditPart.getModel();
        if (object instanceof Edge) {
            Edge gmfEdge = (Edge)object;
            IFigure iFigure = edgeEditPart.getFigure();
            if (iFigure instanceof Connection) {
                Connection connectionFigure = (Connection)iFigure;
                ArrayList<Point> result = new ArrayList<Point>();
                Point srcAnchorLoc = connectionFigure.getSourceAnchor().getReferencePoint();
                connectionFigure.translateToRelative((Translatable)srcAnchorLoc);
                RelativeBendpoints bp = (RelativeBendpoints)gmfEdge.getBendpoints();
                int i = 0;
                while (i < bp.getPoints().size()) {
                    RelativeBendpoint rbp = (RelativeBendpoint)bp.getPoints().get(i);
                    Point fromSrc = srcAnchorLoc.getTranslated(rbp.getSourceX(), rbp.getSourceY());
                    result.add(fromSrc);
                    ++i;
                }
                return result;
            }
        }
        throw new IllegalArgumentException(Messages.GMFHelper_invalidEdgeModelAndFigure);
    }

    public static List<Point> getPointsFromTarget(ConnectionEditPart edgeEditPart) throws IllegalArgumentException {
        Object object = edgeEditPart.getModel();
        if (object instanceof Edge) {
            Edge gmfEdge = (Edge)object;
            IFigure iFigure = edgeEditPart.getFigure();
            if (iFigure instanceof Connection) {
                Connection connectionFigure = (Connection)iFigure;
                ArrayList<Point> result = new ArrayList<Point>();
                Point tgtAnchorLoc = connectionFigure.getTargetAnchor().getReferencePoint();
                connectionFigure.translateToRelative((Translatable)tgtAnchorLoc);
                RelativeBendpoints bp = (RelativeBendpoints)gmfEdge.getBendpoints();
                int i = 0;
                while (i < bp.getPoints().size()) {
                    RelativeBendpoint rbp = (RelativeBendpoint)bp.getPoints().get(i);
                    Point fromTgt = tgtAnchorLoc.getTranslated(rbp.getTargetX(), rbp.getTargetY());
                    result.add(fromTgt);
                    ++i;
                }
                return result;
            }
        }
        throw new IllegalArgumentException(Messages.GMFHelper_invalidEdgeModelAndFigure);
    }

    public static Dimension getLabelDimension(Node node, Dimension defaultDimension) {
        Dimension labelSize = defaultDimension;
        ViewQuery viewQuery = new ViewQuery((View)node);
        EObject element = node.getElement();
        if (element instanceof DDiagramElement) {
            DDiagramElement dDiagramElement = (DDiagramElement)element;
            Style siriusStyle = dDiagramElement.getStyle();
            if (!new DDiagramElementQuery(dDiagramElement).isLabelHidden() && siriusStyle instanceof BasicLabelStyle) {
                FontStyle fontStyle;
                String currentFontName;
                org.eclipse.gmf.runtime.notation.Style style;
                BasicLabelStyle bls = (BasicLabelStyle)siriusStyle;
                String fontName = (String)viewQuery.getDefaultValue(NotationPackage.Literals.FONT_STYLE__FONT_NAME);
                Optional<org.eclipse.gmf.runtime.notation.Style> optionalStyle = GMFHelper.getFontStyleOf(node);
                if (optionalStyle.isPresent() && (style = optionalStyle.get()) instanceof FontStyle && (currentFontName = (fontStyle = (FontStyle)style).getFontName()) != null && !currentFontName.isEmpty()) {
                    fontName = currentFontName;
                }
                Font defaultFont = VisualBindingManager.getDefault().getFontFromLabelStyle(bls, fontName);
                try {
                    labelSize = FigureUtilities.getStringExtents((String)dDiagramElement.getName(), (Font)defaultFont);
                    if (bls.isShowIcon()) {
                        Dimension iconDimension = GMFHelper.getIconDimension((DSemanticDecorator)dDiagramElement, bls);
                        labelSize.setHeight(Math.max(labelSize.height(), iconDimension.height));
                        labelSize.setWidth(labelSize.width() + 3 + iconDimension.width);
                    }
                }
                catch (SWTException sWTException) {}
            }
        }
        return labelSize;
    }

    private static Optional<org.eclipse.gmf.runtime.notation.Style> getFontStyleOf(Node node) {
        EObject eObject;
        org.eclipse.gmf.runtime.notation.Style style = node.getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style == null && (eObject = node.eContainer()) instanceof View) {
            View container = (View)eObject;
            style = container.getStyle(NotationPackage.eINSTANCE.getFontStyle());
        }
        return Optional.ofNullable(style);
    }

    private static Dimension getIconDimension(DSemanticDecorator dSemanticDecorator, BasicLabelStyle bls) {
        IItemLabelProvider labelProvider;
        ImageDescriptor descriptor = null;
        EObject target = dSemanticDecorator.getTarget();
        if (!StringUtil.isEmpty((String)bls.getIconPath())) {
            String iconPath = bls.getIconPath();
            File imageFile = FileProvider.getDefault().getFile((IPath)new Path(iconPath));
            if (imageFile != null && imageFile.exists() && imageFile.canRead()) {
                try {
                    descriptor = DiagramUIPlugin.Implementation.findImageDescriptor(imageFile.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        } else if (target != null && (labelProvider = (IItemLabelProvider)DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory().adapt((Notifier)target, IItemLabelProvider.class)) != null) {
            descriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage((Object)target));
        }
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        Image icon = DiagramUIPlugin.getPlugin().getImage(descriptor);
        return new Dimension(icon.getBounds().width, icon.getBounds().height);
    }

    private static List<Edge> getIncomingOutgoingEdges(View view) {
        ArrayList<Edge> edgesToDelete = new ArrayList<Edge>();
        edgesToDelete.addAll((Collection<Edge>)view.getSourceEdges());
        edgesToDelete.addAll((Collection<Edge>)view.getTargetEdges());
        EList children = view.getChildren();
        for (View child : children) {
            edgesToDelete.addAll(GMFHelper.getIncomingOutgoingEdges(child));
        }
        return edgesToDelete;
    }

    public static List<Edge> getAttachedEdges(Collection<View> views) {
        return views.stream().flatMap(view -> GMFHelper.getIncomingOutgoingEdges(view).stream()).toList();
    }

    public static List<Edge> getAttachedEdgesRecursively(Collection<? extends View> edges) {
        ArrayList<Edge> resursivlyAttachedEdges = new ArrayList<Edge>();
        ArrayList<? extends View> remainingEdges = new ArrayList<View>(edges);
        while (!remainingEdges.isEmpty()) {
            View view = (View)remainingEdges.stream().findAny().orElseThrow();
            List<Edge> attachedEdges = GMFHelper.getIncomingOutgoingEdges(view);
            attachedEdges.removeAll(resursivlyAttachedEdges);
            attachedEdges.removeAll(remainingEdges);
            remainingEdges.addAll(attachedEdges);
            resursivlyAttachedEdges.addAll(attachedEdges);
            remainingEdges.removeIf(v -> view == v);
        }
        return resursivlyAttachedEdges;
    }

    public static List<Node> getAttachedPGE(View view) {
        List<Edge> noteAttachments = GMFHelper.getIncomingOutgoingEdges(view).stream().filter(GMFNotationHelper::isNoteAttachment).toList();
        return noteAttachments.stream().flatMap(edge -> Stream.of(edge.getSource(), edge.getTarget())).filter(attachedView -> {
            if (attachedView instanceof Node) {
                Node attachedNode = (Node)attachedView;
                return GMFNotationHelper.isNote(attachedNode) || GMFNotationHelper.isTextNote(attachedNode);
            }
            return false;
        }).map(Node.class::cast).toList();
    }

    public static List<Node> getAttachedPGE(Collection<? extends View> views) {
        return views.stream().flatMap(view -> GMFHelper.getAttachedPGE(view).stream()).toList();
    }

    public static void deleteDetachedPGE(Collection<Node> candidatesPGE) {
        for (Node pureGraphicalElement : candidatesPGE) {
            EList sourceEdges = pureGraphicalElement.getSourceEdges();
            EList targetEdges = pureGraphicalElement.getTargetEdges();
            List<Edge> validEdges = Stream.concat(sourceEdges.stream(), targetEdges.stream()).filter(edge -> edge.eContainer() != null).toList();
            if (validEdges.isEmpty()) {
                EcoreUtil.remove((EObject)pureGraphicalElement);
                continue;
            }
            Stream<Edge> visibleEdges = validEdges.stream().filter(View::isVisible);
            if (visibleEdges.count() != 0L) continue;
            pureGraphicalElement.setVisible(false);
        }
    }

    public static List<Node> getElementWithoutVisibleConnection(Collection<Node> elements, Collection<Edge> excludedEdges) {
        return elements.stream().filter(element -> {
            EList sourceEdges = element.getSourceEdges();
            EList targetEdges = element.getTargetEdges();
            Stream edges = Stream.concat(sourceEdges.stream(), targetEdges.stream());
            return edges.noneMatch(edge -> edge.isVisible() && !excludedEdges.contains(edge));
        }).toList();
    }
}

