/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.threads;

import java.util.Iterator;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IStackFrame;
import org.eclipse.mat.snapshot.model.IThreadStack;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="thread_stack")
@Category(value="__hidden__")
@Icon(value="/META-INF/icons/stack_frame.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingthreads.html")
@Subject(value="java.lang.Thread")
public class ThreadStackQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument threadIds;

    public IResult execute(IProgressListener listener) throws Exception {
        InspectionAssert.heapFormatIsNot(this.snapshot, "phd");
        StringBuilder builder = new StringBuilder();
        Iterator iterator = this.threadIds.iterator();
        while (iterator.hasNext()) {
            int[] ids;
            int[] nArray = ids = (int[])iterator.next();
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int threadId = nArray[n2];
                IThreadStack stack = this.snapshot.getThreadStack(threadId);
                if (stack == null) {
                    return new TextResult(MessageUtil.format((String)Messages.ThreadStackQuery_No_Stack, (Object[])new Object[]{"0x" + Long.toHexString(this.snapshot.getObject(threadId).getObjectAddress())}), false);
                }
                IObject threadObject = this.snapshot.getObject(threadId);
                builder.append(threadObject.getTechnicalName()).append(" : ").append(threadObject.getClassSpecificName()).append("\r\n");
                IStackFrame[] iStackFrameArray = stack.getStackFrames();
                int n3 = iStackFrameArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IStackFrame frame = iStackFrameArray[n4];
                    builder.append("  ").append(frame.getText()).append("\r\n");
                    ++n4;
                }
                builder.append("\r\n");
                ++n2;
            }
        }
        return new TextResult(builder.toString(), false);
    }
}

