/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dnd;

import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.spi.cdo.DefaultCDOMerger;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.net4j.util.ui.dnd.DNDDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;

public class CDOMergeDropAdapter
extends DNDDropAdapter<TreeSelection> {
    public static final Transfer[] TRANSFERS = new Transfer[]{LocalTransfer.getInstance()};

    protected CDOMergeDropAdapter(StructuredViewer viewer) {
        super(TRANSFERS, viewer);
        this.setExpandEnabled(false);
    }

    protected boolean performDrop(TreeSelection data, Object target) {
        if (target instanceof CDOTransaction) {
            Object[] objectArray = data.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof CDOBranchPoint) {
                    CDOBranchPoint sourceBranchPoint = (CDOBranchPoint)obj;
                    CDOTransaction targetTransaction = (CDOTransaction)target;
                    DefaultCDOMerger.PerFeature.ManyValued merger = new DefaultCDOMerger.PerFeature.ManyValued();
                    targetTransaction.merge(sourceBranchPoint, (CDOMerger)merger);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean validateTarget(Object target, int operation) {
        return target instanceof CDOTransaction && !((CDOTransaction)target).isDirty();
    }

    public static void support(StructuredViewer viewer) {
        int dndOperations = 7;
        viewer.addDropSupport(dndOperations, TRANSFERS, (DropTargetListener)new CDOMergeDropAdapter(viewer));
    }
}

