/*
 * Copyright (c) 2010-2012, 2015, 2016, 2019 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.server.db.mapping;

import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping.Descriptor;

import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;

/**
 * Abstract implementation for {@link ITypeMapping.Factory}. Implementors should implement their custom
 * {@link #create(String)} method and construct the factory using their custom descriptor. Subclasses must have a
 * default constructor!
 *
 * @author Stefan Winkler
 * @since 4.0
 */
public abstract class AbstractTypeMappingFactory extends Factory implements org.eclipse.emf.cdo.server.db.mapping.ITypeMapping.Factory
{
  private ITypeMapping.Descriptor descriptor;

  public AbstractTypeMappingFactory(Descriptor descriptor)
  {
    super(PRODUCT_GROUP, descriptor.getFactoryType());
    this.descriptor = descriptor;
  }

  @Override
  public abstract ITypeMapping create(String description) throws ProductCreationException;

  @Override
  public final Descriptor getDescriptor()
  {
    return descriptor;
  }
}
