/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.GitCreateProjectViaWizardWizard;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class ImportProjectsCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List selectedNodes = this.getSelectedNodes(event);
        if (selectedNodes == null || selectedNodes.isEmpty()) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)UIText.ImportProjectsWrongSelection, (String)UIText.ImportProjectsSelectionInRepositoryRequired);
            return null;
        }
        if (!(selectedNodes.get(0) instanceof RepositoryTreeNode)) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)UIText.ImportProjectsWrongSelection, (String)UIText.ImportProjectsSelectionInRepositoryRequired);
            return null;
        }
        this.openWizard(event, selectedNodes);
        return null;
    }

    private void openWizard(ExecutionEvent event, List<RepositoryTreeNode> selectedNodes) throws ExecutionException {
        IWizardDescriptor descriptor = this.findSmartImportWizardDescriptor();
        if (descriptor == null || this.multipleProjectsSelected(selectedNodes)) {
            RepositoryTreeNode node = this.multipleProjectsSelected(selectedNodes) ? this.findRepoNode(selectedNodes.get(0)) : selectedNodes.get(0);
            String path = this.getPathFromNode(node);
            if (path == null) {
                return;
            }
            this.openGitCreateProjectViaWizardWizard(event, node, path, this.getMultipleSelectedProjects(selectedNodes));
        } else {
            String path = this.getPathFromNode(selectedNodes.get(0));
            this.openSmartImportWizard(event, descriptor, path);
        }
    }

    private boolean multipleProjectsSelected(List<?> selectedNodes) {
        return selectedNodes.size() > 1;
    }

    private List<String> getMultipleSelectedProjects(List<RepositoryTreeNode> pSelectedNodes) {
        if (!this.multipleProjectsSelected(pSelectedNodes)) {
            return Collections.emptyList();
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (RepositoryTreeNode node : pSelectedNodes) {
            String path = this.getPathFromNode(node);
            if (path == null) {
                return null;
            }
            paths.add(path);
        }
        return paths;
    }

    private RepositoryTreeNode findRepoNode(RepositoryTreeNode pNode) {
        RepositoryTreeNode result = pNode;
        while (!result.getType().equals((Object)RepositoryTreeNodeType.REPO)) {
            result = result.getParent();
        }
        return result;
    }

    private String getPathFromNode(RepositoryTreeNode node) {
        switch (node.getType()) {
            case REPO: 
            case WORKINGDIR: {
                return node.getRepository().getWorkTree().toString();
            }
            case FOLDER: {
                return ((File)((FolderNode)node).getObject()).getPath().toString();
            }
        }
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)UIText.ImportProjectsWrongSelection, (String)UIText.ImportProjectsSelectionInRepositoryRequired);
        return null;
    }

    private IWizardDescriptor findSmartImportWizardDescriptor() {
        String smartImportWizardId = "org.eclipse.e4.ui.importer.wizard";
        return PlatformUI.getWorkbench().getImportWizardRegistry().findWizard("org.eclipse.e4.ui.importer.wizard");
    }

    private void openSmartImportWizard(ExecutionEvent event, IWizardDescriptor descriptor, String path) throws ExecutionException {
        try {
            IWorkbenchWizard wizard = descriptor.createWizard();
            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)new File(path)));
            WizardDialog dlg = new WizardDialog(this.getShell(event), (IWizard)wizard);
            dlg.setTitle(wizard.getWindowTitle());
            dlg.setHelpAvailable(false);
            dlg.open();
        }
        catch (CoreException e) {
            throw new ExecutionException("Error during opening smart import wizard.", (Throwable)e);
        }
    }

    private void openGitCreateProjectViaWizardWizard(ExecutionEvent event, RepositoryTreeNode node, String path, List<String> pPaths) {
        if (pPaths.size() == 1) {
            path = pPaths.get(0);
        }
        GitCreateProjectViaWizardWizard wizard = new GitCreateProjectViaWizardWizard(node.getRepository(), path);
        if (pPaths.size() > 1) {
            wizard.setFilter(pPaths);
        }
        WizardDialog dlg = new WizardDialog(this.getShell(event), (IWizard)wizard){

            protected IDialogSettings getDialogBoundsSettings() {
                return Activator.getDefault().getDialogSettings();
            }
        };
        dlg.setHelpAvailable(false);
        dlg.open();
    }
}

