/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.wb.internal.swing.databinding.Messages;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el.ContentAssistProcessor;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el.ElPropertyUiConfiguration;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el.IBeanPropertiesSupport;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el.KeywordsRule;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el.NumbersRule;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el.OperatorsRule;

public final class EvalutionLanguageConfiguration
extends SourceViewerConfiguration {
    private static final String EXPRESSION_TYPE = "__expression_type_";
    private final ElPropertyUiConfiguration m_configuration;
    private final IBeanPropertiesSupport m_propertiesSupport;

    public EvalutionLanguageConfiguration(SourceViewer sourceViewer, IDocument document, ElPropertyUiConfiguration configuration, IBeanPropertiesSupport propertiesSupport) {
        this.m_configuration = configuration;
        this.m_propertiesSupport = propertiesSupport;
        sourceViewer.configure((SourceViewerConfiguration)this);
        EvalutionLanguageConfiguration.configureDocument(document);
        sourceViewer.setDocument(document);
    }

    private static void configureDocument(IDocument document) {
        Token token = new Token((Object)EXPRESSION_TYPE);
        IPredicateRule[] rules = new IPredicateRule[]{new MultiLineRule("${", "}", (IToken)token), new MultiLineRule("#{", "}", (IToken)token)};
        RuleBasedPartitionScanner partitionScanner = new RuleBasedPartitionScanner();
        partitionScanner.setPredicateRules(rules);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)partitionScanner, new String[]{EXPRESSION_TYPE});
        partitioner.connect(document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", EXPRESSION_TYPE};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        this.configureExpressionType(reconciler, sourceViewer);
        this.configureDefaultType(reconciler);
        return reconciler;
    }

    private void configureExpressionType(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.m_configuration.getPropertiesColor())));
        KeywordsRule keywordsRule = new KeywordsRule(sourceViewer, this.m_configuration);
        OperatorsRule operatorsRule = new OperatorsRule(this.m_configuration);
        NumbersRule numbersRule = new NumbersRule(this.m_configuration);
        scanner.setRules(new IRule[]{keywordsRule, operatorsRule, numbersRule});
        DefaultDamagerRepairer repairer = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setDamager((IPresentationDamager)repairer, EXPRESSION_TYPE);
        reconciler.setRepairer((IPresentationRepairer)repairer, EXPRESSION_TYPE);
    }

    private void configureDefaultType(PresentationReconciler reconciler) {
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.m_configuration.getStringsColor())));
        DefaultDamagerRepairer repairer = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setDamager((IPresentationDamager)repairer, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)repairer, "__dftl_partition_content_type");
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        final ContentAssistant contentAssistant = new ContentAssistant();
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)new ContentAssistProcessor(this.m_propertiesSupport, (ResourceManager)resourceManager, true), "__dftl_partition_content_type");
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)new ContentAssistProcessor(this.m_propertiesSupport, (ResourceManager)resourceManager, false), EXPRESSION_TYPE);
        contentAssistant.enableAutoActivation(true);
        contentAssistant.enableAutoInsert(true);
        contentAssistant.setAutoActivationDelay(200);
        contentAssistant.setStatusLineVisible(true);
        contentAssistant.setStatusMessage(Messages.EvalutionLanguageConfiguration_contentAssistMessage);
        sourceViewer.getTextWidget().addDisposeListener(arg_0 -> EvalutionLanguageConfiguration.lambda$0((ResourceManager)resourceManager, arg_0));
        sourceViewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == ' ' && (e.stateMask & 0x40000) != 0) {
                    contentAssistant.showPossibleCompletions();
                }
            }
        });
        return contentAssistant;
    }

    private static /* synthetic */ void lambda$0(ResourceManager resourceManager, DisposeEvent event) {
        resourceManager.dispose();
    }
}

