/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.ImagePiece;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.ImagePrint;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PaperClips;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintPiece;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

class ImageIterator
implements PrintIterator {
    final Device device;
    final ImageData imageData;
    final Point size;
    boolean hasNext;

    ImageIterator(ImagePrint print, Device device) {
        Util.notNull(print, device);
        this.device = device;
        this.imageData = print.imageData;
        Point dpi = device.getDPI();
        this.size = new Point(print.size.x * dpi.x / 72, print.size.y * dpi.y / 72);
        this.hasNext = true;
    }

    ImageIterator(ImageIterator that) {
        this.device = that.device;
        this.imageData = that.imageData;
        this.size = that.size;
        this.hasNext = that.hasNext;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public PrintPiece next(int width, int height) {
        if (!this.hasNext()) {
            PaperClips.error("No more content.");
        }
        if (width < this.size.x || height < this.size.y) {
            return null;
        }
        this.hasNext = false;
        return new ImagePiece(this.device, this.imageData, this.size);
    }

    @Override
    public Point minimumSize() {
        return new Point(this.size.x, this.size.y);
    }

    @Override
    public Point preferredSize() {
        return new Point(this.size.x, this.size.y);
    }

    @Override
    public PrintIterator copy() {
        return this.hasNext ? new ImageIterator(this) : this;
    }
}

