/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda;

import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUserActionExtension;

public class SystemUserActionExtensionManager {
    private String pluginID;
    private String extensionID;
    private boolean read;
    private Vector elements;

    public SystemUserActionExtensionManager(String pluginID, String extensionID) {
        this.pluginID = pluginID;
        this.extensionID = extensionID;
    }

    public SystemUserActionExtension[] getUserActionExtensions(IRSESystemType systemType) {
        int count = 0;
        if (!this.read) {
            this.readExtensions();
        }
        if (this.elements == null || this.elements.size() == 0) {
            return null;
        }
        int idx = 0;
        while (idx < this.elements.size()) {
            SystemUserActionExtension currAction = (SystemUserActionExtension)this.elements.elementAt(idx);
            if (currAction.appliesToSystemType(systemType)) {
                ++count;
            }
            ++idx;
        }
        if (count == 0) {
            return null;
        }
        SystemUserActionExtension[] actions = new SystemUserActionExtension[count];
        count = 0;
        int idx2 = 0;
        while (idx2 < this.elements.size()) {
            SystemUserActionExtension currAction = (SystemUserActionExtension)this.elements.elementAt(idx2);
            if (currAction.appliesToSystemType(systemType)) {
                actions[count++] = currAction;
            }
            ++idx2;
        }
        return actions;
    }

    protected boolean hasBeenRead() {
        return this.read;
    }

    protected void readExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] userActionExtensions = registry.getConfigurationElementsFor(this.pluginID, this.extensionID);
        if (userActionExtensions != null) {
            this.elements = new Vector();
            int idx = 0;
            while (idx < userActionExtensions.length) {
                this.elements.add(this.createUserActionExtension(userActionExtensions[idx]));
                ++idx;
            }
        }
        this.read = true;
    }

    protected SystemUserActionExtension createUserActionExtension(IConfigurationElement element) {
        return new SystemUserActionExtension(element);
    }
}

