/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.subsystems;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteSearchResult;

public class RemoteSearchResult
implements IAdaptable,
IRemoteSearchResult {
    private String _text;
    private int _line = 0;
    private int _index = -1;
    private Object _parent;
    private SystemSearchString _matchingSearchString;
    private IHostSearchResultConfiguration _configuration;
    private List _matches;

    public RemoteSearchResult(IHostSearchResultConfiguration configuration, Object parent, SystemSearchString searchString) {
        this._parent = parent;
        this._matchingSearchString = searchString;
        this._matches = new ArrayList();
        this._configuration = configuration;
    }

    public void setText(String text) {
        this._text = text;
    }

    public void setLine(int line) {
        this._line = line;
    }

    public void setIndex(int index) {
        this._index = index;
    }

    public String getText() {
        return this._text;
    }

    public int getLine() {
        return this._line;
    }

    public int getIndex() {
        return this._index;
    }

    public String getAbsolutePath() {
        if (this._parent instanceof IRemoteFile) {
            return ((IRemoteFile)this._parent).getAbsolutePath();
        }
        return null;
    }

    public Object getParent() {
        return this._parent;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public Object[] getChildren() {
        return null;
    }

    public boolean hasChildren() {
        return false;
    }

    public String getLabel() {
        return this.getText();
    }

    public SystemSearchString getMatchingSearchString() {
        return this._matchingSearchString;
    }

    public void addMatch(int startOffset, int endOffset) {
        this._matches.add(new RemoteSearchResultMatch(startOffset, endOffset));
    }

    public int numOfMatches() {
        return this._matches.size();
    }

    public int getCharStart(int matchIndex) {
        RemoteSearchResultMatch match = (RemoteSearchResultMatch)this._matches.get(matchIndex);
        if (match != null) {
            return match._startOffset;
        }
        return -1;
    }

    public int getCharEnd(int matchIndex) {
        RemoteSearchResultMatch match = (RemoteSearchResultMatch)this._matches.get(matchIndex);
        if (match != null) {
            return match._endOffset;
        }
        return -1;
    }

    public int getCharEnd() {
        return this.getCharEnd(0);
    }

    public int getCharStart() {
        return this.getCharStart(0);
    }

    public IHostSearchResultConfiguration getConfiguration() {
        return this._configuration;
    }

    public void setParent(Object parent) {
        this._parent = parent;
    }

    protected class RemoteSearchResultMatch {
        private int _startOffset = -1;
        private int _endOffset = -1;

        private RemoteSearchResultMatch(int startOffset, int endOffset) {
            this._startOffset = startOffset;
            this._endOffset = endOffset;
        }
    }
}

